/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.call;

import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.TriRpcStatus;
import org.apache.dubbo.rpc.protocol.tri.call.AbstractServerCallListener;
import org.apache.dubbo.rpc.protocol.tri.observer.ServerCallToObserverAdapter;

public class UnaryServerCallListener
extends AbstractServerCallListener {
    private final boolean needWrapper;

    public UnaryServerCallListener(RpcInvocation invocation, Invoker<?> invoker, ServerCallToObserverAdapter<Object> responseObserver, boolean needWrapper) {
        super(invocation, invoker, responseObserver);
        this.needWrapper = needWrapper;
    }

    @Override
    public void onReturn(Object value) {
        this.responseObserver.onNext(value);
        this.responseObserver.onCompleted();
    }

    @Override
    public void onMessage(Object message) {
        if (message instanceof Object[]) {
            this.invocation.setArguments((Object[])message);
        } else {
            this.invocation.setArguments(new Object[]{message});
        }
    }

    @Override
    public void onCancel(TriRpcStatus status) {
    }

    @Override
    protected void doOnResponseHasException(Throwable t) {
        if (this.needWrapper) {
            this.onReturnException((Exception)t);
        } else {
            super.doOnResponseHasException(t);
        }
    }

    private void onReturnException(Exception value) {
        TriRpcStatus status = TriRpcStatus.getStatus(value);
        int exceptionCode = status.code.code;
        if (exceptionCode == TriRpcStatus.UNKNOWN.code.code) {
            exceptionCode = 3;
        }
        this.responseObserver.setExceptionCode(exceptionCode);
        this.responseObserver.setNeedReturnException(true);
        this.onReturn(value);
    }

    @Override
    public void onComplete() {
        this.invoke();
    }
}

