/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.common.utils.CollectionUtils;

public class TripleCustomerProtocolWapper {
    static int makeTag(int fieldNumber, int wireType) {
        return fieldNumber << 3 | wireType;
    }

    public static byte[] varIntEncode(int val) {
        byte[] data = new byte[TripleCustomerProtocolWapper.varIntComputeLength(val)];
        for (int i = 0; i < data.length - 1; ++i) {
            data[i] = (byte)(val & 0x7F | 0x80);
            val >>>= 7;
        }
        data[data.length - 1] = (byte)val;
        return data;
    }

    public static int varIntComputeLength(int val) {
        if (val == 0) {
            return 1;
        }
        int length = 0;
        while (val != 0) {
            val >>>= 7;
            ++length;
        }
        return length;
    }

    public static int readRawVarint32(ByteBuffer byteBuffer) {
        int val = 0;
        int currentPosition = byteBuffer.position();
        int varIntLength = 1;
        byte currentByte = byteBuffer.get();
        while ((currentByte & 0xF0) >> 7 == 1) {
            ++varIntLength;
            currentByte = byteBuffer.get();
        }
        for (int index = currentPosition + varIntLength - 1; index >= currentPosition; --index) {
            val <<= 7;
            val |= byteBuffer.get(index) & 0x7F;
        }
        byteBuffer.position(currentPosition + varIntLength);
        return val;
    }

    public static int extractFieldNumFromTag(int tag) {
        return tag >> 3;
    }

    public static int extractWireTypeFromTag(int tag) {
        return tag & 7;
    }

    public static final class TripleRequestWrapper {
        private String serializeType;
        private List<byte[]> args;
        private List<String> argTypes;

        public String getSerializeType() {
            return this.serializeType;
        }

        public List<byte[]> getArgs() {
            return this.args;
        }

        public List<String> getArgTypes() {
            return this.argTypes;
        }

        public static TripleRequestWrapper parseFrom(byte[] data) {
            TripleRequestWrapper tripleRequestWrapper = new TripleRequestWrapper();
            ByteBuffer byteBuffer = ByteBuffer.wrap(data);
            tripleRequestWrapper.args = new ArrayList<byte[]>();
            tripleRequestWrapper.argTypes = new ArrayList<String>();
            while (byteBuffer.position() < byteBuffer.limit()) {
                int tag = TripleCustomerProtocolWapper.readRawVarint32(byteBuffer);
                int fieldNum = TripleCustomerProtocolWapper.extractFieldNumFromTag(tag);
                int wireType = TripleCustomerProtocolWapper.extractWireTypeFromTag(tag);
                if (wireType != 2) {
                    throw new RuntimeException(String.format("unexpect wireType, expect %d realType %d", 2, wireType));
                }
                if (fieldNum == 1) {
                    int serializeTypeLength = TripleCustomerProtocolWapper.readRawVarint32(byteBuffer);
                    byte[] serializeTypeBytes = new byte[serializeTypeLength];
                    byteBuffer.get(serializeTypeBytes, 0, serializeTypeLength);
                    tripleRequestWrapper.serializeType = new String(serializeTypeBytes);
                    continue;
                }
                if (fieldNum == 2) {
                    int argLength = TripleCustomerProtocolWapper.readRawVarint32(byteBuffer);
                    byte[] argBytes = new byte[argLength];
                    byteBuffer.get(argBytes, 0, argLength);
                    tripleRequestWrapper.args.add(argBytes);
                    continue;
                }
                if (fieldNum == 3) {
                    int argTypeLength = TripleCustomerProtocolWapper.readRawVarint32(byteBuffer);
                    byte[] argTypeBytes = new byte[argTypeLength];
                    byteBuffer.get(argTypeBytes, 0, argTypeLength);
                    tripleRequestWrapper.argTypes.add(new String(argTypeBytes));
                    continue;
                }
                throw new RuntimeException("fieldNum should in (1,2,3)");
            }
            return tripleRequestWrapper;
        }

        public byte[] toByteArray() {
            int totalSize = 0;
            int serializeTypeTag = TripleCustomerProtocolWapper.makeTag(1, 2);
            byte[] serializeTypeTagBytes = TripleCustomerProtocolWapper.varIntEncode(serializeTypeTag);
            byte[] serializeTypeBytes = this.serializeType.getBytes(StandardCharsets.UTF_8);
            byte[] serializeTypeLengthVarIntEncodeBytes = TripleCustomerProtocolWapper.varIntEncode(serializeTypeBytes.length);
            totalSize += serializeTypeTagBytes.length + serializeTypeLengthVarIntEncodeBytes.length + serializeTypeBytes.length;
            int argTypeTag = TripleCustomerProtocolWapper.makeTag(3, 2);
            if (CollectionUtils.isNotEmpty(this.argTypes)) {
                totalSize += TripleCustomerProtocolWapper.varIntComputeLength(argTypeTag) * this.argTypes.size();
                for (String string : this.argTypes) {
                    byte[] argTypeBytes = string.getBytes(StandardCharsets.UTF_8);
                    totalSize += argTypeBytes.length + TripleCustomerProtocolWapper.varIntComputeLength(argTypeBytes.length);
                }
            }
            int argTag = TripleCustomerProtocolWapper.makeTag(2, 2);
            if (CollectionUtils.isNotEmpty(this.args)) {
                totalSize += TripleCustomerProtocolWapper.varIntComputeLength(argTag) * this.args.size();
                for (byte[] arg : this.args) {
                    totalSize += arg.length + TripleCustomerProtocolWapper.varIntComputeLength(arg.length);
                }
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate(totalSize);
            byteBuffer.put(serializeTypeTagBytes).put(serializeTypeLengthVarIntEncodeBytes).put(serializeTypeBytes);
            if (CollectionUtils.isNotEmpty(this.args)) {
                byte[] argTagBytes = TripleCustomerProtocolWapper.varIntEncode(argTag);
                for (byte[] arg : this.args) {
                    byteBuffer.put(argTagBytes).put(TripleCustomerProtocolWapper.varIntEncode(arg.length)).put(arg);
                }
            }
            if (CollectionUtils.isNotEmpty(this.argTypes)) {
                byte[] argTypeTagBytes = TripleCustomerProtocolWapper.varIntEncode(argTypeTag);
                for (String argType : this.argTypes) {
                    byte[] argTypeBytes = argType.getBytes(StandardCharsets.UTF_8);
                    byteBuffer.put(argTypeTagBytes).put(TripleCustomerProtocolWapper.varIntEncode(argTypeBytes.length)).put(argTypeBytes);
                }
            }
            return byteBuffer.array();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TripleRequestWrapper)) {
                return false;
            }
            TripleRequestWrapper that = (TripleRequestWrapper)o;
            return Objects.equals(this.serializeType, that.serializeType) && Objects.equals(this.args, that.args) && Objects.equals(this.argTypes, that.argTypes);
        }

        public int hashCode() {
            return Objects.hash(this.serializeType, this.args, this.argTypes);
        }

        public static final class Builder {
            private String serializeType;
            private final List<byte[]> args = new ArrayList<byte[]>();
            private final List<String> argTypes = new ArrayList<String>();

            public Builder setSerializeType(String serializeType) {
                this.serializeType = serializeType;
                return this;
            }

            public Builder addArgTypes(String argsType) {
                Assert.notEmptyString((String)argsType, (String)"argsType cannot be empty.");
                this.argTypes.add(argsType);
                return this;
            }

            public Builder addArgs(byte[] arg) {
                this.args.add(arg);
                return this;
            }

            public static Builder newBuilder() {
                return new Builder();
            }

            public TripleRequestWrapper build() {
                Assert.notNull((Object)this.serializeType, (String)"serializeType can not be null");
                TripleRequestWrapper tripleRequestWrapper = new TripleRequestWrapper();
                tripleRequestWrapper.args = this.args;
                tripleRequestWrapper.argTypes = this.argTypes;
                tripleRequestWrapper.serializeType = this.serializeType;
                return tripleRequestWrapper;
            }
        }
    }

    public static final class TripleResponseWrapper {
        private String serializeType;
        private byte[] data;
        private String type;

        public String getSerializeType() {
            return this.serializeType;
        }

        public byte[] getData() {
            return this.data;
        }

        public String getType() {
            return this.type;
        }

        public static TripleResponseWrapper parseFrom(byte[] data) {
            TripleResponseWrapper tripleResponseWrapper = new TripleResponseWrapper();
            ByteBuffer byteBuffer = ByteBuffer.wrap(data);
            while (byteBuffer.position() < byteBuffer.limit()) {
                int tag = TripleCustomerProtocolWapper.readRawVarint32(byteBuffer);
                int fieldNum = TripleCustomerProtocolWapper.extractFieldNumFromTag(tag);
                int wireType = TripleCustomerProtocolWapper.extractWireTypeFromTag(tag);
                if (wireType != 2) {
                    throw new RuntimeException(String.format("unexpect wireType, expect %d realType %d", 2, wireType));
                }
                if (fieldNum == 1) {
                    int serializeTypeLength = TripleCustomerProtocolWapper.readRawVarint32(byteBuffer);
                    byte[] serializeTypeBytes = new byte[serializeTypeLength];
                    byteBuffer.get(serializeTypeBytes, 0, serializeTypeLength);
                    tripleResponseWrapper.serializeType = new String(serializeTypeBytes);
                    continue;
                }
                if (fieldNum == 2) {
                    int dataLength = TripleCustomerProtocolWapper.readRawVarint32(byteBuffer);
                    byte[] dataBytes = new byte[dataLength];
                    byteBuffer.get(dataBytes, 0, dataLength);
                    tripleResponseWrapper.data = dataBytes;
                    continue;
                }
                if (fieldNum == 3) {
                    int typeLength = TripleCustomerProtocolWapper.readRawVarint32(byteBuffer);
                    byte[] typeBytes = new byte[typeLength];
                    byteBuffer.get(typeBytes, 0, typeLength);
                    tripleResponseWrapper.type = new String(typeBytes);
                    continue;
                }
                throw new RuntimeException("fieldNum should in (1,2,3)");
            }
            return tripleResponseWrapper;
        }

        public byte[] toByteArray() {
            int totalSize = 0;
            int serializeTypeTag = TripleCustomerProtocolWapper.makeTag(1, 2);
            byte[] serializeTypeTagBytes = TripleCustomerProtocolWapper.varIntEncode(serializeTypeTag);
            byte[] serializeTypeBytes = this.serializeType.getBytes(StandardCharsets.UTF_8);
            byte[] serializeTypeLengthVarIntEncodeBytes = TripleCustomerProtocolWapper.varIntEncode(serializeTypeBytes.length);
            totalSize += serializeTypeTagBytes.length + serializeTypeLengthVarIntEncodeBytes.length + serializeTypeBytes.length;
            int dataTag = TripleCustomerProtocolWapper.makeTag(2, 2);
            if (this.data != null) {
                totalSize += TripleCustomerProtocolWapper.varIntComputeLength(dataTag) + TripleCustomerProtocolWapper.varIntComputeLength(this.data.length) + this.data.length;
            }
            int typeTag = TripleCustomerProtocolWapper.makeTag(3, 2);
            byte[] typeTagBytes = TripleCustomerProtocolWapper.varIntEncode(typeTag);
            byte[] typeBytes = this.type.getBytes(StandardCharsets.UTF_8);
            byte[] typeLengthVarIntEncodeBytes = TripleCustomerProtocolWapper.varIntEncode(typeBytes.length);
            ByteBuffer byteBuffer = ByteBuffer.allocate(totalSize += typeTagBytes.length + typeLengthVarIntEncodeBytes.length + typeBytes.length);
            byteBuffer.put(serializeTypeTagBytes).put(serializeTypeLengthVarIntEncodeBytes).put(serializeTypeBytes);
            if (this.data != null) {
                byteBuffer.put(TripleCustomerProtocolWapper.varIntEncode(dataTag)).put(TripleCustomerProtocolWapper.varIntEncode(this.data.length)).put(this.data);
            }
            byteBuffer.put(typeTagBytes).put(typeLengthVarIntEncodeBytes).put(typeBytes);
            return byteBuffer.array();
        }

        static /* synthetic */ byte[] access$002(TripleResponseWrapper x0, byte[] x1) {
            x0.data = x1;
            return x1;
        }

        public static final class Builder {
            private String serializeType;
            private byte[] data;
            private String type;

            public Builder setSerializeType(String serializeType) {
                this.serializeType = serializeType;
                return this;
            }

            public Builder setData(byte[] data) {
                this.data = data;
                return this;
            }

            public Builder setType(String type) {
                this.type = type;
                return this;
            }

            public static Builder newBuilder() {
                return new Builder();
            }

            public TripleResponseWrapper build() {
                Assert.notNull((Object)this.serializeType, (String)"serializeType can not be null");
                Assert.notNull((Object)this.type, (String)"type can not be null");
                TripleResponseWrapper tripleResponseWrapper = new TripleResponseWrapper();
                TripleResponseWrapper.access$002(tripleResponseWrapper, this.data);
                tripleResponseWrapper.serializeType = this.serializeType;
                tripleResponseWrapper.type = this.type;
                return tripleResponseWrapper;
            }
        }
    }
}

