/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.compiler.support.ClassUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.metadata.MetadataService;

public class URLRevisionResolver {
    public static final String UNKNOWN_REVISION = "X";
    public static final URLRevisionResolver INSTANCE = new URLRevisionResolver();

    public String resolve(String url, String ... others) {
        ArrayList<String> urls = new ArrayList<String>(others.length + 1);
        urls.add(url);
        urls.addAll(Arrays.asList(others));
        return this.resolve((Iterable<String>)urls);
    }

    public String resolve(Iterable<String> urls) {
        List<URL> urlsList = this.toURLsList(urls);
        return this.resolve((Collection<URL>)urlsList);
    }

    public String resolve(Collection<URL> urls) {
        if (CollectionUtils.isEmpty(urls)) {
            return UNKNOWN_REVISION;
        }
        SortedSet<String> methodSignatures = this.resolveMethodSignatures(urls);
        SortedSet<String> urlParameters = this.resolveURLParameters(urls);
        TreeSet<String> values = new TreeSet<String>(methodSignatures);
        values.addAll(urlParameters);
        return values.stream().map(this::hashCode).reduce(Long::sum).map(Long::toHexString).orElse(UNKNOWN_REVISION);
    }

    private List<URL> toURLsList(Iterable<String> urls) {
        if (urls == null) {
            return Collections.emptyList();
        }
        return StreamSupport.stream(urls.spliterator(), false).map(URL::valueOf).filter(url -> this.isNotMetadataService(url.getServiceInterface())).collect(Collectors.toList());
    }

    private SortedSet<String> resolveMethodSignatures(Collection<URL> urls) {
        return urls.stream().map(URL::getServiceInterface).map(ClassUtils::forName).map(Class::getMethods).map(Arrays::asList).flatMap(Collection::stream).map(Object::toString).collect(TreeSet::new, Set::add, Set::addAll);
    }

    private SortedSet<String> resolveURLParameters(Collection<URL> urls) {
        return urls.stream().map(url -> url.removeParameter("pid")).map(url -> url.removeParameter("timestamp")).map(URL::toParameterString).collect(TreeSet::new, Set::add, Set::addAll);
    }

    private long hashCode(String value) {
        long h = 0L;
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            h = 31L * h + (long)chars[i];
        }
        return h;
    }

    private boolean isNotMetadataService(String serviceInterface) {
        return !MetadataService.class.getName().equals(serviceInterface);
    }
}

