/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.profiler;

import java.util.LinkedList;
import java.util.List;
import org.apache.dubbo.common.profiler.ProfilerEntry;
import org.apache.dubbo.common.threadlocal.InternalThreadLocal;

public class Profiler {
    public static final String PROFILER_KEY = "DUBBO_INVOKE_PROFILER";
    public static final int MAX_ENTRY_SIZE = 1000;
    private static final InternalThreadLocal<ProfilerEntry> bizProfiler = new InternalThreadLocal();

    public static ProfilerEntry start(String message) {
        return new ProfilerEntry(message);
    }

    public static ProfilerEntry enter(ProfilerEntry entry, String message) {
        ProfilerEntry subEntry = new ProfilerEntry(message, entry, entry.getFirst());
        if (subEntry.getRequestCount().incrementAndGet() < 1000) {
            entry.getSub().add(subEntry);
        }
        return subEntry;
    }

    public static ProfilerEntry release(ProfilerEntry entry) {
        entry.setEndTime(System.nanoTime());
        ProfilerEntry parent = entry.getParent();
        if (parent != null) {
            return parent;
        }
        return entry;
    }

    public static ProfilerEntry setToBizProfiler(ProfilerEntry entry) {
        try {
            ProfilerEntry profilerEntry = bizProfiler.get();
            return profilerEntry;
        }
        finally {
            bizProfiler.set(entry);
        }
    }

    public static ProfilerEntry getBizProfiler() {
        return bizProfiler.get();
    }

    public static void removeBizProfiler() {
        bizProfiler.remove();
    }

    public static String buildDetail(ProfilerEntry entry) {
        long totalUsageTime = entry.getEndTime() - entry.getStartTime();
        return "Start time: " + entry.getStartTime() + "\n" + String.join((CharSequence)"\n", Profiler.buildDetail(entry, entry.getStartTime(), totalUsageTime, 0));
    }

    public static List<String> buildDetail(ProfilerEntry entry, long startTime, long totalUsageTime, int depth) {
        StringBuilder stringBuilder = new StringBuilder();
        long usage = entry.getEndTime() - entry.getStartTime();
        int percent = (int)(usage * 100L / totalUsageTime);
        long offset = entry.getStartTime() - startTime;
        LinkedList<String> lines = new LinkedList<String>();
        stringBuilder.append("+-[ Offset: ").append(offset / 1000000L).append('.').append(String.format("%06d", offset % 1000000L)).append("ms; Usage: ").append(usage / 1000000L).append('.').append(String.format("%06d", usage % 1000000L)).append("ms, ").append(percent).append("% ] ").append(entry.getMessage());
        lines.add(stringBuilder.toString());
        List<ProfilerEntry> entrySub = entry.getSub();
        int entrySubSize = entrySub.size();
        for (int i = 0; i < entrySubSize; ++i) {
            String subLine;
            int j;
            int subLinesSize;
            ProfilerEntry sub = entrySub.get(i);
            List<String> subLines = Profiler.buildDetail(sub, startTime, totalUsageTime, depth + 1);
            if (i < entrySubSize - 1) {
                lines.add("  " + subLines.get(0));
                subLinesSize = subLines.size();
                for (j = 1; j < subLinesSize; ++j) {
                    subLine = subLines.get(j);
                    lines.add("  |" + subLine);
                }
                continue;
            }
            lines.add("  " + subLines.get(0));
            subLinesSize = subLines.size();
            for (j = 1; j < subLinesSize; ++j) {
                subLine = subLines.get(j);
                lines.add("   " + subLine);
            }
        }
        return lines;
    }
}

