/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.constants;

import java.util.concurrent.ExecutorService;
import java.util.regex.Pattern;
import org.apache.dubbo.common.URL;

public interface CommonConstants {
    public static final String DUBBO = "dubbo";
    public static final String TRIPLE = "tri";
    public static final String PROVIDER = "provider";
    public static final String CONSUMER = "consumer";
    public static final String APPLICATION_KEY = "application";
    public static final String APPLICATION_VERSION_KEY = "application.version";
    public static final String APPLICATION_PROTOCOL_KEY = "application-protocol";
    public static final String METADATA_SERVICE_PORT_KEY = "metadata-service-port";
    public static final String METADATA_SERVICE_PROTOCOL_KEY = "metadata-service-protocol";
    public static final String METRICS_SERVICE_PORT_KEY = "metrics-service-port";
    public static final String METRICS_SERVICE_PROTOCOL_KEY = "metrics-service-protocol";
    public static final String LIVENESS_PROBE_KEY = "liveness-probe";
    public static final String READINESS_PROBE_KEY = "readiness-probe";
    public static final String STARTUP_PROBE = "startup-probe";
    public static final String REMOTE_APPLICATION_KEY = "remote.application";
    public static final String ENABLED_KEY = "enabled";
    public static final String DISABLED_KEY = "disabled";
    public static final String DUBBO_PROPERTIES_KEY = "dubbo.properties.file";
    public static final String DEFAULT_DUBBO_PROPERTIES = "dubbo.properties";
    public static final String DUBBO_MIGRATION_KEY = "dubbo.migration.file";
    public static final String DUBBO_MIGRATION_FILE_ENABLE = "dubbo.migration-file.enable";
    public static final String DEFAULT_DUBBO_MIGRATION_FILE = "dubbo-migration.yaml";
    public static final String ANY_VALUE = "*";
    public static final char COMMA_SEPARATOR_CHAR = ',';
    public static final String COMMA_SEPARATOR = ",";
    public static final String DOT_SEPARATOR = ".";
    public static final Pattern COMMA_SPLIT_PATTERN = Pattern.compile("\\s*[,]+\\s*");
    public static final String PATH_SEPARATOR = "/";
    public static final String PROTOCOL_SEPARATOR = "://";
    public static final String PROTOCOL_SEPARATOR_ENCODED = URL.encode("://");
    public static final String REGISTRY_SEPARATOR = "|";
    public static final Pattern REGISTRY_SPLIT_PATTERN = Pattern.compile("\\s*[|;]+\\s*");
    public static final Pattern D_REGISTRY_SPLIT_PATTERN = Pattern.compile("\\s*[|]+\\s*");
    public static final String SEMICOLON_SEPARATOR = ";";
    public static final Pattern SEMICOLON_SPLIT_PATTERN = Pattern.compile("\\s*[;]+\\s*");
    public static final Pattern EQUAL_SPLIT_PATTERN = Pattern.compile("\\s*[=]+\\s*");
    public static final String DEFAULT_PROXY = "javassist";
    public static final String DEFAULT_DIRECTORY = "dubbo";
    public static final String PROTOCOL_KEY = "protocol";
    public static final String DEFAULT_PROTOCOL = "dubbo";
    public static final String DEFAULT_THREAD_NAME = "Dubbo";
    public static final int DEFAULT_CORE_THREADS = 0;
    public static final int DEFAULT_THREADS = 200;
    public static final String EXECUTOR_SERVICE_COMPONENT_KEY = ExecutorService.class.getName();
    public static final String CONSUMER_SHARED_EXECUTOR_SERVICE_COMPONENT_KEY = "CONSUMER_SHARED_SERVICE_EXECUTOR";
    public static final String INTERNAL_EXECUTOR_SERVICE_COMPONENT_KEY = "INTERNAL_SERVICE_EXECUTOR";
    public static final String THREADPOOL_KEY = "threadpool";
    public static final String THREAD_NAME_KEY = "threadname";
    public static final String CORE_THREADS_KEY = "corethreads";
    public static final String THREAD_POOL_EXHAUSTED_LISTENERS_KEY = "thread-pool-exhausted-listeners";
    public static final String THREADS_KEY = "threads";
    public static final String QUEUES_KEY = "queues";
    public static final String ALIVE_KEY = "alive";
    public static final String DEFAULT_THREADPOOL = "limited";
    public static final String DEFAULT_CLIENT_THREADPOOL = "cached";
    public static final String IO_THREADS_KEY = "iothreads";
    public static final String KEEP_ALIVE_KEY = "keep.alive";
    public static final int DEFAULT_QUEUES = 0;
    public static final int DEFAULT_ALIVE = 60000;
    public static final String TIMEOUT_KEY = "timeout";
    public static final int DEFAULT_TIMEOUT = 1000;
    public static final String SESSION_KEY = "session";
    public static final String TIMEOUT_ATTACHMENT_KEY = "_TO";
    public static final String TIMEOUT_ATTACHMENT_KEY_LOWER = "_to";
    public static final String TIME_COUNTDOWN_KEY = "timeout-countdown";
    public static final String ENABLE_TIMEOUT_COUNTDOWN_KEY = "enable-timeout-countdown";
    public static final String REMOVE_VALUE_PREFIX = "-";
    public static final String PROPERTIES_CHAR_SEPARATOR = "-";
    public static final String UNDERLINE_SEPARATOR = "_";
    public static final String SEPARATOR_REGEX = "_|-";
    public static final String GROUP_CHAR_SEPARATOR = ":";
    public static final String HIDE_KEY_PREFIX = ".";
    public static final String DOT_REGEX = "\\.";
    public static final String DEFAULT_KEY_PREFIX = "default.";
    public static final String DEFAULT_KEY = "default";
    public static final String PREFERRED_KEY = "preferred";
    public static final int DEFAULT_SERVER_SHUTDOWN_TIMEOUT = 10000;
    public static final String SIDE_KEY = "side";
    public static final String PROVIDER_SIDE = "provider";
    public static final String CONSUMER_SIDE = "consumer";
    public static final String ANYHOST_KEY = "anyhost";
    public static final String ANYHOST_VALUE = "0.0.0.0";
    public static final String LOCALHOST_KEY = "localhost";
    public static final String LOCALHOST_VALUE = "127.0.0.1";
    public static final String METHODS_KEY = "methods";
    public static final String METHOD_KEY = "method";
    public static final String PID_KEY = "pid";
    public static final String TIMESTAMP_KEY = "timestamp";
    public static final String GROUP_KEY = "group";
    public static final String PATH_KEY = "path";
    public static final String INTERFACE_KEY = "interface";
    public static final String FILE_KEY = "file";
    public static final String FILTER_KEY = "filter";
    public static final String DUMP_DIRECTORY = "dump.directory";
    public static final String DUMP_ENABLE = "dump.enable";
    public static final String CLASSIFIER_KEY = "classifier";
    public static final String VERSION_KEY = "version";
    public static final String REVISION_KEY = "revision";
    public static final String METADATA_KEY = "metadata-type";
    public static final String REPORT_METADATA_KEY = "report-metadata";
    public static final String REPORT_DEFINITION_KEY = "report-definition";
    public static final String DEFAULT_METADATA_STORAGE_TYPE = "local";
    public static final String REMOTE_METADATA_STORAGE_TYPE = "remote";
    public static final String GENERIC_KEY = "generic";
    public static final String COMPOSITE_METADATA_STORAGE_TYPE = "composite";
    public static final String PROXY_CLASS_REF = "refClass";
    public static final String $INVOKE = "$invoke";
    public static final String $INVOKE_ASYNC = "$invokeAsync";
    public static final String GENERIC_PARAMETER_DESC = "Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/Object;";
    public static final String $ECHO = "$echo";
    public static final String RELEASE_KEY = "release";
    public static final String PROTOBUF_MESSAGE_CLASS_NAME = "com.google.protobuf.Message";
    public static final int MAX_PROXY_COUNT = 65535;
    public static final String MONITOR_KEY = "monitor";
    public static final String CLUSTER_KEY = "cluster";
    public static final String USERNAME_KEY = "username";
    public static final String PASSWORD_KEY = "password";
    public static final String HOST_KEY = "host";
    public static final String PORT_KEY = "port";
    public static final String DUBBO_IP_TO_BIND = "DUBBO_IP_TO_BIND";
    public static final String BROADCAST_CLUSTER = "broadcast";
    public static final String DUBBO_PREFERRED_NETWORK_INTERFACE = "dubbo.network.interface.preferred";
    @Deprecated
    public static final String SHUTDOWN_WAIT_SECONDS_KEY = "dubbo.service.shutdown.wait.seconds";
    public static final String SHUTDOWN_WAIT_KEY = "dubbo.service.shutdown.wait";
    public static final String DUBBO_PROTOCOL = "dubbo";
    public static final String DUBBO_LABELS = "dubbo.labels";
    public static final String DUBBO_ENV_KEYS = "dubbo.env.keys";
    public static final String CONFIG_CONFIGFILE_KEY = "config-file";
    public static final String CONFIG_ENABLE_KEY = "highest-priority";
    public static final String CONFIG_NAMESPACE_KEY = "namespace";
    public static final String CHECK_KEY = "check";
    public static final String BACKLOG_KEY = "backlog";
    public static final String HEARTBEAT_EVENT = null;
    public static final String MOCK_HEARTBEAT_EVENT = "H";
    public static final String READONLY_EVENT = "R";
    public static final String REFERENCE_FILTER_KEY = "reference.filter";
    public static final String HEADER_FILTER_KEY = "header.filter";
    public static final String INVOCATION_INTERCEPTOR_KEY = "invocation.interceptor";
    public static final String INVOKER_LISTENER_KEY = "invoker.listener";
    public static final String REGISTRY_PROTOCOL_LISTENER_KEY = "registry.protocol.listener";
    public static final String DUBBO_VERSION_KEY = "dubbo";
    public static final String TAG_KEY = "dubbo.tag";
    public static final String LAZY_CONNECT_KEY = "lazy";
    public static final String STUB_EVENT_KEY = "dubbo.stub.event";
    public static final String REFERENCE_INTERCEPTOR_KEY = "reference.interceptor";
    public static final String SERVICE_FILTER_KEY = "service.filter";
    public static final String EXPORTER_LISTENER_KEY = "exporter.listener";
    public static final String EXTRA_KEYS_KEY = "extra-keys";
    public static final String GENERIC_SERIALIZATION_NATIVE_JAVA = "nativejava";
    public static final String GENERIC_SERIALIZATION_GSON = "gson";
    public static final String GENERIC_SERIALIZATION_DEFAULT = "true";
    public static final String GENERIC_SERIALIZATION_BEAN = "bean";
    public static final String GENERIC_RAW_RETURN = "raw.return";
    public static final String GENERIC_SERIALIZATION_PROTOBUF = "protobuf-json";
    public static final String GENERIC_WITH_CLZ_KEY = "generic.include.class";
    public static final String REGISTRY_LOCAL_FILE_CACHE_ENABLED = "file.cache";
    public static final String METADATA_INFO_CACHE_EXPIRE_KEY = "metadata-info-cache.expire";
    public static final int DEFAULT_METADATA_INFO_CACHE_EXPIRE = 600000;
    public static final String METADATA_INFO_CACHE_SIZE_KEY = "metadata-info-cache.size";
    public static final int DEFAULT_METADATA_INFO_CACHE_SIZE = 16;
    public static final String CALLBACK_INSTANCES_LIMIT_KEY = "callbacks";
    public static final int DEFAULT_CALLBACK_INSTANCES = 1;
    public static final String LOADBALANCE_KEY = "loadbalance";
    public static final String DEFAULT_LOADBALANCE = "random";
    public static final String RETRIES_KEY = "retries";
    public static final String FORKS_KEY = "forks";
    public static final int DEFAULT_RETRIES = 2;
    public static final int DEFAULT_FAILBACK_TIMES = 3;
    public static final String INTERFACES = "interfaces";
    public static final String SSL_ENABLED_KEY = "ssl-enabled";
    public static final String SERVICE_PATH_PREFIX = "service.path.prefix";
    public static final String PROTOCOL_SERVER_SERVLET = "servlet";
    public static final String PROTOCOL_SERVER = "server";
    public static final String IPV6_KEY = "ipv6";
    public static final String SERVICE_NAME_MAPPING_PROPERTIES_FILE_KEY = "service-name-mapping.properties-path";
    public static final String DEFAULT_SERVICE_NAME_MAPPING_PROPERTIES_PATH = "META-INF/dubbo/service-name-mapping.properties";
    public static final String CLASS_DESERIALIZE_BLOCK_ALL = "dubbo.security.serialize.blockAllClassExceptAllow";
    public static final String CLASS_DESERIALIZE_ALLOWED_LIST = "dubbo.security.serialize.allowedClassList";
    public static final String CLASS_DESERIALIZE_BLOCKED_LIST = "dubbo.security.serialize.blockedClassList";
    public static final String ENABLE_NATIVE_JAVA_GENERIC_SERIALIZE = "dubbo.security.serialize.generic.native-java-enable";
    public static final String SERIALIZE_BLOCKED_LIST_FILE_PATH = "security/serialize.blockedlist";
    public static final String SERIALIZE_ALLOW_LIST_FILE_PATH = "security/serialize.allowlist";
    public static final String SERIALIZE_CHECK_STATUS_KEY = "dubbo.application.serialize-check-status";
    public static final String QOS_LIVE_PROBE_EXTENSION = "dubbo.application.liveness-probe";
    public static final String QOS_READY_PROBE_EXTENSION = "dubbo.application.readiness-probe";
    public static final String QOS_STARTUP_PROBE_EXTENSION = "dubbo.application.startup-probe";
    public static final String REGISTRY_DELAY_NOTIFICATION_KEY = "delay-notification";
    public static final String CACHE_CLEAR_TASK_INTERVAL = "dubbo.application.url.cache.task.interval";
    public static final String CACHE_CLEAR_WAITING_THRESHOLD = "dubbo.application.url.cache.clear.waiting";
    public static final String CLUSTER_INTERCEPTOR_COMPATIBLE_KEY = "dubbo.application.cluster.interceptor.compatible";
    public static final String UTF8ENCODE = "UTF-8";
    public static final String CLASSPATH_URL_PREFIX = "classpath:";
    public static final String DEFAULT_VERSION = "0.0.0";
    public static final String CLASS_DESERIALIZE_OPEN_CHECK = "dubbo.security.serialize.openCheckClass";
    public static final String ROUTER_KEY = "router";
    public static final String EXPORT_ASYNC_KEY = "export-async";
    public static final String REFER_ASYNC_KEY = "refer-async";
    public static final String EXPORT_BACKGROUND_KEY = "export-background";
    public static final String REFER_BACKGROUND_KEY = "refer-background";
    public static final String EXPORT_THREAD_NUM_KEY = "export-thread-num";
    public static final String REFER_THREAD_NUM_KEY = "refer-thread-num";
    public static final int DEFAULT_EXPORT_THREAD_NUM = 10;
    public static final int DEFAULT_REFER_THREAD_NUM = 10;
    public static final int DEFAULT_DELAY_NOTIFICATION_TIME = 5000;
    public static final int DEFAULT_DELAY_EXECUTE_TIMES = 10;
    public static final String URL_MERGE_PROCESSOR_KEY = "url-merge-processor";
    public static final String NATIVE = "native";
    public static final String DUBBO_MONITOR_ADDRESS = "dubbo.monitor.address";
    public static final String SERVICE_NAME_MAPPING_KEY = "service-name-mapping";
    public static final String SCOPE_MODEL = "scopeModel";
    public static final String SERVICE_MODEL = "serviceModel";
    public static final String DUBBO_NETWORK_IGNORED_INTERFACE = "dubbo.network.interface.ignored";
    public static final String OS_NAME_KEY = "os.name";
    public static final String OS_LINUX_PREFIX = "linux";
    public static final String OS_WIN_PREFIX = "win";
    public static final String RECONNECT_TASK_TRY_COUNT = "dubbo.reconnect.reconnectTaskTryCount";
    public static final int DEFAULT_RECONNECT_TASK_TRY_COUNT = 10;
    public static final String RECONNECT_TASK_PERIOD = "dubbo.reconnect.reconnectTaskPeriod";
    public static final int DEFAULT_RECONNECT_TASK_PERIOD = 1000;
    public static final String RESELECT_COUNT = "dubbo.reselect.count";
    public static final int DEFAULT_RESELECT_COUNT = 10;
    public static final String ENABLE_CONNECTIVITY_VALIDATION = "dubbo.connectivity.validation";
    public static final String DUBBO_INTERNAL_APPLICATION = "DUBBO_INTERNAL_APPLICATION";
    public static final String RETRY_TIMES_KEY = "retry-times";
    public static final String RETRY_PERIOD_KEY = "retry-period";
    public static final String SYNC_REPORT_KEY = "sync-report";
    public static final String CYCLE_REPORT_KEY = "cycle-report";
    public static final String WORKING_CLASSLOADER_KEY = "WORKING_CLASSLOADER";
    public static final String STAGED_CLASSLOADER_KEY = "STAGED_CLASSLOADER";
    public static final String PROVIDER_ASYNC_KEY = "PROVIDER_ASYNC";
    public static final String REGISTER_IP_KEY = "register.ip";
    public static final String CURRENT_CLUSTER_INVOKER_KEY = "currentClusterInvoker";
    public static final String ENABLE_ROUTER_SNAPSHOT_PRINT_KEY = "ENABLE_ROUTER_SNAPSHOT_PRINT";
    public static final String INJVM_COPY_UTIL_KEY = "injvm-copy-util";
    public static final String INJVM_IGNORE_SAME_MODULE_KEY = "injvm.ignore.same-module";
    public static final String SET_FUTURE_IN_SYNC_MODE = "future.sync.set";
    public static final String CLEAR_FUTURE_AFTER_GET = "future.clear.once";
    public static final String NATIVE_STUB = "nativestub";
    public static final String METADATA = "metadata";
    public static final String IGNORE_LISTEN_SHUTDOWN_HOOK = "dubbo.shutdownHook.listenIgnore";
    public static final String OPTIMIZER_KEY = "optimizer";
    public static final String PREFER_JSON_FRAMEWORK_NAME = "dubbo.json-framework.prefer";
    public static final String MESH_ENABLE = "mesh-enable";
    public static final Integer DEFAULT_MESH_PORT = 80;
    public static final String SVC = ".svc.";
    public static final String DEFAULT_CLUSTER_DOMAIN = "cluster.local";
    public static final String UNLOAD_CLUSTER_RELATED = "unloadClusterRelated";
    public static final String SERVICE_EXECUTOR = "service-executor";
    public static final String EXECUTOR_MANAGEMENT_MODE = "executor-management-mode";
    public static final String EXECUTOR_MANAGEMENT_MODE_DEFAULT = "default";
    public static final String EXECUTOR_MANAGEMENT_MODE_ISOLATION = "isolation";
    public static final String DUBBO_JSTACK_MAXLINE = "dubbo.jstack-dump.max-line";
    public static final String ENCODE_IN_IO_THREAD_KEY = "encode.in.io";
    public static final boolean DEFAULT_ENCODE_IN_IO_THREAD = false;
}

