/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

public class BatchExecutorQueue<T> {
    static final int DEFAULT_QUEUE_SIZE = 128;
    private final Queue<T> queue = new ConcurrentLinkedQueue<T>();
    private final AtomicBoolean scheduled = new AtomicBoolean(false);
    private final int chunkSize;

    public BatchExecutorQueue() {
        this(128);
    }

    public BatchExecutorQueue(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public void enqueue(T message, Executor executor) {
        this.queue.add(message);
        this.scheduleFlush(executor);
    }

    protected void scheduleFlush(Executor executor) {
        if (this.scheduled.compareAndSet(false, true)) {
            executor.execute(() -> this.run(executor));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(Executor executor) {
        try {
            Object item;
            LinkedList<T> snapshot = new LinkedList<T>();
            while ((item = this.queue.poll()) != null) {
                snapshot.add(item);
            }
            int i = 0;
            boolean flushedOnce = false;
            while ((item = snapshot.poll()) != null) {
                if (snapshot.size() == 0) {
                    i = 0;
                    break;
                }
                if (i == this.chunkSize) {
                    i = 0;
                    this.flush(item);
                    flushedOnce = true;
                    continue;
                }
                this.prepare(item);
                ++i;
            }
            if (!(i == 0 && flushedOnce || item == null)) {
                this.flush(item);
            }
        }
        finally {
            this.scheduled.set(false);
            if (!this.queue.isEmpty()) {
                this.scheduleFlush(executor);
            }
        }
    }

    protected void prepare(T item) {
    }

    protected void flush(T item) {
    }
}

