/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.http;

import com.opencsv.CSVWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.sql.http.ResultFormat;

public class CsvWriter
implements ResultFormat.Writer {
    private final OutputStream outputStream;
    private final CSVWriter writer;
    private final List<String> currentLine = new ArrayList<String>();

    public CsvWriter(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.writer = new CSVWriter((Writer)new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8)));
    }

    @Override
    public void writeResponseStart() {
    }

    @Override
    public void writeResponseEnd() throws IOException {
        this.writer.flush();
        this.outputStream.write(10);
        this.outputStream.flush();
    }

    @Override
    public void writeHeader(List<String> columnNames) {
        this.writer.writeNext(columnNames.toArray(new String[0]), false);
    }

    @Override
    public void writeRowStart() {
    }

    @Override
    public void writeRowField(String name, @Nullable Object value) {
        if (value == null) {
            this.currentLine.add("");
        } else if (value instanceof String) {
            this.currentLine.add((String)value);
        } else {
            this.currentLine.add(value.toString());
        }
    }

    @Override
    public void writeRowEnd() {
        boolean quoteEverything = this.currentLine.size() == 1 && this.currentLine.get(0).isEmpty();
        this.writer.writeNext(this.currentLine.toArray(new String[0]), quoteEverything);
        this.currentLine.clear();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

