/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.view;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.schema.FunctionParameter;
import org.apache.calcite.schema.TableMacro;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.ViewTable;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.Escalator;
import org.apache.druid.sql.calcite.planner.DruidPlanner;
import org.apache.druid.sql.calcite.planner.PlannerFactory;

public class DruidViewMacro
implements TableMacro {
    private final PlannerFactory plannerFactory;
    private final Escalator escalator;
    private final String viewSql;

    public DruidViewMacro(PlannerFactory plannerFactory, Escalator escalator, String viewSql) {
        this.plannerFactory = plannerFactory;
        this.escalator = escalator;
        this.viewSql = viewSql;
    }

    public TranslatableTable apply(List<Object> arguments) {
        RelDataType rowType;
        AuthenticationResult authenticationResult = this.escalator.createEscalatedAuthenticationResult();
        try (DruidPlanner planner = this.plannerFactory.createPlanner(null, authenticationResult);){
            rowType = planner.plan(this.viewSql).rowType();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new ViewTable(null, RelDataTypeImpl.proto((RelDataType)rowType), this.viewSql, (List)ImmutableList.of((Object)"druid"), null);
    }

    public List<FunctionParameter> getParameters() {
        return ImmutableList.of();
    }
}

