/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.schema;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.DataContext;
import org.apache.calcite.linq4j.DefaultEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.client.InventoryView;
import org.apache.druid.client.JsonParserIterator;
import org.apache.druid.client.TimelineServerView;
import org.apache.druid.client.coordinator.Coordinator;
import org.apache.druid.client.indexing.IndexingService;
import org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.druid.discovery.DruidLeaderClient;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.indexing.overlord.supervisor.SupervisorStatus;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.coordinator.BytesAccumulatingResponseHandler;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.calcite.schema.AvailableSegmentMetadata;
import org.apache.druid.sql.calcite.schema.DruidSchema;
import org.apache.druid.sql.calcite.schema.MetadataSegmentView;
import org.apache.druid.sql.calcite.table.RowSignature;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.SegmentWithOvershadowedStatus;
import org.jboss.netty.handler.codec.http.HttpMethod;

public class SystemSchema
extends AbstractSchema {
    public static final String NAME = "sys";
    private static final String SEGMENTS_TABLE = "segments";
    private static final String SERVERS_TABLE = "servers";
    private static final String SERVER_SEGMENTS_TABLE = "server_segments";
    private static final String TASKS_TABLE = "tasks";
    private static final String SUPERVISOR_TABLE = "supervisors";
    private static final Function<SegmentWithOvershadowedStatus, Iterable<ResourceAction>> SEGMENT_WITH_OVERSHADOWED_STATUS_RA_GENERATOR = segment -> Collections.singletonList(AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR.apply((Object)segment.getDataSegment().getDataSource()));
    private static final Function<DataSegment, Iterable<ResourceAction>> SEGMENT_RA_GENERATOR = segment -> Collections.singletonList(AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR.apply((Object)segment.getDataSource()));
    private static final long IS_PUBLISHED_FALSE = 0L;
    private static final long IS_PUBLISHED_TRUE = 1L;
    private static final long IS_AVAILABLE_TRUE = 1L;
    private static final long IS_OVERSHADOWED_FALSE = 0L;
    private static final long IS_OVERSHADOWED_TRUE = 1L;
    private static final long MAX_SERVER_SIZE = 0L;
    private static final long CURRENT_SERVER_SIZE = 0L;
    static final RowSignature SEGMENTS_SIGNATURE = RowSignature.builder().add("segment_id", ValueType.STRING).add("datasource", ValueType.STRING).add("start", ValueType.STRING).add("end", ValueType.STRING).add("size", ValueType.LONG).add("version", ValueType.STRING).add("partition_num", ValueType.LONG).add("num_replicas", ValueType.LONG).add("num_rows", ValueType.LONG).add("is_published", ValueType.LONG).add("is_available", ValueType.LONG).add("is_realtime", ValueType.LONG).add("is_overshadowed", ValueType.LONG).add("payload", ValueType.STRING).build();
    static final RowSignature SERVERS_SIGNATURE = RowSignature.builder().add("server", ValueType.STRING).add("host", ValueType.STRING).add("plaintext_port", ValueType.LONG).add("tls_port", ValueType.LONG).add("server_type", ValueType.STRING).add("tier", ValueType.STRING).add("curr_size", ValueType.LONG).add("max_size", ValueType.LONG).build();
    static final RowSignature SERVER_SEGMENTS_SIGNATURE = RowSignature.builder().add("server", ValueType.STRING).add("segment_id", ValueType.STRING).build();
    static final RowSignature TASKS_SIGNATURE = RowSignature.builder().add("task_id", ValueType.STRING).add("group_id", ValueType.STRING).add("type", ValueType.STRING).add("datasource", ValueType.STRING).add("created_time", ValueType.STRING).add("queue_insertion_time", ValueType.STRING).add("status", ValueType.STRING).add("runner_status", ValueType.STRING).add("duration", ValueType.LONG).add("location", ValueType.STRING).add("host", ValueType.STRING).add("plaintext_port", ValueType.LONG).add("tls_port", ValueType.LONG).add("error_msg", ValueType.STRING).build();
    static final RowSignature SUPERVISOR_SIGNATURE = RowSignature.builder().add("supervisor_id", ValueType.STRING).add("state", ValueType.STRING).add("detailed_state", ValueType.STRING).add("healthy", ValueType.LONG).add("type", ValueType.STRING).add("source", ValueType.STRING).add("suspended", ValueType.LONG).add("spec", ValueType.STRING).build();
    private final Map<String, Table> tableMap;

    @Inject
    public SystemSchema(DruidSchema druidSchema, MetadataSegmentView metadataView, TimelineServerView serverView, InventoryView serverInventoryView, AuthorizerMapper authorizerMapper, @Coordinator DruidLeaderClient coordinatorDruidLeaderClient, @IndexingService DruidLeaderClient overlordDruidLeaderClient, DruidNodeDiscoveryProvider druidNodeDiscoveryProvider, ObjectMapper jsonMapper) {
        Preconditions.checkNotNull((Object)serverView, (Object)"serverView");
        BytesAccumulatingResponseHandler responseHandler = new BytesAccumulatingResponseHandler();
        SegmentsTable segmentsTable = new SegmentsTable(druidSchema, metadataView, jsonMapper, authorizerMapper);
        this.tableMap = ImmutableMap.of((Object)SEGMENTS_TABLE, (Object)((Object)segmentsTable), (Object)SERVERS_TABLE, (Object)((Object)new ServersTable(druidNodeDiscoveryProvider, serverInventoryView, authorizerMapper)), (Object)SERVER_SEGMENTS_TABLE, (Object)((Object)new ServerSegmentsTable(serverView, authorizerMapper)), (Object)TASKS_TABLE, (Object)((Object)new TasksTable(overlordDruidLeaderClient, jsonMapper, responseHandler, authorizerMapper)), (Object)SUPERVISOR_TABLE, (Object)((Object)new SupervisorsTable(overlordDruidLeaderClient, jsonMapper, responseHandler, authorizerMapper)));
    }

    public Map<String, Table> getTableMap() {
        return this.tableMap;
    }

    private static JsonParserIterator<TaskStatusPlus> getTasks(DruidLeaderClient indexingServiceClient, ObjectMapper jsonMapper, BytesAccumulatingResponseHandler responseHandler) {
        Request request;
        try {
            request = indexingServiceClient.makeRequest(HttpMethod.GET, "/druid/indexer/v1/tasks", false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ListenableFuture future = indexingServiceClient.goAsync(request, (HttpResponseHandler)responseHandler);
        JavaType typeRef = jsonMapper.getTypeFactory().constructType((TypeReference)new TypeReference<TaskStatusPlus>(){});
        return new JsonParserIterator(typeRef, (Future)future, request.getUrl().toString(), null, request.getUrl().getHost(), jsonMapper, responseHandler);
    }

    private static JsonParserIterator<SupervisorStatus> getSupervisors(DruidLeaderClient indexingServiceClient, ObjectMapper jsonMapper, BytesAccumulatingResponseHandler responseHandler) {
        Request request;
        try {
            request = indexingServiceClient.makeRequest(HttpMethod.GET, "/druid/indexer/v1/supervisor?system", false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ListenableFuture future = indexingServiceClient.goAsync(request, (HttpResponseHandler)responseHandler);
        JavaType typeRef = jsonMapper.getTypeFactory().constructType((TypeReference)new TypeReference<SupervisorStatus>(){});
        return new JsonParserIterator(typeRef, (Future)future, request.getUrl().toString(), null, request.getUrl().getHost(), jsonMapper, responseHandler);
    }

    private static <T> CloseableIterator<T> wrap(final Iterator<T> iterator, final JsonParserIterator<T> it) {
        return new CloseableIterator<T>(){

            public boolean hasNext() {
                boolean hasNext = iterator.hasNext();
                if (!hasNext) {
                    try {
                        it.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return hasNext;
            }

            public T next() {
                return iterator.next();
            }

            public void close() throws IOException {
                it.close();
            }
        };
    }

    @Nullable
    private static String extractHost(@Nullable String hostAndPort) {
        if (hostAndPort == null) {
            return null;
        }
        return HostAndPort.fromString((String)hostAndPort).getHostText();
    }

    private static int extractPort(@Nullable String hostAndPort) {
        if (hostAndPort == null) {
            return -1;
        }
        return HostAndPort.fromString((String)hostAndPort).getPortOrDefault(-1);
    }

    @Nullable
    private static String toStringOrNull(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    private static void checkStateReadAccessForServers(AuthenticationResult authenticationResult, AuthorizerMapper authorizerMapper) {
        Access stateAccess = AuthorizationUtils.authorizeAllResourceActions((AuthenticationResult)authenticationResult, Collections.singletonList(new ResourceAction(Resource.STATE_RESOURCE, Action.READ)), (AuthorizerMapper)authorizerMapper);
        if (!stateAccess.isAllowed()) {
            throw new ForbiddenException("Insufficient permission to view servers : " + stateAccess);
        }
    }

    static class SupervisorsTable
    extends AbstractTable
    implements ScannableTable {
        private final DruidLeaderClient druidLeaderClient;
        private final ObjectMapper jsonMapper;
        private final BytesAccumulatingResponseHandler responseHandler;
        private final AuthorizerMapper authorizerMapper;

        public SupervisorsTable(DruidLeaderClient druidLeaderClient, ObjectMapper jsonMapper, BytesAccumulatingResponseHandler responseHandler, AuthorizerMapper authorizerMapper) {
            this.druidLeaderClient = druidLeaderClient;
            this.jsonMapper = jsonMapper;
            this.responseHandler = responseHandler;
            this.authorizerMapper = authorizerMapper;
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return SUPERVISOR_SIGNATURE.getRelDataType(typeFactory);
        }

        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.SYSTEM_TABLE;
        }

        public Enumerable<Object[]> scan(final DataContext root) {
            class SupervisorsEnumerable
            extends DefaultEnumerable<Object[]> {
                private final CloseableIterator<SupervisorStatus> it;

                public SupervisorsEnumerable(JsonParserIterator<SupervisorStatus> tasks) {
                    this.it = ((SupervisorsTable)this$0).getAuthorizedSupervisors((JsonParserIterator<SupervisorStatus>)tasks, root);
                }

                public Iterator<Object[]> iterator() {
                    throw new UnsupportedOperationException("Do not use iterator(), it cannot be closed.");
                }

                public Enumerator<Object[]> enumerator() {
                    return new Enumerator<Object[]>(){

                        public Object[] current() {
                            SupervisorStatus supervisor = (SupervisorStatus)it.next();
                            return new Object[]{supervisor.getId(), supervisor.getState(), supervisor.getDetailedState(), supervisor.isHealthy() ? 1L : 0L, supervisor.getType(), supervisor.getSource(), supervisor.isSuspended() ? 1L : 0L, supervisor.getSpecString()};
                        }

                        public boolean moveNext() {
                            return it.hasNext();
                        }

                        public void reset() {
                        }

                        public void close() {
                            try {
                                it.close();
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    };
                }
            }
            return new SupervisorsEnumerable(SystemSchema.getSupervisors(this.druidLeaderClient, this.jsonMapper, this.responseHandler));
        }

        private CloseableIterator<SupervisorStatus> getAuthorizedSupervisors(JsonParserIterator<SupervisorStatus> it, DataContext root) {
            AuthenticationResult authenticationResult = (AuthenticationResult)root.get("authenticationResult");
            Function raGenerator = supervisor -> Collections.singletonList(AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR.apply((Object)supervisor.getSource()));
            Iterable authorizedSupervisors = AuthorizationUtils.filterAuthorizedResources((AuthenticationResult)authenticationResult, () -> it, (Function)raGenerator, (AuthorizerMapper)this.authorizerMapper);
            return SystemSchema.wrap(authorizedSupervisors.iterator(), it);
        }
    }

    static class TasksTable
    extends AbstractTable
    implements ScannableTable {
        private final DruidLeaderClient druidLeaderClient;
        private final ObjectMapper jsonMapper;
        private final BytesAccumulatingResponseHandler responseHandler;
        private final AuthorizerMapper authorizerMapper;

        public TasksTable(DruidLeaderClient druidLeaderClient, ObjectMapper jsonMapper, BytesAccumulatingResponseHandler responseHandler, AuthorizerMapper authorizerMapper) {
            this.druidLeaderClient = druidLeaderClient;
            this.jsonMapper = jsonMapper;
            this.responseHandler = responseHandler;
            this.authorizerMapper = authorizerMapper;
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return TASKS_SIGNATURE.getRelDataType(typeFactory);
        }

        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.SYSTEM_TABLE;
        }

        public Enumerable<Object[]> scan(final DataContext root) {
            class TasksEnumerable
            extends DefaultEnumerable<Object[]> {
                private final CloseableIterator<TaskStatusPlus> it;

                public TasksEnumerable(JsonParserIterator<TaskStatusPlus> tasks) {
                    this.it = ((TasksTable)this$0).getAuthorizedTasks((JsonParserIterator<TaskStatusPlus>)tasks, root);
                }

                public Iterator<Object[]> iterator() {
                    throw new UnsupportedOperationException("Do not use iterator(), it cannot be closed.");
                }

                public Enumerator<Object[]> enumerator() {
                    return new Enumerator<Object[]>(){

                        public Object[] current() {
                            String hostAndPort;
                            TaskStatusPlus task = (TaskStatusPlus)it.next();
                            if (task.getLocation().getHost() == null) {
                                hostAndPort = null;
                            } else {
                                int port = task.getLocation().getTlsPort() >= 0 ? task.getLocation().getTlsPort() : task.getLocation().getPort();
                                hostAndPort = HostAndPort.fromParts((String)task.getLocation().getHost(), (int)port).toString();
                            }
                            return new Object[]{task.getId(), task.getGroupId(), task.getType(), task.getDataSource(), SystemSchema.toStringOrNull(task.getCreatedTime()), SystemSchema.toStringOrNull(task.getQueueInsertionTime()), SystemSchema.toStringOrNull(task.getStatusCode()), SystemSchema.toStringOrNull(task.getRunnerStatusCode()), task.getDuration() == null ? 0L : task.getDuration(), hostAndPort, task.getLocation().getHost(), (long)task.getLocation().getPort(), (long)task.getLocation().getTlsPort(), task.getErrorMsg()};
                        }

                        public boolean moveNext() {
                            return it.hasNext();
                        }

                        public void reset() {
                        }

                        public void close() {
                            try {
                                it.close();
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    };
                }
            }
            return new TasksEnumerable(SystemSchema.getTasks(this.druidLeaderClient, this.jsonMapper, this.responseHandler));
        }

        private CloseableIterator<TaskStatusPlus> getAuthorizedTasks(JsonParserIterator<TaskStatusPlus> it, DataContext root) {
            AuthenticationResult authenticationResult = (AuthenticationResult)root.get("authenticationResult");
            Function raGenerator = task -> Collections.singletonList(AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR.apply((Object)task.getDataSource()));
            Iterable authorizedTasks = AuthorizationUtils.filterAuthorizedResources((AuthenticationResult)authenticationResult, () -> it, (Function)raGenerator, (AuthorizerMapper)this.authorizerMapper);
            return SystemSchema.wrap(authorizedTasks.iterator(), it);
        }
    }

    static class ServerSegmentsTable
    extends AbstractTable
    implements ScannableTable {
        private final TimelineServerView serverView;
        final AuthorizerMapper authorizerMapper;

        public ServerSegmentsTable(TimelineServerView serverView, AuthorizerMapper authorizerMapper) {
            this.serverView = serverView;
            this.authorizerMapper = authorizerMapper;
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return SERVER_SEGMENTS_SIGNATURE.getRelDataType(typeFactory);
        }

        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.SYSTEM_TABLE;
        }

        public Enumerable<Object[]> scan(DataContext root) {
            AuthenticationResult authenticationResult = (AuthenticationResult)root.get("authenticationResult");
            SystemSchema.checkStateReadAccessForServers(authenticationResult, this.authorizerMapper);
            ArrayList<Object[]> rows = new ArrayList<Object[]>();
            List druidServers = this.serverView.getDruidServers();
            int serverSegmentsTableSize = SERVER_SEGMENTS_SIGNATURE.getRowOrder().size();
            for (ImmutableDruidServer druidServer : druidServers) {
                Iterable authorizedServerSegments = AuthorizationUtils.filterAuthorizedResources((AuthenticationResult)authenticationResult, (Iterable)druidServer.iterateAllSegments(), (Function)SEGMENT_RA_GENERATOR, (AuthorizerMapper)this.authorizerMapper);
                for (DataSegment segment : authorizedServerSegments) {
                    Object[] row = new Object[serverSegmentsTableSize];
                    row[0] = druidServer.getHost();
                    row[1] = segment.getId();
                    rows.add(row);
                }
            }
            return Linq4j.asEnumerable(rows);
        }
    }

    static class ServersTable
    extends AbstractTable
    implements ScannableTable {
        private final AuthorizerMapper authorizerMapper;
        private final DruidNodeDiscoveryProvider druidNodeDiscoveryProvider;
        private final InventoryView serverInventoryView;

        public ServersTable(DruidNodeDiscoveryProvider druidNodeDiscoveryProvider, InventoryView serverInventoryView, AuthorizerMapper authorizerMapper) {
            this.authorizerMapper = authorizerMapper;
            this.druidNodeDiscoveryProvider = druidNodeDiscoveryProvider;
            this.serverInventoryView = serverInventoryView;
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return SERVERS_SIGNATURE.getRelDataType(typeFactory);
        }

        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.SYSTEM_TABLE;
        }

        public Enumerable<Object[]> scan(DataContext root) {
            Iterator<DiscoveryDruidNode> druidServers = this.getDruidServers(this.druidNodeDiscoveryProvider);
            AuthenticationResult authenticationResult = (AuthenticationResult)root.get("authenticationResult");
            SystemSchema.checkStateReadAccessForServers(authenticationResult, this.authorizerMapper);
            FluentIterable results = FluentIterable.from(() -> druidServers).transform(val -> {
                boolean isDataNode = false;
                DruidNode node = val.getDruidNode();
                long currHistoricalSize = 0L;
                if (val.getNodeRole().equals((Object)NodeRole.HISTORICAL)) {
                    DruidServer server = this.serverInventoryView.getInventoryValue(val.toDruidServer().getName());
                    currHistoricalSize = server.getCurrSize();
                    isDataNode = true;
                }
                return new Object[]{node.getHostAndPortToUse(), SystemSchema.extractHost(node.getHost()), (long)SystemSchema.extractPort(node.getHostAndPort()), (long)SystemSchema.extractPort(node.getHostAndTlsPort()), StringUtils.toLowerCase((String)SystemSchema.toStringOrNull(val.getNodeRole())), isDataNode ? val.toDruidServer().getTier() : null, isDataNode ? currHistoricalSize : 0L, isDataNode ? val.toDruidServer().getMaxSize() : 0L};
            });
            return Linq4j.asEnumerable((Iterable)results);
        }

        private Iterator<DiscoveryDruidNode> getDruidServers(DruidNodeDiscoveryProvider druidNodeDiscoveryProvider) {
            return Arrays.stream(NodeRole.values()).flatMap(nodeRole -> druidNodeDiscoveryProvider.getForNodeRole(nodeRole).getAllNodes().stream()).collect(Collectors.toList()).iterator();
        }
    }

    static class SegmentsTable
    extends AbstractTable
    implements ScannableTable {
        private final DruidSchema druidSchema;
        private final ObjectMapper jsonMapper;
        private final AuthorizerMapper authorizerMapper;
        private final MetadataSegmentView metadataView;

        public SegmentsTable(DruidSchema druidSchemna, MetadataSegmentView metadataView, ObjectMapper jsonMapper, AuthorizerMapper authorizerMapper) {
            this.druidSchema = druidSchemna;
            this.metadataView = metadataView;
            this.jsonMapper = jsonMapper;
            this.authorizerMapper = authorizerMapper;
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return SEGMENTS_SIGNATURE.getRelDataType(typeFactory);
        }

        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.SYSTEM_TABLE;
        }

        public Enumerable<Object[]> scan(DataContext root) {
            Map<SegmentId, AvailableSegmentMetadata> availableSegmentMetadata = this.druidSchema.getSegmentMetadataSnapshot();
            Iterator<Map.Entry<SegmentId, AvailableSegmentMetadata>> availableSegmentEntries = availableSegmentMetadata.entrySet().iterator();
            HashMap partialSegmentDataMap = Maps.newHashMapWithExpectedSize((int)this.druidSchema.getTotalSegments());
            for (AvailableSegmentMetadata h : availableSegmentMetadata.values()) {
                PartialSegmentData partialSegmentData = new PartialSegmentData(1L, h.isRealtime(), h.getNumReplicas(), h.getNumRows());
                partialSegmentDataMap.put(h.getSegment().getId(), partialSegmentData);
            }
            Iterator<SegmentWithOvershadowedStatus> metadataStoreSegments = this.metadataView.getPublishedSegments();
            HashSet segmentsAlreadySeen = new HashSet();
            FluentIterable publishedSegments = FluentIterable.from(() -> this.getAuthorizedPublishedSegments(metadataStoreSegments, root)).transform(val -> {
                try {
                    DataSegment segment = val.getDataSegment();
                    segmentsAlreadySeen.add(segment.getId());
                    PartialSegmentData partialSegmentData = (PartialSegmentData)partialSegmentDataMap.get(segment.getId());
                    long numReplicas = 0L;
                    long numRows = 0L;
                    long isRealtime = 0L;
                    long isAvailable = 0L;
                    if (partialSegmentData != null) {
                        numReplicas = partialSegmentData.getNumReplicas();
                        numRows = partialSegmentData.getNumRows();
                        isAvailable = partialSegmentData.isAvailable();
                        isRealtime = partialSegmentData.isRealtime();
                    }
                    return new Object[]{segment.getId(), segment.getDataSource(), segment.getInterval().getStart().toString(), segment.getInterval().getEnd().toString(), segment.getSize(), segment.getVersion(), (long)segment.getShardSpec().getPartitionNum(), numReplicas, numRows, 1L, isAvailable, isRealtime, val.isOvershadowed() ? 1L : 0L, this.jsonMapper.writeValueAsString(val)};
                }
                catch (JsonProcessingException e) {
                    throw new RE((Throwable)e, "Error getting segment payload for segment %s", new Object[]{val.getDataSegment().getId()});
                }
            });
            FluentIterable availableSegments = FluentIterable.from(() -> this.getAuthorizedAvailableSegments(availableSegmentEntries, root)).transform(val -> {
                try {
                    if (segmentsAlreadySeen.contains(val.getKey())) {
                        return null;
                    }
                    PartialSegmentData partialSegmentData = (PartialSegmentData)partialSegmentDataMap.get(val.getKey());
                    long numReplicas = partialSegmentData == null ? 0L : partialSegmentData.getNumReplicas();
                    return new Object[]{val.getKey(), ((SegmentId)val.getKey()).getDataSource(), ((SegmentId)val.getKey()).getInterval().getStart().toString(), ((SegmentId)val.getKey()).getInterval().getEnd().toString(), ((AvailableSegmentMetadata)val.getValue()).getSegment().getSize(), ((SegmentId)val.getKey()).getVersion(), (long)((AvailableSegmentMetadata)val.getValue()).getSegment().getShardSpec().getPartitionNum(), numReplicas, ((AvailableSegmentMetadata)val.getValue()).getNumRows(), 0L, 1L, ((AvailableSegmentMetadata)val.getValue()).isRealtime(), 0L, this.jsonMapper.writeValueAsString(val.getKey())};
                }
                catch (JsonProcessingException e) {
                    throw new RE((Throwable)e, "Error getting segment payload for segment %s", new Object[]{val.getKey()});
                }
            });
            Iterable allSegments = Iterables.unmodifiableIterable((Iterable)Iterables.concat((Iterable)publishedSegments, (Iterable)availableSegments));
            return Linq4j.asEnumerable((Iterable)allSegments).where(Objects::nonNull);
        }

        private Iterator<SegmentWithOvershadowedStatus> getAuthorizedPublishedSegments(Iterator<SegmentWithOvershadowedStatus> it, DataContext root) {
            AuthenticationResult authenticationResult = (AuthenticationResult)root.get("authenticationResult");
            Iterable authorizedSegments = AuthorizationUtils.filterAuthorizedResources((AuthenticationResult)authenticationResult, () -> it, (Function)SEGMENT_WITH_OVERSHADOWED_STATUS_RA_GENERATOR, (AuthorizerMapper)this.authorizerMapper);
            return authorizedSegments.iterator();
        }

        private Iterator<Map.Entry<SegmentId, AvailableSegmentMetadata>> getAuthorizedAvailableSegments(Iterator<Map.Entry<SegmentId, AvailableSegmentMetadata>> availableSegmentEntries, DataContext root) {
            AuthenticationResult authenticationResult = (AuthenticationResult)root.get("authenticationResult");
            Function raGenerator = segment -> Collections.singletonList(AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR.apply((Object)((SegmentId)segment.getKey()).getDataSource()));
            Iterable authorizedSegments = AuthorizationUtils.filterAuthorizedResources((AuthenticationResult)authenticationResult, () -> availableSegmentEntries, (Function)raGenerator, (AuthorizerMapper)this.authorizerMapper);
            return authorizedSegments.iterator();
        }

        private static class PartialSegmentData {
            private final long isAvailable;
            private final long isRealtime;
            private final long numReplicas;
            private final long numRows;

            public PartialSegmentData(long isAvailable, long isRealtime, long numReplicas, long numRows) {
                this.isAvailable = isAvailable;
                this.isRealtime = isRealtime;
                this.numReplicas = numReplicas;
                this.numRows = numRows;
            }

            public long isAvailable() {
                return this.isAvailable;
            }

            public long isRealtime() {
                return this.isRealtime;
            }

            public long getNumReplicas() {
                return this.numReplicas;
            }

            public long getNumRows() {
                return this.numRows;
            }
        }
    }
}

