/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.schema;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.druid.client.BrokerSegmentWatcherConfig;
import org.apache.druid.client.DataSegmentInterner;
import org.apache.druid.client.JsonParserIterator;
import org.apache.druid.client.coordinator.Coordinator;
import org.apache.druid.concurrent.LifecycleLock;
import org.apache.druid.discovery.DruidLeaderClient;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.server.coordinator.BytesAccumulatingResponseHandler;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentWithOvershadowedStatus;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.jboss.netty.handler.codec.http.HttpMethod;

@ManageLifecycle
public class MetadataSegmentView {
    private static final EmittingLogger log = new EmittingLogger(MetadataSegmentView.class);
    private final DruidLeaderClient coordinatorDruidLeaderClient;
    private final ObjectMapper jsonMapper;
    private final BytesAccumulatingResponseHandler responseHandler;
    private final BrokerSegmentWatcherConfig segmentWatcherConfig;
    private final boolean isCacheEnabled;
    private volatile @MonotonicNonNull ImmutableSortedSet<SegmentWithOvershadowedStatus> publishedSegments = null;
    private final ScheduledExecutorService scheduledExec;
    private final long pollPeriodInMS;
    private final LifecycleLock lifecycleLock = new LifecycleLock();
    private final CountDownLatch cachePopulated = new CountDownLatch(1);

    @Inject
    public MetadataSegmentView(@Coordinator DruidLeaderClient druidLeaderClient, ObjectMapper jsonMapper, BytesAccumulatingResponseHandler responseHandler, BrokerSegmentWatcherConfig segmentWatcherConfig, PlannerConfig plannerConfig) {
        Preconditions.checkNotNull((Object)plannerConfig, (Object)"plannerConfig");
        this.coordinatorDruidLeaderClient = druidLeaderClient;
        this.jsonMapper = jsonMapper;
        this.responseHandler = responseHandler;
        this.segmentWatcherConfig = segmentWatcherConfig;
        this.isCacheEnabled = plannerConfig.isMetadataSegmentCacheEnable();
        this.pollPeriodInMS = plannerConfig.getMetadataSegmentPollPeriod();
        this.scheduledExec = Execs.scheduledSingleThreaded((String)"MetadataSegmentView-Cache--%d");
    }

    @LifecycleStart
    public void start() {
        if (!this.lifecycleLock.canStart()) {
            throw new ISE("can't start.", new Object[0]);
        }
        try {
            if (this.isCacheEnabled) {
                this.scheduledExec.schedule(new PollTask(), this.pollPeriodInMS, TimeUnit.MILLISECONDS);
            }
            this.lifecycleLock.started();
            log.info("MetadataSegmentView Started.", new Object[0]);
        }
        finally {
            this.lifecycleLock.exitStart();
        }
    }

    @LifecycleStop
    public void stop() {
        if (!this.lifecycleLock.canStop()) {
            throw new ISE("can't stop.", new Object[0]);
        }
        log.info("MetadataSegmentView is stopping.", new Object[0]);
        if (this.isCacheEnabled) {
            this.scheduledExec.shutdown();
        }
        log.info("MetadataSegmentView Stopped.", new Object[0]);
    }

    private void poll() {
        log.info("polling published segments from coordinator", new Object[0]);
        JsonParserIterator<SegmentWithOvershadowedStatus> metadataSegments = this.getMetadataSegments(this.coordinatorDruidLeaderClient, this.jsonMapper, this.responseHandler, this.segmentWatcherConfig.getWatchedDataSources());
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        while (metadataSegments.hasNext()) {
            SegmentWithOvershadowedStatus segment = (SegmentWithOvershadowedStatus)metadataSegments.next();
            DataSegment interned = DataSegmentInterner.intern((DataSegment)segment.getDataSegment());
            SegmentWithOvershadowedStatus segmentWithOvershadowedStatus = new SegmentWithOvershadowedStatus(interned, segment.isOvershadowed());
            builder.add((Object)segmentWithOvershadowedStatus);
        }
        this.publishedSegments = builder.build();
        this.cachePopulated.countDown();
    }

    public Iterator<SegmentWithOvershadowedStatus> getPublishedSegments() {
        if (this.isCacheEnabled) {
            Uninterruptibles.awaitUninterruptibly((CountDownLatch)this.cachePopulated);
            return this.publishedSegments.iterator();
        }
        return this.getMetadataSegments(this.coordinatorDruidLeaderClient, this.jsonMapper, this.responseHandler, this.segmentWatcherConfig.getWatchedDataSources());
    }

    private JsonParserIterator<SegmentWithOvershadowedStatus> getMetadataSegments(DruidLeaderClient coordinatorClient, ObjectMapper jsonMapper, BytesAccumulatingResponseHandler responseHandler, Set<String> watchedDataSources) {
        Request request;
        String query = "/druid/coordinator/v1/metadata/segments?includeOvershadowedStatus";
        if (watchedDataSources != null && !watchedDataSources.isEmpty()) {
            log.debug("filtering datasources in published segments based on broker's watchedDataSources[%s]", new Object[]{watchedDataSources});
            StringBuilder sb = new StringBuilder();
            for (String ds : watchedDataSources) {
                sb.append("datasources=").append(ds).append("&");
            }
            sb.setLength(sb.length() - 1);
            query = "/druid/coordinator/v1/metadata/segments?includeOvershadowedStatus&" + sb;
        }
        try {
            request = coordinatorClient.makeRequest(HttpMethod.GET, StringUtils.format((String)query, (Object[])new Object[0]), false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ListenableFuture future = coordinatorClient.goAsync(request, (HttpResponseHandler)responseHandler);
        JavaType typeRef = jsonMapper.getTypeFactory().constructType((TypeReference)new TypeReference<SegmentWithOvershadowedStatus>(){});
        return new JsonParserIterator(typeRef, (Future)future, request.getUrl().toString(), null, request.getUrl().getHost(), jsonMapper, responseHandler);
    }

    private class PollTask
    implements Runnable {
        private PollTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long delayMS = MetadataSegmentView.this.pollPeriodInMS;
            try {
                long pollStartTime = System.nanoTime();
                MetadataSegmentView.this.poll();
                long pollEndTime = System.nanoTime();
                long pollTimeNS = pollEndTime - pollStartTime;
                long pollTimeMS = TimeUnit.NANOSECONDS.toMillis(pollTimeNS);
                delayMS = Math.max(MetadataSegmentView.this.pollPeriodInMS - pollTimeMS, 0L);
            }
            catch (Exception e) {
                log.makeAlert((Throwable)e, "Problem polling Coordinator.", new Object[0]).emit();
            }
            finally {
                if (!Thread.currentThread().isInterrupted()) {
                    MetadataSegmentView.this.scheduledExec.schedule(new PollTask(), delayMS, TimeUnit.MILLISECONDS);
                }
            }
        }
    }
}

