/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rel;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.NlsString;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.math.expr.Evals;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.Result;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.druid.query.topn.DimensionAndMetricValueExtractor;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.query.topn.TopNResultValue;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.server.QueryLifecycleFactory;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.sql.calcite.aggregation.DimensionExpression;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.CannotBuildQueryException;
import org.apache.druid.sql.calcite.rel.DruidQuery;
import org.apache.druid.sql.calcite.table.RowSignature;
import org.joda.time.DateTime;

public class QueryMaker {
    private final QueryLifecycleFactory queryLifecycleFactory;
    private final PlannerContext plannerContext;
    private final ObjectMapper jsonMapper;

    public QueryMaker(QueryLifecycleFactory queryLifecycleFactory, PlannerContext plannerContext, ObjectMapper jsonMapper) {
        this.queryLifecycleFactory = queryLifecycleFactory;
        this.plannerContext = plannerContext;
        this.jsonMapper = jsonMapper;
    }

    public PlannerContext getPlannerContext() {
        return this.plannerContext;
    }

    public ObjectMapper getJsonMapper() {
        return this.jsonMapper;
    }

    public Sequence<Object[]> runQuery(DruidQuery druidQuery) {
        Query query = druidQuery.getQuery();
        Query innerMostQuery = this.findInnerMostQuery(query);
        if (this.plannerContext.getPlannerConfig().isRequireTimeCondition() && innerMostQuery.getIntervals().equals(Intervals.ONLY_ETERNITY)) {
            throw new CannotBuildQueryException("requireTimeCondition is enabled, all queries must include a filter condition on the __time column");
        }
        if (query instanceof TimeseriesQuery) {
            return this.executeTimeseries(druidQuery, (TimeseriesQuery)query);
        }
        if (query instanceof TopNQuery) {
            return this.executeTopN(druidQuery, (TopNQuery)query);
        }
        if (query instanceof GroupByQuery) {
            return this.executeGroupBy(druidQuery, (GroupByQuery)query);
        }
        if (query instanceof ScanQuery) {
            return this.executeScan(druidQuery, (ScanQuery)query);
        }
        throw new ISE("Cannot run query of class[%s]", new Object[]{query.getClass().getName()});
    }

    private Query findInnerMostQuery(Query outerQuery) {
        Query query = outerQuery;
        while (query.getDataSource() instanceof QueryDataSource) {
            query = ((QueryDataSource)query.getDataSource()).getQuery();
        }
        return query;
    }

    private Sequence<Object[]> executeScan(DruidQuery druidQuery, ScanQuery query) {
        int i;
        List fieldList = druidQuery.getOutputRowType().getFieldList();
        RowSignature outputRowSignature = druidQuery.getOutputRowSignature();
        int[] columnMapping = new int[outputRowSignature.getRowOrder().size()];
        HashMap scanColumnOrder = new HashMap();
        for (i = 0; i < query.getColumns().size(); ++i) {
            scanColumnOrder.put(query.getColumns().get(i), i);
        }
        for (i = 0; i < outputRowSignature.getRowOrder().size(); ++i) {
            Integer index = (Integer)scanColumnOrder.get(outputRowSignature.getRowOrder().get(i));
            columnMapping[i] = index == null ? -1 : index;
        }
        return Sequences.concat((Sequence)Sequences.map(this.runQuery((Query)query), scanResult -> {
            ArrayList<Object[]> retVals = new ArrayList<Object[]>();
            List rows = (List)scanResult.getEvents();
            for (List row : rows) {
                Object[] retVal = new Object[fieldList.size()];
                for (RelDataTypeField field : fieldList) {
                    retVal[field.getIndex()] = this.coerce(row.get(columnMapping[field.getIndex()]), field.getType().getSqlTypeName());
                }
                retVals.add(retVal);
            }
            return Sequences.simple(retVals);
        }));
    }

    private <T> Sequence<T> runQuery(Query<T> query) {
        Hook.QUERY_PLAN.run(query);
        String queryId = UUID.randomUUID().toString();
        this.plannerContext.addNativeQueryId(queryId);
        query = query.withId(queryId).withSqlQueryId(this.plannerContext.getSqlQueryId());
        AuthenticationResult authenticationResult = this.plannerContext.getAuthenticationResult();
        return this.queryLifecycleFactory.factorize().runSimple(query, authenticationResult, null);
    }

    private Sequence<Object[]> executeTimeseries(final DruidQuery druidQuery, TimeseriesQuery query) {
        final List fieldList = druidQuery.getOutputRowType().getFieldList();
        final String timeOutputName = druidQuery.getGrouping().getDimensions().isEmpty() ? null : ((DimensionExpression)Iterables.getOnlyElement(druidQuery.getGrouping().getDimensions())).getOutputName();
        return Sequences.map(this.runQuery((Query)query), (Function)new Function<Result<TimeseriesResultValue>, Object[]>(){

            public Object[] apply(Result<TimeseriesResultValue> result) {
                Map row = ((TimeseriesResultValue)result.getValue()).getBaseObject();
                Object[] retVal = new Object[fieldList.size()];
                for (RelDataTypeField field : fieldList) {
                    String outputName = druidQuery.getOutputRowSignature().getRowOrder().get(field.getIndex());
                    if (outputName.equals(timeOutputName)) {
                        retVal[field.getIndex()] = QueryMaker.this.coerce(result.getTimestamp(), field.getType().getSqlTypeName());
                        continue;
                    }
                    retVal[field.getIndex()] = QueryMaker.this.coerce(row.get(outputName), field.getType().getSqlTypeName());
                }
                return retVal;
            }
        });
    }

    private Sequence<Object[]> executeTopN(final DruidQuery druidQuery, TopNQuery query) {
        final List fieldList = druidQuery.getOutputRowType().getFieldList();
        return Sequences.concat((Sequence)Sequences.map(this.runQuery((Query)query), (Function)new Function<Result<TopNResultValue>, Sequence<Object[]>>(){

            public Sequence<Object[]> apply(Result<TopNResultValue> result) {
                List rows = ((TopNResultValue)result.getValue()).getValue();
                ArrayList<Object[]> retVals = new ArrayList<Object[]>(rows.size());
                for (DimensionAndMetricValueExtractor row : rows) {
                    Object[] retVal = new Object[fieldList.size()];
                    for (RelDataTypeField field : fieldList) {
                        String outputName = druidQuery.getOutputRowSignature().getRowOrder().get(field.getIndex());
                        retVal[field.getIndex()] = QueryMaker.this.coerce(row.getMetric(outputName), field.getType().getSqlTypeName());
                    }
                    retVals.add(retVal);
                }
                return Sequences.simple(retVals);
            }
        }));
    }

    private Sequence<Object[]> executeGroupBy(DruidQuery druidQuery, GroupByQuery query) {
        List fieldList = druidQuery.getOutputRowType().getFieldList();
        Object2IntMap resultRowPositionLookup = query.getResultRowPositionLookup();
        List<String> sqlRowOrder = druidQuery.getOutputRowSignature().getRowOrder();
        int[] resultRowPositions = new int[fieldList.size()];
        for (RelDataTypeField field : fieldList) {
            int resultRowPosition;
            String columnName = sqlRowOrder.get(field.getIndex());
            resultRowPositions[field.getIndex()] = resultRowPosition = resultRowPositionLookup.applyAsInt((Object)columnName);
        }
        return Sequences.map(this.runQuery((Query)query), resultRow -> {
            Object[] retVal = new Object[fieldList.size()];
            for (RelDataTypeField field : fieldList) {
                retVal[field.getIndex()] = this.coerce(resultRow.get(resultRowPositions[field.getIndex()]), field.getType().getSqlTypeName());
            }
            return retVal;
        });
    }

    public static ColumnMetaData.Rep rep(SqlTypeName sqlType) {
        if (SqlTypeName.CHAR_TYPES.contains(sqlType)) {
            return ColumnMetaData.Rep.of(String.class);
        }
        if (sqlType == SqlTypeName.TIMESTAMP) {
            return ColumnMetaData.Rep.of(Long.class);
        }
        if (sqlType == SqlTypeName.DATE) {
            return ColumnMetaData.Rep.of(Integer.class);
        }
        if (sqlType == SqlTypeName.INTEGER) {
            return ColumnMetaData.Rep.of(Integer.class);
        }
        if (sqlType == SqlTypeName.BIGINT) {
            return ColumnMetaData.Rep.of(Long.class);
        }
        if (sqlType == SqlTypeName.FLOAT) {
            return ColumnMetaData.Rep.of(Float.class);
        }
        if (sqlType == SqlTypeName.DOUBLE || sqlType == SqlTypeName.DECIMAL) {
            return ColumnMetaData.Rep.of(Double.class);
        }
        if (sqlType == SqlTypeName.BOOLEAN) {
            return ColumnMetaData.Rep.of(Boolean.class);
        }
        if (sqlType == SqlTypeName.OTHER) {
            return ColumnMetaData.Rep.of(Object.class);
        }
        throw new ISE("No rep for SQL type[%s]", new Object[]{sqlType});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object coerce(Object value, SqlTypeName sqlType) {
        if (SqlTypeName.CHAR_TYPES.contains(sqlType)) {
            if (value == null) return NullHandling.nullToEmptyIfNeeded((String)((String)value));
            if (value instanceof String) {
                return NullHandling.nullToEmptyIfNeeded((String)((String)value));
            }
            if (value instanceof NlsString) {
                return ((NlsString)value).getValue();
            }
            if (value instanceof Number) {
                return String.valueOf(value);
            }
            if (!(value instanceof Collection)) throw new ISE("Cannot coerce[%s] to %s", new Object[]{value.getClass().getName(), sqlType});
            List valueStrings = ((Collection)value).stream().map(v -> (String)this.coerce(v, sqlType)).collect(Collectors.toList());
            try {
                return this.jsonMapper.writeValueAsString(valueStrings);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (value == null) {
            return null;
        }
        if (sqlType == SqlTypeName.DATE) {
            return Calcites.jodaToCalciteDate(QueryMaker.coerceDateTime(value, sqlType), this.plannerContext.getTimeZone());
        }
        if (sqlType == SqlTypeName.TIMESTAMP) {
            return Calcites.jodaToCalciteTimestamp(QueryMaker.coerceDateTime(value, sqlType), this.plannerContext.getTimeZone());
        }
        if (sqlType == SqlTypeName.BOOLEAN) {
            if (value instanceof String) {
                return Evals.asBoolean((String)((String)value));
            }
            if (!(value instanceof Number)) throw new ISE("Cannot coerce[%s] to %s", new Object[]{value.getClass().getName(), sqlType});
            return Evals.asBoolean((long)((Number)value).longValue());
        }
        if (sqlType == SqlTypeName.INTEGER) {
            if (value instanceof String) {
                return Ints.tryParse((String)((String)value));
            }
            if (!(value instanceof Number)) throw new ISE("Cannot coerce[%s] to %s", new Object[]{value.getClass().getName(), sqlType});
            return ((Number)value).intValue();
        }
        if (sqlType == SqlTypeName.BIGINT) {
            try {
                return DimensionHandlerUtils.convertObjectToLong((Object)value);
            }
            catch (Exception e) {
                throw new ISE("Cannot coerce[%s] to %s", new Object[]{value.getClass().getName(), sqlType});
            }
        }
        if (sqlType == SqlTypeName.FLOAT) {
            try {
                return DimensionHandlerUtils.convertObjectToFloat((Object)value);
            }
            catch (Exception e) {
                throw new ISE("Cannot coerce[%s] to %s", new Object[]{value.getClass().getName(), sqlType});
            }
        }
        if (SqlTypeName.FRACTIONAL_TYPES.contains(sqlType)) {
            try {
                return DimensionHandlerUtils.convertObjectToDouble((Object)value);
            }
            catch (Exception e) {
                throw new ISE("Cannot coerce[%s] to %s", new Object[]{value.getClass().getName(), sqlType});
            }
        }
        if (sqlType == SqlTypeName.OTHER) {
            if (!this.plannerContext.getPlannerConfig().shouldSerializeComplexValues()) return value.getClass().getName();
            try {
                return this.jsonMapper.writeValueAsString(value);
            }
            catch (JsonProcessingException jex) {
                throw new ISE((Throwable)jex, "Cannot coerce[%s] to %s", new Object[]{value.getClass().getName(), sqlType});
            }
        }
        if (sqlType != SqlTypeName.ARRAY) throw new ISE("Cannot coerce[%s] to %s", new Object[]{value.getClass().getName(), sqlType});
        try {
            return this.jsonMapper.writeValueAsString(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static DateTime coerceDateTime(Object value, SqlTypeName sqlType) {
        DateTime dateTime;
        if (value instanceof Number) {
            dateTime = DateTimes.utc((long)((Number)value).longValue());
        } else if (value instanceof String) {
            dateTime = DateTimes.utc((long)Long.parseLong((String)value));
        } else if (value instanceof DateTime) {
            dateTime = (DateTime)value;
        } else {
            throw new ISE("Cannot coerce[%s] to %s", new Object[]{value.getClass().getName(), sqlType});
        }
        return dateTime;
    }
}

