/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rel;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.having.DimFilterHavingSpec;
import org.apache.druid.query.groupby.having.HavingSpec;
import org.apache.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.druid.query.groupby.orderby.LimitSpec;
import org.apache.druid.query.groupby.orderby.NoopLimitSpec;
import org.apache.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.druid.query.ordering.StringComparator;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.topn.DimensionTopNMetricSpec;
import org.apache.druid.query.topn.InvertedTopNMetricSpec;
import org.apache.druid.query.topn.NumericTopNMetricSpec;
import org.apache.druid.query.topn.TopNMetricSpec;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.DimensionExpression;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.CannotBuildQueryException;
import org.apache.druid.sql.calcite.rel.Grouping;
import org.apache.druid.sql.calcite.rel.PartialDruidQuery;
import org.apache.druid.sql.calcite.rel.Projection;
import org.apache.druid.sql.calcite.rel.Sorting;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;
import org.apache.druid.sql.calcite.rule.GroupByRules;
import org.apache.druid.sql.calcite.table.RowSignature;

public class DruidQuery {
    private final DataSource dataSource;
    private final PlannerContext plannerContext;
    @Nullable
    private final DimFilter filter;
    @Nullable
    private final Projection selectProjection;
    @Nullable
    private final Grouping grouping;
    @Nullable
    private final Sorting sorting;
    private final Query query;
    private final RowSignature sourceRowSignature;
    private final RowSignature outputRowSignature;
    private final RelDataType outputRowType;
    private final VirtualColumnRegistry virtualColumnRegistry;

    public DruidQuery(PartialDruidQuery partialQuery, DataSource dataSource, RowSignature sourceRowSignature, PlannerContext plannerContext, RexBuilder rexBuilder, boolean finalizeAggregations) {
        this.dataSource = dataSource;
        this.outputRowType = partialQuery.leafRel().getRowType();
        this.sourceRowSignature = sourceRowSignature;
        this.virtualColumnRegistry = VirtualColumnRegistry.create(sourceRowSignature);
        this.plannerContext = plannerContext;
        this.filter = partialQuery.getWhereFilter() != null ? (DimFilter)Preconditions.checkNotNull((Object)DruidQuery.computeWhereFilter(partialQuery, plannerContext, sourceRowSignature, this.virtualColumnRegistry)) : null;
        this.selectProjection = partialQuery.getSelectProject() != null && partialQuery.getAggregate() == null ? (Projection)Preconditions.checkNotNull((Object)DruidQuery.computeSelectProjection(partialQuery, plannerContext, this.computeOutputRowSignature(), this.virtualColumnRegistry)) : null;
        this.grouping = partialQuery.getAggregate() != null ? (Grouping)Preconditions.checkNotNull((Object)DruidQuery.computeGrouping(partialQuery, plannerContext, this.computeOutputRowSignature(), this.virtualColumnRegistry, rexBuilder, finalizeAggregations)) : null;
        this.sorting = partialQuery.getSort() != null ? (Sorting)Preconditions.checkNotNull((Object)DruidQuery.computeSorting(partialQuery, plannerContext, this.computeOutputRowSignature(), partialQuery.getAggregate() != null ? null : this.virtualColumnRegistry)) : null;
        this.outputRowSignature = this.computeOutputRowSignature();
        this.query = this.computeQuery();
    }

    @Nonnull
    private static DimFilter computeWhereFilter(PartialDruidQuery partialQuery, PlannerContext plannerContext, RowSignature rowSignature, VirtualColumnRegistry virtualColumnRegistry) {
        return DruidQuery.getDimFilter(plannerContext, rowSignature, virtualColumnRegistry, partialQuery.getWhereFilter());
    }

    @Nullable
    private static DimFilter computeHavingFilter(PartialDruidQuery partialQuery, PlannerContext plannerContext, RowSignature aggregateSignature) {
        Filter havingFilter = partialQuery.getHavingFilter();
        if (havingFilter == null) {
            return null;
        }
        return DruidQuery.getDimFilter(plannerContext, aggregateSignature, null, havingFilter);
    }

    @Nonnull
    private static DimFilter getDimFilter(PlannerContext plannerContext, RowSignature rowSignature, @Nullable VirtualColumnRegistry virtualColumnRegistry, Filter filter) {
        RexNode condition = filter.getCondition();
        DimFilter dimFilter = Expressions.toFilter(plannerContext, rowSignature, virtualColumnRegistry, condition);
        if (dimFilter == null) {
            throw new CannotBuildQueryException((RelNode)filter, condition);
        }
        return dimFilter;
    }

    @Nonnull
    private static Projection computeSelectProjection(PartialDruidQuery partialQuery, PlannerContext plannerContext, RowSignature rowSignature, VirtualColumnRegistry virtualColumnRegistry) {
        Project project = (Project)Preconditions.checkNotNull((Object)partialQuery.getSelectProject(), (Object)"selectProject");
        if (partialQuery.getAggregate() != null) {
            throw new ISE("Cannot have both 'selectProject' and 'aggregate', how can this be?", new Object[0]);
        }
        return Projection.preAggregation(project, plannerContext, rowSignature, virtualColumnRegistry);
    }

    @Nonnull
    private static Grouping computeGrouping(PartialDruidQuery partialQuery, PlannerContext plannerContext, RowSignature rowSignature, VirtualColumnRegistry virtualColumnRegistry, RexBuilder rexBuilder, boolean finalizeAggregations) {
        Aggregate aggregate = (Aggregate)Preconditions.checkNotNull((Object)partialQuery.getAggregate(), (Object)"aggregate");
        Project aggregateProject = partialQuery.getAggregateProject();
        List<DimensionExpression> dimensions = DruidQuery.computeDimensions(partialQuery, plannerContext, rowSignature, virtualColumnRegistry);
        List<Aggregation> aggregations = DruidQuery.computeAggregations(partialQuery, plannerContext, rowSignature, virtualColumnRegistry, rexBuilder, finalizeAggregations);
        RowSignature aggregateRowSignature = RowSignature.from((List<String>)ImmutableList.copyOf((Iterator)Iterators.concat(dimensions.stream().map(DimensionExpression::getOutputName).iterator(), aggregations.stream().map(Aggregation::getOutputName).iterator())), aggregate.getRowType());
        DimFilter havingFilter = DruidQuery.computeHavingFilter(partialQuery, plannerContext, aggregateRowSignature);
        if (aggregateProject == null) {
            return Grouping.create(dimensions, aggregations, havingFilter, aggregateRowSignature);
        }
        Projection postAggregationProjection = Projection.postAggregation(aggregateProject, plannerContext, aggregateRowSignature, "p");
        postAggregationProjection.getPostAggregators().forEach(postAggregator -> aggregations.add(Aggregation.create(postAggregator)));
        ImmutableBitSet aggregateProjectBits = RelOptUtil.InputFinder.bits((List)aggregateProject.getChildExps(), null);
        for (int i = dimensions.size() - 1; i >= 0; --i) {
            DimensionExpression dimension = dimensions.get(i);
            if (!Parser.parse((String)dimension.getDruidExpression().getExpression(), (ExprMacroTable)plannerContext.getExprMacroTable()).isLiteral() || aggregateProjectBits.get(i)) continue;
            dimensions.remove(i);
        }
        return Grouping.create(dimensions, aggregations, havingFilter, postAggregationProjection.getOutputRowSignature());
    }

    private static List<DimensionExpression> computeDimensions(PartialDruidQuery partialQuery, PlannerContext plannerContext, RowSignature rowSignature, VirtualColumnRegistry virtualColumnRegistry) {
        Aggregate aggregate = (Aggregate)Preconditions.checkNotNull((Object)partialQuery.getAggregate());
        ArrayList<DimensionExpression> dimensions = new ArrayList<DimensionExpression>();
        String outputNamePrefix = Calcites.findUnusedPrefix("d", new TreeSet<String>(rowSignature.getRowOrder()));
        int outputNameCounter = 0;
        Iterator iterator = aggregate.getGroupSet().iterator();
        while (iterator.hasNext()) {
            String dimOutputName;
            int i = (Integer)iterator.next();
            RexNode rexNode = Expressions.fromFieldAccess(rowSignature, partialQuery.getSelectProject(), i);
            DruidExpression druidExpression = Expressions.toDruidExpression(plannerContext, rowSignature, rexNode);
            if (druidExpression == null) {
                throw new CannotBuildQueryException((RelNode)aggregate, rexNode);
            }
            SqlTypeName sqlTypeName = rexNode.getType().getSqlTypeName();
            ValueType outputType = Calcites.getValueTypeForSqlTypeName(sqlTypeName);
            if (outputType == null || outputType == ValueType.COMPLEX) {
                throw new CannotBuildQueryException((RelNode)aggregate, rexNode);
            }
            if (!druidExpression.isSimpleExtraction()) {
                VirtualColumn virtualColumn = virtualColumnRegistry.getOrCreateVirtualColumnForExpression(plannerContext, druidExpression, sqlTypeName);
                dimOutputName = virtualColumn.getOutputName();
            } else {
                dimOutputName = outputNamePrefix + outputNameCounter++;
            }
            dimensions.add(new DimensionExpression(dimOutputName, druidExpression, outputType));
        }
        return dimensions;
    }

    private static List<Aggregation> computeAggregations(PartialDruidQuery partialQuery, PlannerContext plannerContext, RowSignature rowSignature, VirtualColumnRegistry virtualColumnRegistry, RexBuilder rexBuilder, boolean finalizeAggregations) {
        Aggregate aggregate = (Aggregate)Preconditions.checkNotNull((Object)partialQuery.getAggregate());
        ArrayList<Aggregation> aggregations = new ArrayList<Aggregation>();
        String outputNamePrefix = Calcites.findUnusedPrefix("a", new TreeSet<String>(rowSignature.getRowOrder()));
        for (int i = 0; i < aggregate.getAggCallList().size(); ++i) {
            String aggName = outputNamePrefix + i;
            AggregateCall aggCall = (AggregateCall)aggregate.getAggCallList().get(i);
            Aggregation aggregation = GroupByRules.translateAggregateCall(plannerContext, rowSignature, virtualColumnRegistry, rexBuilder, partialQuery.getSelectProject(), aggregations, aggName, aggCall, finalizeAggregations);
            if (aggregation == null) {
                throw new CannotBuildQueryException((RelNode)aggregate, aggCall);
            }
            aggregations.add(aggregation);
        }
        return aggregations;
    }

    @Nonnull
    private static Sorting computeSorting(PartialDruidQuery partialQuery, PlannerContext plannerContext, RowSignature rowSignature, @Nullable VirtualColumnRegistry virtualColumnRegistry) {
        Projection projection;
        Sort sort = (Sort)Preconditions.checkNotNull((Object)partialQuery.getSort(), (Object)"sort");
        Project sortProject = partialQuery.getSortProject();
        Long limit = sort.fetch != null ? Long.valueOf(((Number)((Object)RexLiteral.value((RexNode)sort.fetch))).longValue()) : null;
        ArrayList<OrderByColumnSpec> orderBys = new ArrayList<OrderByColumnSpec>(sort.getChildExps().size());
        if (sort.offset != null) {
            throw new CannotBuildQueryException((RelNode)sort);
        }
        for (int sortKey = 0; sortKey < sort.getChildExps().size(); ++sortKey) {
            OrderByColumnSpec.Direction direction;
            RexNode sortExpression = (RexNode)sort.getChildExps().get(sortKey);
            RelFieldCollation collation = (RelFieldCollation)sort.getCollation().getFieldCollations().get(sortKey);
            if (collation.getDirection() == RelFieldCollation.Direction.ASCENDING) {
                direction = OrderByColumnSpec.Direction.ASCENDING;
            } else if (collation.getDirection() == RelFieldCollation.Direction.DESCENDING) {
                direction = OrderByColumnSpec.Direction.DESCENDING;
            } else {
                throw new ISE("WTF?! Don't know what to do with direction[%s]", new Object[]{collation.getDirection()});
            }
            SqlTypeName sortExpressionType = sortExpression.getType().getSqlTypeName();
            StringComparator comparator = SqlTypeName.NUMERIC_TYPES.contains(sortExpressionType) || SqlTypeName.TIMESTAMP == sortExpressionType || SqlTypeName.DATE == sortExpressionType ? StringComparators.NUMERIC : StringComparators.LEXICOGRAPHIC;
            if (!sortExpression.isA(SqlKind.INPUT_REF)) {
                throw new CannotBuildQueryException((RelNode)sort, sortExpression);
            }
            RexInputRef ref = (RexInputRef)sortExpression;
            String fieldName = rowSignature.getRowOrder().get(ref.getIndex());
            orderBys.add(new OrderByColumnSpec(fieldName, direction, comparator));
        }
        if (sortProject == null) {
            projection = null;
        } else if (partialQuery.getAggregate() == null) {
            if (virtualColumnRegistry == null) {
                throw new ISE("Must provide 'virtualColumnRegistry' for pre-aggregation Projection!", new Object[0]);
            }
            projection = Projection.preAggregation(sortProject, plannerContext, rowSignature, virtualColumnRegistry);
        } else {
            projection = Projection.postAggregation(sortProject, plannerContext, rowSignature, "s");
        }
        return Sorting.create(orderBys, limit, projection);
    }

    private VirtualColumns getVirtualColumns(boolean includeDimensions) {
        HashSet<VirtualColumn> virtualColumns = new HashSet<VirtualColumn>();
        if (this.filter != null) {
            for (String columnName : this.filter.getRequiredColumns()) {
                if (!this.virtualColumnRegistry.isVirtualColumnDefined(columnName)) continue;
                virtualColumns.add(this.virtualColumnRegistry.getVirtualColumn(columnName));
            }
        }
        if (this.selectProjection != null) {
            virtualColumns.addAll(this.selectProjection.getVirtualColumns());
        }
        if (this.grouping != null) {
            if (includeDimensions) {
                for (DimensionExpression expression : this.grouping.getDimensions()) {
                    if (!this.virtualColumnRegistry.isVirtualColumnDefined(expression.getOutputName())) continue;
                    virtualColumns.add(this.virtualColumnRegistry.getVirtualColumn(expression.getOutputName()));
                }
            }
            for (Aggregation aggregation : this.grouping.getAggregations()) {
                virtualColumns.addAll(aggregation.getVirtualColumns());
            }
        }
        if (this.sorting != null && this.sorting.getProjection() != null && this.grouping == null) {
            virtualColumns.addAll(this.sorting.getProjection().getVirtualColumns());
        }
        ArrayList<VirtualColumn> columns = new ArrayList<VirtualColumn>(virtualColumns);
        columns.sort(Comparator.comparing(VirtualColumn::getOutputName));
        return VirtualColumns.create(columns);
    }

    @Nullable
    public Grouping getGrouping() {
        return this.grouping;
    }

    public RelDataType getOutputRowType() {
        return this.outputRowType;
    }

    public RowSignature getOutputRowSignature() {
        return this.outputRowSignature;
    }

    public Query getQuery() {
        return this.query;
    }

    private RowSignature computeOutputRowSignature() {
        if (this.sorting != null && this.sorting.getProjection() != null) {
            return this.sorting.getProjection().getOutputRowSignature();
        }
        if (this.grouping != null) {
            Preconditions.checkState((this.selectProjection == null ? 1 : 0) != 0, (Object)"Cannot have both 'grouping' and 'selectProjection'");
            return this.grouping.getOutputRowSignature();
        }
        if (this.selectProjection != null) {
            return this.selectProjection.getOutputRowSignature();
        }
        return this.sourceRowSignature;
    }

    private Query computeQuery() {
        if (this.dataSource instanceof QueryDataSource) {
            GroupByQuery outerQuery = this.toGroupByQuery();
            if (outerQuery == null) {
                throw new IllegalStateException("Can't use QueryDataSource without an outer groupBy query!");
            }
            return outerQuery;
        }
        TimeseriesQuery tsQuery = this.toTimeseriesQuery();
        if (tsQuery != null) {
            return tsQuery;
        }
        TopNQuery topNQuery = this.toTopNQuery();
        if (topNQuery != null) {
            return topNQuery;
        }
        GroupByQuery groupByQuery = this.toGroupByQuery();
        if (groupByQuery != null) {
            return groupByQuery;
        }
        ScanQuery scanQuery = this.toScanQuery();
        if (scanQuery != null) {
            return scanQuery;
        }
        throw new CannotBuildQueryException("Cannot convert query parts into an actual query");
    }

    @Nullable
    public TimeseriesQuery toTimeseriesQuery() {
        boolean descending;
        Granularity queryGranularity;
        int timeseriesLimit;
        block9: {
            block10: {
                block11: {
                    block8: {
                        if (this.grouping == null || this.grouping.getHavingFilter() != null) {
                            return null;
                        }
                        timeseriesLimit = 0;
                        if (!this.grouping.getDimensions().isEmpty()) break block8;
                        queryGranularity = Granularities.ALL;
                        descending = false;
                        break block9;
                    }
                    if (this.grouping.getDimensions().size() != 1) break block10;
                    DimensionExpression dimensionExpression = (DimensionExpression)Iterables.getOnlyElement(this.grouping.getDimensions());
                    queryGranularity = Expressions.toQueryGranularity(dimensionExpression.getDruidExpression(), this.plannerContext.getExprMacroTable());
                    if (queryGranularity == null) {
                        return null;
                    }
                    if (this.sorting == null) break block11;
                    if (this.sorting.isLimited()) {
                        timeseriesLimit = Ints.checkedCast((long)this.sorting.getLimit());
                    }
                    switch (this.sorting.getSortKind(dimensionExpression.getOutputName())) {
                        case UNORDERED: 
                        case TIME_ASCENDING: {
                            descending = false;
                            break block9;
                        }
                        case TIME_DESCENDING: {
                            descending = true;
                            break block9;
                        }
                        default: {
                            return null;
                        }
                    }
                }
                descending = false;
                break block9;
            }
            return null;
        }
        Filtration filtration = Filtration.create(this.filter).optimize(this.virtualColumnRegistry.getFullRowSignature());
        ArrayList<PostAggregator> postAggregators = new ArrayList<PostAggregator>(this.grouping.getPostAggregators());
        if (this.sorting != null && this.sorting.getProjection() != null) {
            postAggregators.addAll(this.sorting.getProjection().getPostAggregators());
        }
        HashMap<String, Object> theContext = new HashMap<String, Object>();
        theContext.put("skipEmptyBuckets", true);
        theContext.putAll(this.plannerContext.getQueryContext());
        return new TimeseriesQuery(this.dataSource, filtration.getQuerySegmentSpec(), descending, this.getVirtualColumns(false), filtration.getDimFilter(), queryGranularity, this.grouping.getAggregatorFactories(), postAggregators, timeseriesLimit, (Map)ImmutableSortedMap.copyOf(theContext));
    }

    @Nullable
    public TopNQuery toTopNQuery() {
        DimensionTopNMetricSpec topNMetricSpec;
        DimensionTopNMetricSpec baseMetricSpec;
        boolean topNOk;
        boolean bl = topNOk = this.grouping != null && this.grouping.getDimensions().size() == 1 && this.sorting != null && this.sorting.getOrderBys().size() <= 1 && this.sorting.isLimited() && this.sorting.getLimit() <= (long)this.plannerContext.getPlannerConfig().getMaxTopNLimit() && this.grouping.getHavingFilter() == null;
        if (!topNOk) {
            return null;
        }
        DimensionSpec dimensionSpec = ((DimensionExpression)Iterables.getOnlyElement(this.grouping.getDimensions())).toDimensionSpec();
        OrderByColumnSpec limitColumn = this.sorting.getOrderBys().isEmpty() ? new OrderByColumnSpec(dimensionSpec.getOutputName(), OrderByColumnSpec.Direction.ASCENDING, Calcites.getStringComparatorForValueType(dimensionSpec.getOutputType())) : (OrderByColumnSpec)Iterables.getOnlyElement(this.sorting.getOrderBys());
        if (limitColumn.getDimension().equals(dimensionSpec.getOutputName())) {
            baseMetricSpec = new DimensionTopNMetricSpec(null, limitColumn.getDimensionComparator());
            topNMetricSpec = limitColumn.getDirection() == OrderByColumnSpec.Direction.ASCENDING ? baseMetricSpec : new InvertedTopNMetricSpec((TopNMetricSpec)baseMetricSpec);
        } else if (this.plannerContext.getPlannerConfig().isUseApproximateTopN()) {
            baseMetricSpec = new NumericTopNMetricSpec(limitColumn.getDimension());
            topNMetricSpec = limitColumn.getDirection() == OrderByColumnSpec.Direction.ASCENDING ? new InvertedTopNMetricSpec((TopNMetricSpec)baseMetricSpec) : baseMetricSpec;
        } else {
            return null;
        }
        Filtration filtration = Filtration.create(this.filter).optimize(this.virtualColumnRegistry.getFullRowSignature());
        ArrayList<PostAggregator> postAggregators = new ArrayList<PostAggregator>(this.grouping.getPostAggregators());
        if (this.sorting.getProjection() != null) {
            postAggregators.addAll(this.sorting.getProjection().getPostAggregators());
        }
        return new TopNQuery(this.dataSource, this.getVirtualColumns(true), dimensionSpec, (TopNMetricSpec)topNMetricSpec, Ints.checkedCast((long)this.sorting.getLimit()), filtration.getQuerySegmentSpec(), filtration.getDimFilter(), Granularities.ALL, this.grouping.getAggregatorFactories(), postAggregators, (Map)ImmutableSortedMap.copyOf(this.plannerContext.getQueryContext()));
    }

    @Nullable
    public GroupByQuery toGroupByQuery() {
        if (this.grouping == null) {
            return null;
        }
        Filtration filtration = Filtration.create(this.filter).optimize(this.virtualColumnRegistry.getFullRowSignature());
        DimFilterHavingSpec havingSpec = this.grouping.getHavingFilter() != null ? new DimFilterHavingSpec(Filtration.create(this.grouping.getHavingFilter()).optimizeFilterOnly(this.grouping.getOutputRowSignature()).getDimFilter(), Boolean.valueOf(true)) : null;
        ArrayList<PostAggregator> postAggregators = new ArrayList<PostAggregator>(this.grouping.getPostAggregators());
        if (this.sorting != null && this.sorting.getProjection() != null) {
            postAggregators.addAll(this.sorting.getProjection().getPostAggregators());
        }
        return new GroupByQuery(this.dataSource, filtration.getQuerySegmentSpec(), this.getVirtualColumns(true), filtration.getDimFilter(), Granularities.ALL, this.grouping.getDimensionSpecs(), this.grouping.getAggregatorFactories(), postAggregators, (HavingSpec)havingSpec, (LimitSpec)(this.sorting != null ? new DefaultLimitSpec(this.sorting.getOrderBys(), this.sorting.isLimited() ? Integer.valueOf(Ints.checkedCast((long)this.sorting.getLimit())) : null) : NoopLimitSpec.instance()), null, (Map)ImmutableSortedMap.copyOf(this.plannerContext.getQueryContext()));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public ScanQuery toScanQuery() {
        ScanQuery.Order order;
        long scanLimit;
        Filtration filtration;
        block9: {
            block10: {
                Sorting.SortKind sortKind;
                block11: {
                    if (this.grouping != null) {
                        return null;
                    }
                    if (this.outputRowSignature.getRowOrder().isEmpty()) {
                        throw new ISE("WTF?! Attempting to convert to Scan query without any columns?", new Object[0]);
                    }
                    filtration = Filtration.create(this.filter).optimize(this.virtualColumnRegistry.getFullRowSignature());
                    scanLimit = 0L;
                    if (this.sorting == null) break block10;
                    if (this.sorting.isLimited()) {
                        scanLimit = this.sorting.getLimit();
                    }
                    if ((sortKind = this.sorting.getSortKind("__time")) != Sorting.SortKind.UNORDERED) break block11;
                    order = ScanQuery.Order.NONE;
                    break block9;
                }
                if (sortKind == Sorting.SortKind.TIME_ASCENDING) {
                    order = ScanQuery.Order.ASCENDING;
                    break block9;
                } else if (sortKind == Sorting.SortKind.TIME_DESCENDING) {
                    order = ScanQuery.Order.DESCENDING;
                    break block9;
                } else {
                    assert (sortKind == Sorting.SortKind.NON_TIME);
                    return null;
                }
            }
            order = ScanQuery.Order.NONE;
        }
        HashSet<String> columns = new HashSet<String>(this.outputRowSignature.getRowOrder());
        if (order != ScanQuery.Order.NONE) {
            columns.add("__time");
        }
        return new ScanQuery(this.dataSource, filtration.getQuerySegmentSpec(), this.getVirtualColumns(true), ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST, 0, scanLimit, order, filtration.getDimFilter(), Ordering.natural().sortedCopy(columns), Boolean.valueOf(false), (Map)ImmutableSortedMap.copyOf(this.plannerContext.getQueryContext()));
    }
}

