/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import com.google.common.collect.ImmutableList;
import java.util.stream.Collectors;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.table.RowSignature;
import org.joda.time.DateTimeZone;

public class TimeShiftOperatorConversion
implements SqlOperatorConversion {
    private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("TIME_SHIFT").operandTypes(SqlTypeFamily.TIMESTAMP, SqlTypeFamily.CHARACTER, SqlTypeFamily.INTEGER, SqlTypeFamily.CHARACTER).requiredOperands(3).returnType(SqlTypeName.TIMESTAMP).functionCategory(SqlFunctionCategory.TIMEDATE).build();

    @Override
    public SqlOperator calciteOperator() {
        return SQL_FUNCTION;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        RexCall call = (RexCall)rexNode;
        DruidExpression timeExpression = Expressions.toDruidExpression(plannerContext, rowSignature, (RexNode)call.getOperands().get(0));
        DruidExpression periodExpression = Expressions.toDruidExpression(plannerContext, rowSignature, (RexNode)call.getOperands().get(1));
        DruidExpression stepExpression = Expressions.toDruidExpression(plannerContext, rowSignature, (RexNode)call.getOperands().get(2));
        if (timeExpression == null || periodExpression == null || stepExpression == null) {
            return null;
        }
        DateTimeZone timeZone = OperatorConversions.getOperandWithDefault(call.getOperands(), 3, operand -> DateTimes.inferTzFromString((String)RexLiteral.stringValue((RexNode)operand)), plannerContext.getTimeZone());
        return DruidExpression.fromFunctionCall("timestamp_shift", ImmutableList.of((Object)timeExpression.getExpression(), (Object)periodExpression.getExpression(), (Object)stepExpression.getExpression(), (Object)DruidExpression.stringLiteral(timeZone.getID())).stream().map(DruidExpression::fromExpression).collect(Collectors.toList()));
    }
}

