/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.table.RowSignature;

public class RightOperatorConversion
implements SqlOperatorConversion {
    private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("RIGHT").operandTypes(SqlTypeFamily.CHARACTER, SqlTypeFamily.INTEGER).functionCategory(SqlFunctionCategory.STRING).returnType(SqlTypeName.VARCHAR).build();

    @Override
    public SqlOperator calciteOperator() {
        return SQL_FUNCTION;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        RexCall call = (RexCall)rexNode;
        DruidExpression input = Expressions.toDruidExpression(plannerContext, rowSignature, (RexNode)call.getOperands().get(0));
        if (input == null) {
            return null;
        }
        if (call.getOperands().size() != 2) {
            return null;
        }
        return OperatorConversions.convertCall(plannerContext, rowSignature, rexNode, druidExpressions -> DruidExpression.of(null, DruidExpression.functionCall("right", druidExpressions)));
    }
}

