/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.aggregation.builtin;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.post.ArithmeticPostAggregator;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.builtin.SimpleSqlAggregator;
import org.apache.druid.sql.calcite.aggregation.builtin.SumSqlAggregator;
import org.apache.druid.sql.calcite.planner.Calcites;

public class AvgSqlAggregator
extends SimpleSqlAggregator {
    @Override
    public SqlAggFunction calciteFunction() {
        return SqlStdOperatorTable.AVG;
    }

    @Override
    Aggregation getAggregation(String name, AggregateCall aggregateCall, ExprMacroTable macroTable, String fieldName, String expression) {
        ValueType sumType = SqlTypeName.INT_TYPES.contains(aggregateCall.getType().getSqlTypeName()) ? ValueType.LONG : ValueType.DOUBLE;
        String sumName = Calcites.makePrefixedName(name, "sum");
        String countName = Calcites.makePrefixedName(name, "count");
        AggregatorFactory sum = SumSqlAggregator.createSumAggregatorFactory(sumType, sumName, fieldName, expression, macroTable);
        CountAggregatorFactory count = new CountAggregatorFactory(countName);
        return Aggregation.create((List<AggregatorFactory>)ImmutableList.of((Object)sum, (Object)count), (PostAggregator)new ArithmeticPostAggregator(name, "quotient", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, sumName), (Object)new FieldAccessPostAggregator(null, countName))));
    }
}

