/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.shaded.guava.com.google.common.util.concurrent;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.drill.shaded.guava.com.google.common.annotations.GwtCompatible;

@GwtCompatible(emulated=true)
abstract class InterruptibleTask
extends AtomicReference<Thread>
implements Runnable {
    private volatile boolean doneInterrupting;

    InterruptibleTask() {
    }

    @Override
    public final void run() {
        if (!this.compareAndSet(null, Thread.currentThread())) {
            return;
        }
        try {
            this.runInterruptibly();
        }
        finally {
            if (this.wasInterrupted()) {
                while (!this.doneInterrupting) {
                    Thread.yield();
                }
            }
        }
    }

    abstract void runInterruptibly();

    abstract boolean wasInterrupted();

    final void interruptTask() {
        Thread currentRunner = (Thread)this.get();
        if (currentRunner != null) {
            currentRunner.interrupt();
        }
        this.doneInterrupting = true;
    }

    @Override
    public abstract String toString();
}

