/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import org.apache.directory.shared.ldap.message.IteratorNamingEnumeration;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeImpl
implements Attribute {
    private static final Logger log = LoggerFactory.getLogger(AttributeImpl.class);
    private static final long serialVersionUID = -5158233254341746514L;
    private final String upId;
    private Object value;
    private List<Object> list;
    private int size = 0;

    public AttributeImpl(String id) {
        this.upId = id;
        this.value = null;
        this.list = null;
        this.size = 0;
    }

    public AttributeImpl(String id, Object value) {
        this.upId = id;
        this.list = null;
        this.value = AttributeUtils.cloneValue(value);
        this.size = 1;
    }

    public AttributeImpl(String id, byte[] value) {
        this.upId = id;
        this.list = null;
        this.value = AttributeUtils.cloneValue(value);
        this.size = 1;
    }

    public AttributeImpl(Attribute attribute) throws NamingException {
        if (attribute == null) {
            throw new NamingException("Null attribute is not allowed");
        }
        if (attribute instanceof AttributeImpl) {
            AttributeImpl clone = (AttributeImpl)attribute.clone();
            this.upId = clone.upId;
            this.list = clone.list;
            this.size = clone.size;
            this.value = clone.value;
        } else if (attribute instanceof BasicAttribute) {
            this.upId = attribute.getID();
            NamingEnumeration<?> values = attribute.getAll();
            while (values.hasMoreElements()) {
                this.add(values.nextElement());
            }
        } else {
            throw new NamingException("Attribute must be an instance of BasicAttribute or AttributeImpl");
        }
    }

    public NamingEnumeration<Object> getAll() {
        if (this.size < 2) {
            return new IteratorNamingEnumeration<Object>(new Iterator<Object>(){
                private boolean more;
                {
                    this.more = AttributeImpl.this.size != 0;
                }

                @Override
                public boolean hasNext() {
                    return this.more;
                }

                @Override
                public Object next() {
                    this.more = false;
                    return AttributeImpl.this.value;
                }

                @Override
                public void remove() {
                    AttributeImpl.this.value = null;
                    this.more = true;
                    AttributeImpl.this.size = 0;
                }
            });
        }
        return new IteratorNamingEnumeration<Object>(this.list.iterator());
    }

    @Override
    public Object get() {
        if (this.size < 2) {
            return this.value;
        }
        return this.list.get(0);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public String getID() {
        return this.upId;
    }

    @Override
    public boolean contains(Object attrVal) {
        switch (this.size) {
            case 0: {
                return false;
            }
            case 1: {
                return AttributeUtils.equals(this.value, attrVal);
            }
        }
        Iterator<Object> values = this.list.iterator();
        while (values.hasNext()) {
            if (!AttributeUtils.equals(values.next(), attrVal)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean add(Object attrVal) {
        boolean exists = false;
        if (this.contains(attrVal)) {
            return true;
        }
        attrVal = AttributeUtils.cloneValue(attrVal);
        switch (this.size) {
            case 0: {
                this.value = attrVal;
                ++this.size;
                return true;
            }
            case 1: {
                exists = this.value.equals(attrVal);
                if (exists) {
                    return true;
                }
                this.list = new ArrayList<Object>();
                this.list.add(this.value);
                this.list.add(attrVal);
                ++this.size;
                this.value = null;
                return true;
            }
        }
        exists = this.list.contains(attrVal);
        this.list.add(attrVal);
        ++this.size;
        return exists;
    }

    @Override
    public boolean remove(Object attrVal) {
        switch (this.size) {
            case 0: {
                return false;
            }
            case 1: {
                this.value = null;
                --this.size;
                return true;
            }
            case 2: {
                this.list.remove(attrVal);
                this.value = this.list.get(0);
                this.size = 1;
                this.list = null;
                return true;
            }
        }
        this.list.remove(attrVal);
        --this.size;
        return true;
    }

    @Override
    public void clear() {
        switch (this.size) {
            case 0: {
                return;
            }
            case 1: {
                this.value = null;
                this.size = 0;
                return;
            }
        }
        this.list = null;
        this.size = 0;
    }

    @Override
    public DirContext getAttributeSyntaxDefinition() throws NamingException {
        throw new OperationNotSupportedException("Extending subclasses may override this if they like!");
    }

    @Override
    public DirContext getAttributeDefinition() throws NamingException {
        throw new OperationNotSupportedException("Extending subclasses may override this if they like!");
    }

    @Override
    public Object clone() {
        try {
            AttributeImpl clone = (AttributeImpl)super.clone();
            if (this.size < 2) {
                clone.value = AttributeUtils.cloneValue(this.value);
            } else {
                clone.list = new ArrayList<Object>(this.size);
                for (int i = 0; i < this.size; ++i) {
                    Object newValue = AttributeUtils.cloneValue(this.list.get(i));
                    clone.list.add(newValue);
                }
            }
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    @Override
    public boolean isOrdered() {
        return true;
    }

    @Override
    public Object get(int index) {
        if (index < 0 || index > this.size + 1) {
            return null;
        }
        switch (this.size) {
            case 0: {
                return null;
            }
            case 1: {
                return this.value;
            }
        }
        return this.list.get(index);
    }

    @Override
    public Object remove(int index) {
        if (index < 0 || index > this.size + 1) {
            return null;
        }
        switch (this.size) {
            case 0: {
                return null;
            }
            case 1: {
                Object result = this.value;
                this.value = null;
                this.size = 0;
                return result;
            }
            case 2: {
                Object removed = this.list.remove(index);
                this.value = this.list.get(0);
                this.size = 1;
                this.list = null;
                return removed;
            }
        }
        --this.size;
        return this.list.remove(index);
    }

    @Override
    public void add(int index, Object attrVal) {
        attrVal = AttributeUtils.cloneValue(attrVal);
        switch (this.size) {
            case 0: {
                ++this.size;
                this.value = attrVal;
                return;
            }
            case 1: {
                this.list = new ArrayList<Object>();
                if (index == 0) {
                    this.list.add(attrVal);
                    this.list.add(this.value);
                } else {
                    this.list.add(this.value);
                    this.list.add(attrVal);
                }
                ++this.size;
                this.value = null;
                return;
            }
        }
        this.list.add(index, attrVal);
        ++this.size;
    }

    @Override
    public Object set(int index, Object attrVal) {
        attrVal = AttributeUtils.cloneValue(attrVal);
        switch (this.size) {
            case 0: {
                ++this.size;
                this.value = attrVal;
                return null;
            }
            case 1: {
                if (index == 0) {
                    Object result = this.value;
                    this.value = attrVal;
                    return result;
                }
                this.list = new ArrayList<Object>();
                this.list.add(this.value);
                this.list.add(attrVal);
                this.size = 2;
                this.value = null;
                return null;
            }
        }
        Object oldValue = this.list.get(index);
        this.list.set(index, attrVal);
        return oldValue;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof AttributeImpl)) {
            return false;
        }
        Attribute attr = (Attribute)obj;
        if (!this.upId.equals(attr.getID())) {
            return false;
        }
        if (attr.size() != this.size) {
            return false;
        }
        if (this.size == 0) {
            return true;
        }
        if (this.size == 1) {
            try {
                return this.value.equals(attr.get(0));
            }
            catch (NamingException ne) {
                log.warn("Failed to get an attribute from the specifid attribute: " + attr, (Throwable)ne);
                return false;
            }
        }
        HashMap<Integer, Object> hash = new HashMap<Integer, Object>();
        for (Object v : this.list) {
            int h = 0;
            if (v instanceof String) {
                h = v.hashCode();
            } else if (v instanceof byte[]) {
                byte[] bv = (byte[])v;
                h = Arrays.hashCode(bv);
            } else {
                return false;
            }
            hash.put(h, v);
        }
        try {
            NamingEnumeration<?> attrValues = attr.getAll();
            while (attrValues.hasMoreElements()) {
                Object val2;
                Integer h;
                Object val = attrValues.next();
                if (val instanceof String) {
                    h = val.hashCode();
                    if (!hash.containsKey(h)) {
                        return false;
                    }
                    val2 = hash.remove(h);
                    if (val.equals(val2)) continue;
                    return false;
                }
                if (val instanceof byte[]) {
                    h = Arrays.hashCode((byte[])val);
                    if (!hash.containsKey(h)) {
                        return false;
                    }
                    val2 = hash.remove(h);
                    if (Arrays.equals((byte[])val, (byte[])val2)) continue;
                    return false;
                }
                return false;
            }
            return hash.size() == 0;
        }
        catch (NamingException ne) {
            log.warn("Failed to get an attribute from the specifid attribute: " + attr, (Throwable)ne);
            return false;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Attribute id : '").append(this.upId).append("', ");
        sb.append(" Values : [");
        switch (this.size) {
            case 0: {
                sb.append("]\n");
                break;
            }
            case 1: {
                if (this.value instanceof String) {
                    sb.append('\'').append(this.value).append('\'');
                } else {
                    sb.append(StringTools.dumpBytes((byte[])this.value));
                }
                sb.append("]\n");
                break;
            }
            default: {
                boolean isFirst = true;
                for (Object v : this.list) {
                    if (!isFirst) {
                        sb.append(", ");
                    } else {
                        isFirst = false;
                    }
                    if (v instanceof String) {
                        sb.append('\'').append(v).append('\'');
                        continue;
                    }
                    sb.append(StringTools.dumpBytes((byte[])v));
                }
                sb.append("]\n");
            }
        }
        return sb.toString();
    }
}

