/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.store;

import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.spi.InitialContextFactory;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.kerberos.shared.store.PrincipalStore;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.directory.server.kerberos.shared.store.operations.AddPrincipal;
import org.apache.directory.server.kerberos.shared.store.operations.ChangePassword;
import org.apache.directory.server.kerberos.shared.store.operations.DeletePrincipal;
import org.apache.directory.server.kerberos.shared.store.operations.GetAllPrincipals;
import org.apache.directory.server.kerberos.shared.store.operations.GetPrincipal;
import org.apache.directory.server.protocol.shared.ServiceConfiguration;
import org.apache.directory.server.protocol.shared.ServiceConfigurationException;
import org.apache.directory.server.protocol.shared.store.ContextOperation;

class SingleBaseSearch
implements PrincipalStore {
    private DirContext ctx;
    private Hashtable<String, Object> env = new Hashtable();
    private InitialContextFactory factory;

    SingleBaseSearch(ServiceConfiguration config, InitialContextFactory factory) {
        this.env.put("java.naming.factory.initial", config.getInitialContextFactory());
        this.env.put("java.naming.provider.url", config.getSearchBaseDn());
        this.env.put("java.naming.security.authentication", config.getSecurityAuthentication());
        this.env.put("java.naming.security.credentials", config.getSecurityCredentials());
        this.env.put("java.naming.security.principal", config.getSecurityPrincipal());
        this.factory = factory;
    }

    public String addPrincipal(PrincipalStoreEntry entry) throws Exception {
        return (String)this.execute(new AddPrincipal(entry));
    }

    public String deletePrincipal(KerberosPrincipal principal) throws Exception {
        return (String)this.execute(new DeletePrincipal(principal));
    }

    public PrincipalStoreEntry[] getAllPrincipals(String realm) throws Exception {
        return (PrincipalStoreEntry[])this.execute(new GetAllPrincipals());
    }

    public PrincipalStoreEntry getPrincipal(KerberosPrincipal principal) throws Exception {
        return (PrincipalStoreEntry)this.execute(new GetPrincipal(principal));
    }

    public String changePassword(KerberosPrincipal principal, String newPassword) throws Exception {
        return (String)this.execute(new ChangePassword(principal, newPassword));
    }

    private Object execute(ContextOperation operation) throws Exception {
        if (this.ctx == null) {
            try {
                this.ctx = (DirContext)this.factory.getInitialContext(this.env);
            }
            catch (NamingException ne) {
                String message = "Failed to get initial context " + (String)this.env.get("java.naming.provider.url");
                throw new ServiceConfigurationException(message, (Throwable)ne);
            }
        }
        return operation.execute(this.ctx, null);
    }
}

