/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.directory.server.kerberos.shared.io.encoder.EncryptedDataEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.TicketEncoder;
import org.apache.directory.server.kerberos.shared.messages.ApplicationRequest;
import org.apache.directory.shared.asn1.der.ASN1OutputStream;
import org.apache.directory.shared.asn1.der.DERApplicationSpecific;
import org.apache.directory.shared.asn1.der.DERBitString;
import org.apache.directory.shared.asn1.der.DEREncodable;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class ApplicationRequestEncoder {
    public static final int APPLICATION_CODE = 14;

    public byte[] encode(ApplicationRequest request) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ASN1OutputStream aos = new ASN1OutputStream((OutputStream)baos);
        DERSequence requestSequence = this.encodeReplySequence(request);
        aos.writeObject((Object)DERApplicationSpecific.valueOf((int)14, (DEREncodable)requestSequence));
        aos.close();
        return baos.toByteArray();
    }

    private DERSequence encodeReplySequence(ApplicationRequest message) {
        DERSequence sequence = new DERSequence();
        sequence.add((DEREncodable)new DERTaggedObject(0, (DEREncodable)DERInteger.valueOf((int)message.getProtocolVersionNumber())));
        sequence.add((DEREncodable)new DERTaggedObject(1, (DEREncodable)DERInteger.valueOf((int)message.getMessageType().getOrdinal())));
        sequence.add((DEREncodable)new DERTaggedObject(2, (DEREncodable)new DERBitString(message.getApOptions().getBytes())));
        sequence.add((DEREncodable)new DERTaggedObject(3, (DEREncodable)TicketEncoder.encode(message.getTicket())));
        sequence.add((DEREncodable)new DERTaggedObject(4, (DEREncodable)EncryptedDataEncoder.encodeSequence(message.getEncPart())));
        return sequence;
    }
}

