/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */

package org.apache.directory.server.kerberos.shared.store.operations;


import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.spi.DirStateFactory;
import javax.naming.spi.DirStateFactory.Result;

import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.directory.server.protocol.shared.store.ContextOperation;
import org.apache.directory.shared.ldap.name.LdapDN;


/**
 * Command for adding a principal to a JNDI context.
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 * @version $Rev: 540371 $, $Date: 2007-05-21 20:00:43 -0400 (Mon, 21 May 2007) $
 */
public class AddPrincipal implements ContextOperation
{
    private static final long serialVersionUID = -1032737167622217786L;

    /** The Kerberos principal who is to be added. */
    protected PrincipalStoreEntry entry;


    /**
     * Creates the action to be used against the embedded ApacheDS DIT.
     * 
     * @param entry The {@link PrincipalStoreEntry} to add.
     */
    public AddPrincipal( PrincipalStoreEntry entry )
    {
        this.entry = entry;
    }


    public Object execute( DirContext ctx, Name searchBaseDn )
    {
        if ( entry == null )
        {
            return null;
        }

        try
        {
            DirStateFactory factory = new PrincipalStateFactory();
            Result result = factory.getStateToBind( entry, null, null, null, null );
            Attributes attrs = result.getAttributes();
            LdapDN name = new LdapDN( "uid=" + entry.getUserId() + ",ou=Users" );
            ctx.rebind( name, null, attrs );
            return name.toString();
        }
        catch ( NamingException ne )
        {
            ne.printStackTrace();
        }

        return null;
    }
}
