/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.codec.principalName.actions;

import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.kerberos.KerberosUtils;
import org.apache.directory.shared.kerberos.codec.principalName.PrincipalNameContainer;
import org.apache.directory.shared.kerberos.components.PrincipalName;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreNameString
extends GrammarAction<PrincipalNameContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreNameString.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreNameString() {
        super("Store the PrincipalName string");
    }

    public void action(PrincipalNameContainer principalNameContainer) throws DecoderException {
        TLV tlv = principalNameContainer.getCurrentTLV();
        if (tlv.getLength() == 0) {
            LOG.error(I18n.err((I18n)I18n.ERR_744_NULL_PDU_LENGTH, (Object[])new Object[0]));
            throw new DecoderException(I18n.err((I18n)I18n.ERR_744_NULL_PDU_LENGTH, (Object[])new Object[0]));
        }
        PrincipalName principalName = principalNameContainer.getPrincipalName();
        Value value = tlv.getValue();
        if (KerberosUtils.isKerberosString(value.getData())) {
            String nameString = Strings.utf8ToString((byte[])value.getData());
            principalName.addName(nameString);
            principalNameContainer.setGrammarEndAllowed(true);
            if (IS_DEBUG) {
                LOG.debug("PrincipalName String : {}", (Object)nameString);
            }
        } else {
            String valBytes = Strings.dumpBytes((byte[])value.getData());
            String valStr = Strings.utf8ToString((byte[])value.getData());
            String valAll = valBytes + "/" + valStr;
            LOG.error(I18n.err((I18n)I18n.ERR_745_NOT_A_KERBEROS_STRING, (Object[])new Object[]{valAll}));
            throw new DecoderException(I18n.err((I18n)I18n.ERR_745_NOT_A_KERBEROS_STRING, (Object[])new Object[]{valAll}));
        }
    }
}

