/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.codec.krbError.actions;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.kerberos.codec.krbError.KrbErrorContainer;
import org.apache.directory.shared.kerberos.messages.KrbError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KrbErrorInit
extends GrammarAction<KrbErrorContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(KrbErrorInit.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public KrbErrorInit() {
        super("Creates a KrbError instance");
    }

    public void action(KrbErrorContainer krbErrorContainer) throws DecoderException {
        TLV tlv = krbErrorContainer.getCurrentTLV();
        if (tlv.getLength() == 0) {
            LOG.error(I18n.err((I18n)I18n.ERR_04066, (Object[])new Object[0]));
            throw new DecoderException(I18n.err((I18n)I18n.ERR_04067, (Object[])new Object[0]));
        }
        KrbError krbError = new KrbError();
        krbErrorContainer.setKrbError(krbError);
        if (IS_DEBUG) {
            LOG.debug("KrbError created");
        }
    }
}

