/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.codec.encKrbCredPart.actions;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.kerberos.codec.encKrbCredPart.EncKrbCredPartContainer;
import org.apache.directory.shared.kerberos.components.EncKrbCredPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncKrbCredPartInit
extends GrammarAction<EncKrbCredPartContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(EncKrbCredPartInit.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public EncKrbCredPartInit() {
        super("Creates a EncKrbCredPart instance");
    }

    public void action(EncKrbCredPartContainer encKrbCredPartContainer) throws DecoderException {
        TLV tlv = encKrbCredPartContainer.getCurrentTLV();
        if (tlv.getLength() == 0) {
            LOG.error(I18n.err((I18n)I18n.ERR_04066, (Object[])new Object[0]));
            throw new DecoderException(I18n.err((I18n)I18n.ERR_04067, (Object[])new Object[0]));
        }
        EncKrbCredPart encKrbCredPart = new EncKrbCredPart();
        encKrbCredPartContainer.setEncKrbCredPart(encKrbCredPart);
        if (IS_DEBUG) {
            LOG.debug("EncKrbCredPart created");
        }
    }
}

