/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.test.utils;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.deltaspike.test.utils.CdiImplementation;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;

public class CdiContainerUnderTest {
    private CdiContainerUnderTest() {
    }

    public static boolean is(String ... containerRegExps) {
        String containerVersion = System.getProperty("cdicontainer.version");
        if (containerVersion == null) {
            return false;
        }
        for (String containerRe : containerRegExps) {
            if (!containerVersion.matches(containerRe)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCdiVersion(CdiImplementation cdiImplementation, String versionRange) throws InvalidVersionSpecificationException {
        Class implementationClass = CdiContainerUnderTest.tryToLoadClassForName(cdiImplementation.getImplementationClassName());
        if (implementationClass == null) {
            return false;
        }
        VersionRange range = VersionRange.createFromVersionSpec((String)(versionRange == null ? cdiImplementation.getVersionRange() : versionRange));
        String containerVersion = CdiContainerUnderTest.getJarSpecification(implementationClass);
        return containerVersion != null && range.containsVersion((ArtifactVersion)new DefaultArtifactVersion(containerVersion));
    }

    private static Class tryToLoadClassForName(String name) {
        try {
            return CdiContainerUnderTest.loadClassForName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Class loadClassForName(String name) throws ClassNotFoundException {
        try {
            return Class.forName(name, false, CdiContainerUnderTest.getClassLoader(null));
        }
        catch (ClassNotFoundException ignore) {
            return Class.forName(name, false, CdiContainerUnderTest.class.getClassLoader());
        }
    }

    private static ClassLoader getClassLoader(Object o) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new GetClassLoaderAction(o));
        }
        return CdiContainerUnderTest.getClassLoaderInternal(o);
    }

    private static ClassLoader getClassLoaderInternal(Object o) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null && o != null) {
            loader = o.getClass().getClassLoader();
        }
        if (loader == null) {
            loader = CdiContainerUnderTest.class.getClassLoader();
        }
        return loader;
    }

    private static String getJarVersion(Class targetClass) {
        String manifestFileLocation = CdiContainerUnderTest.getManifestFileLocationOfClass(targetClass);
        try {
            return new Manifest(new URL(manifestFileLocation).openStream()).getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String getJarSpecification(Class targetClass) {
        String manifestFileLocation = CdiContainerUnderTest.getManifestFileLocationOfClass(targetClass);
        try {
            return new Manifest(new URL(manifestFileLocation).openStream()).getMainAttributes().getValue(Attributes.Name.SPECIFICATION_VERSION);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String getManifestFileLocationOfClass(Class targetClass) {
        String manifestFileLocation;
        try {
            manifestFileLocation = CdiContainerUnderTest.getManifestLocation(targetClass);
        }
        catch (Exception e) {
            manifestFileLocation = CdiContainerUnderTest.getManifestLocation(targetClass.getSuperclass());
        }
        return manifestFileLocation;
    }

    private static String getManifestLocation(Class targetClass) {
        String classFilePath = targetClass.getCanonicalName().replace('.', '/') + ".class";
        String manifestFilePath = "/META-INF/MANIFEST.MF";
        String classLocation = targetClass.getResource(targetClass.getSimpleName() + ".class").toString();
        return classLocation.substring(0, classLocation.indexOf(classFilePath) - 1) + manifestFilePath;
    }

    public static boolean isNotTomEE() {
        return !System.getProperty("cdicontainer.version").startsWith("tomee");
    }

    private static class GetClassLoaderAction
    implements PrivilegedAction<ClassLoader> {
        private Object object;

        GetClassLoaderAction(Object object) {
            this.object = object;
        }

        @Override
        public ClassLoader run() {
            try {
                return CdiContainerUnderTest.getClassLoaderInternal(this.object);
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

