/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jpa.impl.transaction;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.apache.deltaspike.core.api.literal.AnyLiteral;
import org.apache.deltaspike.core.util.ProxyUtils;
import org.apache.deltaspike.jpa.api.transaction.Transactional;
import org.apache.deltaspike.jpa.impl.transaction.TransactionStrategyHelper;
import org.apache.deltaspike.jpa.impl.transaction.context.EntityManagerEntry;
import org.apache.deltaspike.jpa.impl.transaction.context.TransactionBeanStorage;
import org.apache.deltaspike.jpa.spi.entitymanager.ActiveEntityManagerHolder;
import org.apache.deltaspike.jpa.spi.transaction.TransactionStrategy;

@Dependent
public class ResourceLocalTransactionStrategy
implements TransactionStrategy {
    private static final long serialVersionUID = -1432802805095533499L;
    private static final Logger LOGGER = Logger.getLogger(ResourceLocalTransactionStrategy.class.getName());
    @Inject
    private BeanManager beanManager;
    @Inject
    private TransactionStrategyHelper transactionHelper;
    @Inject
    private ActiveEntityManagerHolder emHolder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object execute(InvocationContext invocationContext) throws Exception {
        Transactional transactionalAnnotation = this.transactionHelper.extractTransactionalAnnotation(invocationContext);
        Class targetClass = ProxyUtils.getUnproxiedClass(invocationContext.getTarget().getClass());
        Set<Class<Object>> emQualifiers = this.emHolder.isSet() ? new HashSet<Class>(Arrays.asList(Default.class)) : this.transactionHelper.resolveEntityManagerQualifiers(transactionalAnnotation, targetClass);
        TransactionBeanStorage transactionBeanStorage = TransactionBeanStorage.getInstance();
        boolean isOutermostInterceptor = transactionBeanStorage.isEmpty();
        boolean outermostTransactionAlreadyExisted = false;
        if (isOutermostInterceptor) {
            transactionBeanStorage.startTransactionScope();
        }
        int transactionLayer = transactionBeanStorage.incrementRefCounter();
        Exception firstException = null;
        try {
            for (Class<Object> emQualifier : emQualifiers) {
                EntityManager entityManager = this.resolveEntityManagerForQualifier(emQualifier);
                EntityManagerEntry entityManagerEntry = this.createEntityManagerEntry(entityManager, emQualifier);
                transactionBeanStorage.storeUsedEntityManager(entityManagerEntry);
                EntityTransaction transaction = this.getTransaction(entityManagerEntry);
                if (!transaction.isActive()) {
                    this.beforeBegin(invocationContext, entityManagerEntry, transaction);
                    transaction.begin();
                } else if (isOutermostInterceptor) {
                    outermostTransactionAlreadyExisted = true;
                }
                this.beforeProceed(invocationContext, entityManagerEntry, transaction);
            }
            Object i$ = invocationContext.proceed();
            return i$;
        }
        catch (Exception e) {
            firstException = e;
            if (isOutermostInterceptor) {
                Set<EntityManagerEntry> entityManagerEntryList = transactionBeanStorage.getUsedEntityManagerEntries();
                if (!outermostTransactionAlreadyExisted) {
                    this.rollbackAllTransactions(entityManagerEntryList);
                }
                transactionBeanStorage.cleanUsedEntityManagers();
            }
            e = this.prepareException(e);
            throw e;
        }
        finally {
            boolean commitFailed = false;
            if (isOutermostInterceptor) {
                if (!outermostTransactionAlreadyExisted && firstException == null) {
                    EntityTransaction transaction;
                    Set<EntityManagerEntry> entityManagerEntryList = transactionBeanStorage.getUsedEntityManagerEntries();
                    boolean rollbackOnly = this.isRollbackOnly(transactionalAnnotation);
                    if (!rollbackOnly) {
                        for (EntityManagerEntry currentEntityManagerEntry : entityManagerEntryList) {
                            transaction = this.getTransaction(currentEntityManagerEntry);
                            if (transaction == null || !transaction.isActive()) continue;
                            try {
                                if (commitFailed) continue;
                                currentEntityManagerEntry.getEntityManager().flush();
                                if (rollbackOnly || !transaction.getRollbackOnly()) continue;
                                rollbackOnly = true;
                            }
                            catch (Exception e) {
                                firstException = e;
                                commitFailed = true;
                                break;
                            }
                        }
                    }
                    if (rollbackOnly) {
                        commitFailed = true;
                    }
                    for (EntityManagerEntry currentEntityManagerEntry : entityManagerEntryList) {
                        transaction = this.getTransaction(currentEntityManagerEntry);
                        if (transaction == null || !transaction.isActive()) continue;
                        try {
                            if (commitFailed || transaction.getRollbackOnly()) {
                                this.beforeRollback(invocationContext, currentEntityManagerEntry, transaction);
                                transaction.rollback();
                                continue;
                            }
                            this.beforeCommit(invocationContext, currentEntityManagerEntry, transaction);
                            transaction.commit();
                        }
                        catch (Exception e) {
                            firstException = e;
                            commitFailed = true;
                        }
                        finally {
                            this.afterProceed(invocationContext, currentEntityManagerEntry, firstException);
                        }
                    }
                }
                transactionBeanStorage.endTransactionScope();
                this.onCloseTransactionScope();
            }
            transactionBeanStorage.decrementRefCounter();
            if (commitFailed && firstException != null) {
                this.throwException(firstException);
            }
        }
    }

    protected void beforeBegin(InvocationContext invocationContext, EntityManagerEntry entityManagerEntry, EntityTransaction transaction) {
    }

    protected void beforeProceed(InvocationContext invocationContext, EntityManagerEntry entityManagerEntry, EntityTransaction transaction) {
    }

    protected void beforeCommit(InvocationContext invocationContext, EntityManagerEntry entityManagerEntry, EntityTransaction transaction) {
    }

    protected void beforeRollback(InvocationContext invocationContext, EntityManagerEntry entityManagerEntry, EntityTransaction transaction) {
    }

    protected void afterProceed(InvocationContext invocationContext, EntityManagerEntry entityManagerEntry, Exception exception) {
    }

    protected void throwException(Exception exception) throws Exception {
        throw exception;
    }

    protected boolean isRollbackOnly(Transactional transactionalAnnotation) {
        return transactionalAnnotation != null && transactionalAnnotation.readOnly();
    }

    private void rollbackAllTransactions(Set<EntityManagerEntry> entityManagerEntryList) {
        for (EntityManagerEntry currentEntityManagerEntry : entityManagerEntryList) {
            EntityTransaction transaction = this.getTransaction(currentEntityManagerEntry);
            if (transaction == null || !transaction.isActive()) continue;
            try {
                transaction.rollback();
            }
            catch (Exception eRollback) {
                if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                LOGGER.log(Level.SEVERE, "Got additional Exception while subsequently rolling back other SQL transactions", eRollback);
            }
        }
    }

    protected EntityManagerEntry createEntityManagerEntry(EntityManager entityManager, Class<? extends Annotation> qualifier) {
        return new EntityManagerEntry(entityManager, qualifier);
    }

    protected EntityTransaction getTransaction(EntityManagerEntry entityManagerEntry) {
        return entityManagerEntry.getEntityManager().getTransaction();
    }

    private EntityManager resolveEntityManagerForQualifier(Class<? extends Annotation> emQualifier) {
        if (this.emHolder.isSet()) {
            return this.emHolder.get();
        }
        Bean<EntityManager> entityManagerBean = this.resolveEntityManagerBean(emQualifier);
        if (entityManagerBean == null) {
            throw new IllegalStateException("Cannot find an EntityManager qualified with [" + emQualifier.getName() + "]. Did you add a corresponding producer?");
        }
        return (EntityManager)this.beanManager.getReference(entityManagerBean, EntityManager.class, this.beanManager.createCreationalContext(entityManagerBean));
    }

    protected Exception prepareException(Exception e) {
        return e;
    }

    protected void onCloseTransactionScope() {
        TransactionBeanStorage.close();
    }

    protected Bean<EntityManager> resolveEntityManagerBean(Class<? extends Annotation> qualifierClass) {
        HashSet entityManagerBeans = this.beanManager.getBeans(EntityManager.class, new Annotation[]{new AnyLiteral()});
        if (entityManagerBeans == null) {
            entityManagerBeans = new HashSet();
        }
        for (Bean currentEntityManagerBean : entityManagerBeans) {
            Set foundQualifierAnnotations = currentEntityManagerBean.getQualifiers();
            for (Annotation currentQualifierAnnotation : foundQualifierAnnotations) {
                if (!currentQualifierAnnotation.annotationType().equals(qualifierClass)) continue;
                return currentEntityManagerBean;
            }
        }
        return null;
    }
}

