/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jpa.impl.entitymanager;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import org.apache.deltaspike.core.api.config.ConfigResolver;
import org.apache.deltaspike.core.api.config.PropertyLoader;
import org.apache.deltaspike.jpa.spi.entitymanager.PersistenceConfigurationProvider;

@ApplicationScoped
public class PersistenceConfigurationProviderImpl
implements PersistenceConfigurationProvider {
    private static final String CONFIG_PREFIX = "deltaspike.persistence.config.";

    public Properties getEntityManagerFactoryConfiguration(String persistenceUnitName) {
        Properties unitProperties = PropertyLoader.getProperties((String)("persistence-" + persistenceUnitName));
        if (unitProperties == null) {
            unitProperties = new Properties();
        }
        for (Map.Entry<Object, Object> entry : unitProperties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            entry.setValue(ConfigResolver.filterConfigValue((String)key, (String)value));
        }
        unitProperties = this.addConfigProperties(unitProperties, persistenceUnitName);
        return unitProperties;
    }

    protected Properties addConfigProperties(Properties unitProperties, String persistenceUnitName) {
        Properties mergedConfig = new Properties();
        mergedConfig.putAll((Map<?, ?>)unitProperties);
        Set allConfigKeys = ConfigResolver.getAllProperties().keySet();
        String unitPrefix = CONFIG_PREFIX + persistenceUnitName + ".";
        for (String configKey : allConfigKeys) {
            if (!configKey.startsWith(unitPrefix)) continue;
            mergedConfig.put(configKey.substring(unitPrefix.length()), ConfigResolver.getProjectStageAwarePropertyValue((String)configKey));
        }
        return mergedConfig;
    }
}

