/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.io;

import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.LongBuffer;
import java.util.regex.Matcher;
import org.apache.daffodil.exceptions.Assert$;
import org.apache.daffodil.io.DataInputStream;
import org.apache.daffodil.io.DataInputStreamImplMixin;
import org.apache.daffodil.io.DataStreamCommonImplMixin;
import org.apache.daffodil.io.FormatInfo;
import org.apache.daffodil.io.InputSource;
import org.apache.daffodil.io.InputSourceDataInputStream$;
import org.apache.daffodil.io.InputSourceDataInputStreamCharIterator;
import org.apache.daffodil.io.LocalBufferMixin;
import org.apache.daffodil.io.MarkPool;
import org.apache.daffodil.io.MarkState;
import org.apache.daffodil.processors.charset.BitsCharsetDecoder;
import org.apache.daffodil.schema.annotation.props.gen.BitOrder;
import org.apache.daffodil.schema.annotation.props.gen.ByteOrder;
import org.apache.daffodil.util.Bits$;
import org.apache.daffodil.util.LocalStack;
import org.apache.daffodil.util.MStackOf;
import org.apache.daffodil.util.Maybe;
import org.apache.daffodil.util.Maybe$;
import org.apache.daffodil.util.MaybeULong$;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\rx!\u0002\u001d:\u0011\u0003\u0011e!\u0002#:\u0011\u0003)\u0005\"\u0002'\u0002\t\u0003i\u0005\"\u0002(\u0002\t\u0003y\u0005B\u0002(\u0002\t\u0003\u0011i\r\u0003\u0004O\u0003\u0011\u0005!1\u001b\u0004\u0005\tf\u0012\u0011\u000b\u0003\u0005V\r\t\u0015\r\u0011\"\u0001W\u0011!QfA!A!\u0002\u00139\u0006\"\u0002'\u0007\t\u0013Y\u0006\"B/\u0007\t\u0003r\u0006bB4\u0007\u0005\u0004%)\u0005\u001b\u0005\u0007Y\u001a\u0001\u000bQB5\t\u000f54!\u0019!C\u0001]\"1QO\u0002Q\u0001\n=DqA\u001e\u0004C\u0002\u0013\u0005q\u000f\u0003\u0004|\r\u0001\u0006I\u0001\u001f\u0005\u0006y\u001a!)% \u0005\b\u0003\u00171AQIA\u0007\u0011\u001d\t9B\u0002C\u0001\u00033Aq!!\t\u0007\t\u000b\t\u0019\u0003C\u0004\u00026\u0019!\t!a\u000e\t\u000f\u0005\rc\u0001\"\u0011\u0002F!9\u00111\n\u0004\u0005\u0002\u00055\u0003bBA*\r\u0011\u0005\u0011Q\u000b\u0005\b\u0003'2A\u0011AA<\u0011\u001d\t\tI\u0002C\u0005\u0003\u0007Cq!a#\u0007\t\u0003\ti\tC\u0004\u0002\u0018\u001a!\t!!'\t\u000f\u0005\rf\u0001\"\u0001\u0002&\"I\u0011Q\u0016\u0004C\u0002\u0013%\u0011q\u0016\u0005\t\u0003c3\u0001\u0015!\u0003\u0002X!9\u00111\u0017\u0004\u0005\u0002\u0005U\u0006bBAf\r\u0011%\u0011Q\u001a\u0005\b\u0003/4A\u0011AAm\u0011\u001d\tYO\u0002C\u0001\u0003[Dq!a=\u0007\t\u000b\t)\u0010C\u0004\u0002|\u001a!)!a\t\t\u000f\u0005uh\u0001\"\u0001\u0002\u0000\"9!Q\u0001\u0004\u0005\u0002\t\u001d\u0001b\u0002B\u0018\r\u0011%!\u0011\u0007\u0005\b\u0005k1A\u0011\u0001B\u001c\u0011\u001d\u0011YD\u0002C\u0001\u0005{AqA!\u0011\u0007\t\u0003\u0012\u0019\u0005C\u0004\u0003L\u0019!\tE!\u0014\t\u000f\tMc\u0001\"\u0001\u0003V!9!q\u000b\u0004\u0005\u0006\te\u0003B\u0003B4\r!\u0015\r\u0011\"\u0001\u0003j!9!q\u000f\u0004\u0005\u0002\te\u0004b\u0002B@\r\u0011\u0005!\u0011\u0011\u0005\n\u0005/3!\u0019!C\u0005\u00053C\u0001B!)\u0007A\u0003%!1\u0014\u0005\b\u0005G3A\u0011\u0001BS\u0011\u001d\u0011iK\u0002C!\u0005_CqA!.\u0007\t\u0003\u00119\fC\u0004\u0003D\u001a!\tA!2\u00025%s\u0007/\u001e;T_V\u00148-\u001a#bi\u0006Le\u000e];u'R\u0014X-Y7\u000b\u0005iZ\u0014AA5p\u0015\taT(\u0001\u0005eC\u001a4w\u000eZ5m\u0015\tqt(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0001\u0006\u0019qN]4\u0004\u0001A\u00111)A\u0007\u0002s\tQ\u0012J\u001c9viN{WO]2f\t\u0006$\u0018-\u00138qkR\u001cFO]3b[N\u0011\u0011A\u0012\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0002\u0013\u0006)1oY1mC&\u00111\n\u0013\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\u0011\u0015!B1qa2LHc\u0001)\u0003JB\u00111IB\n\u0004\r\u0019\u0013\u0006CA\"T\u0013\t!\u0016H\u0001\rECR\f\u0017J\u001c9viN#(/Z1n\u00136\u0004H.T5yS:\f1\"\u001b8qkR\u001cv.\u001e:dKV\tq\u000b\u0005\u0002D1&\u0011\u0011,\u000f\u0002\f\u0013:\u0004X\u000f^*pkJ\u001cW-\u0001\u0007j]B,HoU8ve\u000e,\u0007\u0005\u0006\u0002Q9\")Q+\u0003a\u0001/\u0006AAo\\*ue&tw\rF\u0001`!\t\u0001W-D\u0001b\u0015\t\u00117-\u0001\u0003mC:<'\"\u00013\u0002\t)\fg/Y\u0005\u0003M\u0006\u0014aa\u0015;sS:<\u0017aA2tiV\t\u0011\u000e\u0005\u0002DU&\u00111.\u000f\u0002\n\u001b\u0006\u00148n\u0015;bi\u0016\fAaY:uA\u0005IQ.\u0019:l'R\f7m[\u000b\u0002_B\u0019\u0001o]5\u000e\u0003ET!A]\u001e\u0002\tU$\u0018\u000e\\\u0005\u0003iF\u0014\u0001\"T*uC\u000e\\wJZ\u0001\u000b[\u0006\u00148n\u0015;bG.\u0004\u0013\u0001C7be.\u0004vn\u001c7\u0016\u0003a\u0004\"aQ=\n\u0005iL$\u0001C'be.\u0004vn\u001c7\u0002\u00135\f'o\u001b)p_2\u0004\u0013\u0001\u00032jiB{7\u000f\r2\u0016\u0003y\u0004\"aR@\n\u0007\u0005\u0005\u0001J\u0001\u0003M_:<\u0007fA\t\u0002\u0006A\u0019q)a\u0002\n\u0007\u0005%\u0001J\u0001\u0004j]2Lg.Z\u0001\u000bE&$H*[7jiB\u0012WCAA\b!\r\u0001\u0018\u0011C\u0005\u0004\u0003'\t(AC'bs\n,W\u000bT8oO\"\u001a!#!\u0002\u0002'!\f7OU3bG\",G-\u00128e\u001f\u001a$\u0015\r^1\u0016\u0005\u0005m\u0001cA$\u0002\u001e%\u0019\u0011q\u0004%\u0003\u000f\t{w\u000e\\3b]\u00069\u0011n]!u\u000b:$GCAA\u000eQ\u001d!\u0012qEA\u0017\u0003c\u00012aRA\u0015\u0013\r\tY\u0003\u0013\u0002\u000bI\u0016\u0004(/Z2bi\u0016$\u0017EAA\u0018\u0003E+6/\u001a\u0011cSR\u0004vn\u001d\u0019cA=\u0014\bEY5u!>\u001c\u0018G\u0019\u0011u_\u0002\u001aw.\u001c9be\u0016\u0004s/\u001b;iA\u0015D\b/Z2uK\u0012\u0004\u0003o\\:ji&|g\u000e\t\u0015q_N\u001c\u0018N\u00197zA\tLG\u000fT5nSR\u0004$-\u000b\u0018\"\u0005\u0005M\u0012!B\u001a/c9\u0002\u0014aC:fi\nKG\u000fU8ta\t$B!!\u000f\u0002@A\u0019q)a\u000f\n\u0007\u0005u\u0002J\u0001\u0003V]&$\bBBA!+\u0001\u0007a0A\u0006oK^\u0014\u0015\u000e\u001e)pgB\u0012\u0017!D:fi\nKG\u000fT5nSR\u0004$\r\u0006\u0003\u0002\u001c\u0005\u001d\u0003bBA%-\u0001\u0007\u0011qB\u0001\u000e]\u0016<()\u001b;MS6LG\u000f\r2\u0002\u001fI,7/\u001a;CSRd\u0015.\\5ua\t$B!!\u000f\u0002P!9\u0011\u0011K\fA\u0002\u0005=\u0011aD:bm\u0016$')\u001b;MS6LG\u000f\r2\u0002\u0019\u001d,GOQ=uK\u0006\u0013(/Y=\u0015\r\u0005]\u00131MA7!\u00159\u0015\u0011LA/\u0013\r\tY\u0006\u0013\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004\u000f\u0006}\u0013bAA1\u0011\n!!)\u001f;f\u0011\u001d\t)\u0007\u0007a\u0001\u0003O\naBY5u\u0019\u0016tw\r\u001e5Ge>l\u0017\u0007E\u0002H\u0003SJ1!a\u001bI\u0005\rIe\u000e\u001e\u0005\b\u0003_B\u0002\u0019AA9\u0003\u00151\u0017N\u001c4p!\r\u0019\u00151O\u0005\u0004\u0003kJ$A\u0003$pe6\fG/\u00138g_RA\u0011\u0011HA=\u0003w\ni\bC\u0004\u0002fe\u0001\r!a\u001a\t\u000f\u0005=\u0014\u00041\u0001\u0002r!9\u0011qP\rA\u0002\u0005]\u0013!B1se\u0006L\u0018!\u00044jY2\u0014\u0015\u0010^3BeJ\f\u0017\u0010\u0006\u0005\u0002:\u0005\u0015\u0015qQAE\u0011\u001d\tyH\u0007a\u0001\u0003/Bq!!\u001a\u001b\u0001\u0004\t9\u0007C\u0004\u0002pi\u0001\r!!\u001d\u0002\u001f\u001d,GOQ5oCJLHi\\;cY\u0016$B!a$\u0002\u0016B\u0019q)!%\n\u0007\u0005M\u0005J\u0001\u0004E_V\u0014G.\u001a\u0005\b\u0003_Z\u0002\u0019AA9\u000399W\r\u001e\"j]\u0006\u0014\u0018P\u00127pCR$B!a'\u0002\"B\u0019q)!(\n\u0007\u0005}\u0005JA\u0003GY>\fG\u000fC\u0004\u0002pq\u0001\r!!\u001d\u0002\u001b\u001d,GoU5h]\u0016$Gj\u001c8h)\u0015q\u0018qUAV\u0011\u001d\tI+\ba\u0001\u0003O\n!CY5u\u0019\u0016tw\r\u001e5Ge>l\u0017\u0007V87i!9\u0011qN\u000fA\u0002\u0005E\u0014!\u00037p]\u001e\f%O]1z+\t\t9&\u0001\u0006m_:<\u0017I\u001d:bs\u0002\nqbZ3u+:\u001c\u0018n\u001a8fI2{gn\u001a\u000b\u0007\u0003o\u000b9-!3\u0011\t\u0005e\u00161Y\u0007\u0003\u0003wSA!!0\u0002@\u0006AQO\\:jO:,GM\u0003\u0002\u0002B\u00069\u0001/Y:tKJ\f\u0017\u0002BAc\u0003w\u0013Q!\u0016'p]\u001eDq!!+!\u0001\u0004\t9\u0007C\u0004\u0002p\u0001\u0002\r!!\u001d\u0002C\u0005$'.^:u\u0005&<\u0017J\u001c;BeJ\f\u0017pV5uQ\u001a\u0013\u0018mZ7f]R\u0014\u0015\u0010^3\u0015\u0011\u0005e\u0012qZAi\u0003+Dq!a \"\u0001\u0004\t9\u0006C\u0004\u0002T\u0006\u0002\r!a\u001a\u0002\u001d\u0019\u0014\u0018mZ7f]RdUM\\4uQ\"9\u0011qN\u0011A\u0002\u0005E\u0014aD4fiNKwM\\3e\u0005&<\u0017J\u001c;\u0015\r\u0005m\u0017q]Au!\u0011\ti.a9\u000e\u0005\u0005}'bAAqG\u0006!Q.\u0019;i\u0013\u0011\t)/a8\u0003\u0015\tKw-\u00138uK\u001e,'\u000fC\u0004\u0002f\t\u0002\r!a\u001a\t\u000f\u0005=$\u00051\u0001\u0002r\u0005\tr-\u001a;V]NLwM\\3e\u0005&<\u0017J\u001c;\u0015\r\u0005m\u0017q^Ay\u0011\u001d\t)g\ta\u0001\u0003OBq!a\u001c$\u0001\u0004\t\t(\u0001\njg\u0012+g-\u001b8fI\u001a{'\u000fT3oORDG\u0003BA\u000e\u0003oDa!!?%\u0001\u0004q\u0018!\u00028CSR\u001c\u0018a\u00025bg\u0012\u000bG/Y\u0001\u0005g.L\u0007\u000f\u0006\u0004\u0002\u001c\t\u0005!1\u0001\u0005\u0007\u0003s4\u0003\u0019\u0001@\t\u000f\u0005=d\u00051\u0001\u0002r\u0005!Q.\u0019:l)\u0011\u0011IAa\u0006\u0011\t\t-!\u0011\u0003\b\u0004\u0007\n5\u0011b\u0001B\bs\u0005yA)\u0019;b\u0013:\u0004X\u000f^*ue\u0016\fW.\u0003\u0003\u0003\u0014\tU!\u0001B'be.T1Aa\u0004:\u0011\u001d\u0011Ib\na\u0001\u00057\t1B]3rk\u0016\u001cHo\u001c:J\tB!!Q\u0004B\u0016\u001d\u0011\u0011yBa\n\u0011\u0007\t\u0005\u0002*\u0004\u0002\u0003$)\u0019!QE!\u0002\rq\u0012xn\u001c;?\u0013\r\u0011I\u0003S\u0001\u0007!J,G-\u001a4\n\u0007\u0019\u0014iCC\u0002\u0003*!\u000b\u0001C]3mK\u0006\u001cX-\u00168uS2l\u0015M]6\u0015\u0007%\u0014\u0019\u0004C\u0004\u0003\u0006!\u0002\rA!\u0003\u0002\u000bI,7/\u001a;\u0015\t\u0005e\"\u0011\b\u0005\b\u0005\u000bI\u0003\u0019\u0001B\u0005\u0003\u001d!\u0017n]2be\u0012$B!!\u000f\u0003@!9!Q\u0001\u0016A\u0002\t%\u0011aB7be.\u0004vn]\u000b\u0003\u0005\u000b\u0002BAa\u0003\u0003H%!!\u0011\nB\u000b\u0005\u001di\u0015M]6Q_N\f\u0001B]3tKR\u0004vn\u001d\u000b\u0005\u0003s\u0011y\u0005C\u0004\u0003R1\u0002\rA!\u0012\u0002\u00035\f\u0001D^1mS\u0012\fG/\u001a$j]\u0006d7\u000b\u001e:fC6\u001cF/\u0019;f)\t\tI$A\u0007hKR\u001cv.\\3TiJLgn\u001a\u000b\u0007\u00057\u0012\tG!\u001a\u0011\u000bA\u0014iFa\u0007\n\u0007\t}\u0013OA\u0003NCf\u0014W\r\u0003\u0004\u0003d9\u0002\rA`\u0001\u0007]\u000eC\u0017M]:\t\u000f\u0005=d\u00061\u0001\u0002r\u0005q1o[5q\u0007\"\f'OQ;gM\u0016\u0014XC\u0001B6!\u0011\u0011iGa\u001d\u000e\u0005\t=$b\u0001B9G\u0006\u0019a.[8\n\t\tU$q\u000e\u0002\u000b\u0007\"\f'OQ;gM\u0016\u0014\u0018!C:lSB\u001c\u0005.\u0019:t)\u0019\tYBa\u001f\u0003~!1!1\r\u0019A\u0002yDq!a\u001c1\u0001\u0004\t\t(A\u0005m_>\\\u0017N\\4BiR1\u00111\u0004BB\u0005+CqA!\"2\u0001\u0004\u00119)A\u0004nCR\u001c\u0007.\u001a:\u0011\t\t%%\u0011S\u0007\u0003\u0005\u0017SAA!$\u0003\u0010\u0006)!/Z4fq*\u0011!oY\u0005\u0005\u0005'\u0013YIA\u0004NCR\u001c\u0007.\u001a:\t\u000f\u0005=\u0014\u00071\u0001\u0002r\u0005a1\r[1s\u0013R,'/\u0019;peV\u0011!1\u0014\t\u0004\u0007\nu\u0015b\u0001BPs\t1\u0013J\u001c9viN{WO]2f\t\u0006$\u0018-\u00138qkR\u001cFO]3b[\u000eC\u0017M]%uKJ\fGo\u001c:\u0002\u001b\rD\u0017M]%uKJ\fGo\u001c:!\u00039\t7/\u0013;fe\u0006$xN]\"iCJ,\"Aa*\u0011\t\t-!\u0011V\u0005\u0005\u0005W\u0013)B\u0001\u0007DQ\u0006\u0014\u0018\n^3sCR|'/\u0001\u0007tKR$UMY;hO&tw\r\u0006\u0003\u0002:\tE\u0006b\u0002BZk\u0001\u0007\u00111D\u0001\bg\u0016$H/\u001b8h\u0003!\u0001\u0018m\u001d;ECR\fG\u0003\u0002B]\u0005\u007f\u0003BA!\u001c\u0003<&!!Q\u0018B8\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\b\u0005\u00034\u0004\u0019AA4\u0003=q')\u001f;fgJ+\u0017/^3ti\u0016$\u0017A\u00034viV\u0014X\rR1uCR!!\u0011\u0018Bd\u0011\u001d\u0011\tm\u000ea\u0001\u0003OBqAa3\u0004\u0001\u0004\t9&A\u0005csR,\u0017I\u001d:bsR\u0019\u0001Ka4\t\u000f\tEG\u00011\u0001\u0003:\u0006Q!-\u001f;f\u0005V4g-\u001a:\u0015\u0007A\u0013)\u000eC\u0004\u0003X\u0016\u0001\rA!7\u0002\u0005%t\u0007\u0003\u0002Bn\u0005?l!A!8\u000b\u0005i\u001a\u0017\u0002\u0002Bq\u0005;\u00141\"\u00138qkR\u001cFO]3b[\u0002")
public final class InputSourceDataInputStream
implements DataInputStreamImplMixin {
    private CharBuffer skipCharBuffer;
    private final InputSource inputSource;
    private final MarkState cst;
    private final MStackOf<MarkState> markStack;
    private final MarkPool markPool;
    private final byte[] longArray;
    private final InputSourceDataInputStreamCharIterator charIterator;
    private LocalStack<LocalBufferMixin.LocalCharBuffer> withLocalCharBuffer;
    private LocalStack<LocalBufferMixin.LocalByteBuffer> withLocalByteBuffer;
    private volatile byte bitmap$0;

    public static InputSourceDataInputStream apply(InputStream inputStream) {
        return InputSourceDataInputStream$.MODULE$.apply(inputStream);
    }

    public static InputSourceDataInputStream apply(ByteBuffer byteBuffer) {
        return InputSourceDataInputStream$.MODULE$.apply(byteBuffer);
    }

    public static InputSourceDataInputStream apply(byte[] byArray) {
        return InputSourceDataInputStream$.MODULE$.apply(byArray);
    }

    @Override
    public final boolean isAligned(int bitAlignment1b) {
        return DataInputStreamImplMixin.isAligned$(this, bitAlignment1b);
    }

    @Override
    public final boolean align(int bitAlignment1b, FormatInfo finfo) {
        return DataInputStreamImplMixin.align$(this, bitAlignment1b, finfo);
    }

    @Override
    public final long remainingBits() {
        return DataInputStreamImplMixin.remainingBits$(this);
    }

    @Override
    public final boolean areDebugging() {
        return DataStreamCommonImplMixin.areDebugging$(this);
    }

    @Override
    public final long bitPos1b() {
        return DataInputStream.bitPos1b$(this);
    }

    @Override
    public final long bytePos0b() {
        return DataInputStream.bytePos0b$(this);
    }

    @Override
    public final long bytePos1b() {
        return DataInputStream.bytePos1b$(this);
    }

    @Override
    public final long bitLimit1b() {
        return DataInputStream.bitLimit1b$(this);
    }

    @Override
    public final boolean setBitLimit1b(long bitLimit1b) {
        return DataInputStream.setBitLimit1b$(this, bitLimit1b);
    }

    private LocalStack<LocalBufferMixin.LocalCharBuffer> withLocalCharBuffer$lzycompute() {
        InputSourceDataInputStream inputSourceDataInputStream = this;
        synchronized (inputSourceDataInputStream) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.withLocalCharBuffer = LocalBufferMixin.withLocalCharBuffer$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.withLocalCharBuffer;
    }

    @Override
    public final LocalStack<LocalBufferMixin.LocalCharBuffer> withLocalCharBuffer() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.withLocalCharBuffer$lzycompute() : this.withLocalCharBuffer;
    }

    private LocalStack<LocalBufferMixin.LocalByteBuffer> withLocalByteBuffer$lzycompute() {
        InputSourceDataInputStream inputSourceDataInputStream = this;
        synchronized (inputSourceDataInputStream) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.withLocalByteBuffer = LocalBufferMixin.withLocalByteBuffer$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.withLocalByteBuffer;
    }

    @Override
    public final LocalStack<LocalBufferMixin.LocalByteBuffer> withLocalByteBuffer() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.withLocalByteBuffer$lzycompute() : this.withLocalByteBuffer;
    }

    public InputSource inputSource() {
        return this.inputSource;
    }

    public String toString() {
        long bp0b = this.bitPos0b();
        long bl0b = this.bitLimit0b();
        String bl0b1 = MaybeULong$.MODULE$.isDefined$extension(bl0b) ? Long.toString(MaybeULong$.MODULE$.get$extension(bl0b)) : "none";
        String str = new StringBuilder(35).append("DataInputStream(bitPos=").append(bp0b).append(", bitLimit=").append(bl0b1).append(")").toString();
        return str;
    }

    @Override
    public final MarkState cst() {
        return this.cst;
    }

    public MStackOf<MarkState> markStack() {
        return this.markStack;
    }

    public MarkPool markPool() {
        return this.markPool;
    }

    @Override
    public final long bitPos0b() {
        return this.cst().bitPos0b();
    }

    @Override
    public final long bitLimit0b() {
        return this.cst().bitLimit0b();
    }

    public boolean hasReachedEndOfData() {
        return this.inputSource().hasReachedEndOfData();
    }

    public final boolean isAtEnd() {
        return !this.hasData() && this.hasReachedEndOfData();
    }

    public void setBitPos0b(long newBitPos0b) {
        if (newBitPos0b < 0L) {
            throw Assert$.MODULE$.abort("Invariant broken: newBitPos0b.>=(0)");
        }
        if (!MaybeULong$.MODULE$.isEmpty$extension(this.bitLimit0b()) && newBitPos0b > MaybeULong$.MODULE$.get$extension(this.bitLimit0b())) {
            throw Assert$.MODULE$.abort("Invariant broken: InputSourceDataInputStream.this.bitLimit0b.isEmpty.||(newBitPos0b.<=(InputSourceDataInputStream.this.bitLimit0b.get))");
        }
        this.inputSource().position(newBitPos0b >> 3);
        this.cst().bitPos0b_$eq(newBitPos0b);
    }

    @Override
    public boolean setBitLimit0b(long newBitLimit0b) {
        boolean bl;
        if (!MaybeULong$.MODULE$.isEmpty$extension(newBitLimit0b) && MaybeULong$.MODULE$.get$extension(newBitLimit0b) < 0L) {
            throw Assert$.MODULE$.abort("Invariant broken: newBitLimit0b.isEmpty.||(newBitLimit0b.get.>=(0))");
        }
        if (MaybeULong$.MODULE$.isEmpty$extension(this.bitLimit0b()) || MaybeULong$.MODULE$.isEmpty$extension(newBitLimit0b) || MaybeULong$.MODULE$.get$extension(newBitLimit0b) <= MaybeULong$.MODULE$.get$extension(this.bitLimit0b())) {
            this.cst().bitLimit0b_$eq(newBitLimit0b);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public void resetBitLimit0b(long savedBitLimit0b) {
        this.cst().bitLimit0b_$eq(savedBitLimit0b);
    }

    @Override
    public byte[] getByteArray(int bitLengthFrom1, FormatInfo finfo) {
        if (!this.isDefinedForLength(bitLengthFrom1)) {
            throw new DataInputStream.NotEnoughDataException(bitLengthFrom1);
        }
        int arraySize = (bitLengthFrom1 + 7) / 8;
        byte[] array = new byte[arraySize];
        this.fillByteArray(array, bitLengthFrom1, finfo);
        this.setBitPos0b(this.bitPos0b() + (long)bitLengthFrom1);
        return array;
    }

    @Override
    public void getByteArray(int bitLengthFrom1, FormatInfo finfo, byte[] array) {
        if (!this.isDefinedForLength(bitLengthFrom1)) {
            throw new DataInputStream.NotEnoughDataException(bitLengthFrom1);
        }
        int bytesNeeded = (bitLengthFrom1 + 7) / 8;
        if (new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(array)).size() < bytesNeeded) {
            throw Assert$.MODULE$.abort("Usage error: scala.Predef.byteArrayOps(array).size.>=(bytesNeeded)");
        }
        this.fillByteArray(array, bitLengthFrom1, finfo);
        this.setBitPos0b(this.bitPos0b() + (long)bitLengthFrom1);
    }

    private void fillByteArray(byte[] array, int bitLengthFrom1, FormatInfo finfo) {
        block4: {
            boolean isUnaligned = !this.isAligned(8);
            int fragmentBits = bitLengthFrom1 % 8;
            int bytesToFill = (bitLengthFrom1 + 7) / 8;
            this.inputSource().get(array, 0, bytesToFill);
            if (isUnaligned) {
                int index;
                BitOrder bitOrder = finfo.bitOrder();
                BitOrder.MostSignificantBitFirst$ mostSignificantBitFirst$ = BitOrder.MostSignificantBitFirst$.MODULE$;
                boolean isMSBF = !(bitOrder != null ? !bitOrder.equals(mostSignificantBitFirst$) : mostSignificantBitFirst$ != null);
                int bitOffset0b = (int)(this.bitPos0b() % 8L);
                int bytesToRead = (bitLengthFrom1 + bitOffset0b + 7) / 8;
                int arrayOverflow = bytesToRead > bytesToFill ? Bits$.MODULE$.asUnsignedByte((long)this.inputSource().get()) : 0;
                int curBitMask = isMSBF ? BoxesRunTime.unboxToInt((Object)Bits$.MODULE$.maskR().apply(8 - bitOffset0b)) : BoxesRunTime.unboxToInt((Object)Bits$.MODULE$.maskL().apply(8 - bitOffset0b));
                int nxtBitMask = ~curBitMask & 0xFF;
                int curShift = bitOffset0b;
                int nxtShift = 8 - bitOffset0b;
                int curByte = Bits$.MODULE$.asUnsignedByte(array[index]);
                int stopIndex = bytesToFill - 1;
                for (index = 0; index < stopIndex; ++index) {
                    int nxtByte = Bits$.MODULE$.asUnsignedByte(array[index + 1]);
                    array[index] = InputSourceDataInputStream.calcNewByte$1(curByte, nxtByte, curBitMask, nxtBitMask, isMSBF, curShift, nxtShift);
                    curByte = nxtByte;
                }
                array[index] = InputSourceDataInputStream.calcNewByte$1(curByte, arrayOverflow, curBitMask, nxtBitMask, isMSBF, curShift, nxtShift);
            }
            if (fragmentBits > 0) {
                BitOrder bitOrder = finfo.bitOrder();
                BitOrder.MostSignificantBitFirst$ mostSignificantBitFirst$ = BitOrder.MostSignificantBitFirst$.MODULE$;
                int mask = !(bitOrder != null ? !bitOrder.equals(mostSignificantBitFirst$) : mostSignificantBitFirst$ != null) ? BoxesRunTime.unboxToInt((Object)Bits$.MODULE$.maskL().apply(fragmentBits)) : BoxesRunTime.unboxToInt((Object)Bits$.MODULE$.maskR().apply(fragmentBits));
                int lastIndex = bytesToFill - 1;
                int lastByte = Bits$.MODULE$.asUnsignedByte(array[lastIndex]);
                array[lastIndex] = Bits$.MODULE$.asSignedByte((long)(lastByte & mask));
            }
            if (bitLengthFrom1 <= 8) break block4;
            ByteOrder byteOrder = finfo.byteOrder();
            ByteOrder.LittleEndian$ littleEndian$ = ByteOrder.LittleEndian$.MODULE$;
            if (!(byteOrder != null ? !byteOrder.equals(littleEndian$) : littleEndian$ != null)) {
                Bits$.MODULE$.reverseBytes(array, bytesToFill);
            }
        }
    }

    @Override
    public double getBinaryDouble(FormatInfo finfo) {
        long l = this.getSignedLong(64, finfo);
        double d = Double.longBitsToDouble(l);
        return d;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getBinaryFloat(FormatInfo finfo) {
        void var3_3;
        int i = (int)this.getSignedLong(32, finfo);
        float f = Float.intBitsToFloat(i);
        return (float)var3_3;
    }

    @Override
    public long getSignedLong(int bitLengthFrom1To64, FormatInfo finfo) {
        if (bitLengthFrom1To64 < 1) {
            throw Assert$.MODULE$.abort("Usage error: bitLengthFrom1To64.>=(1)");
        }
        if (bitLengthFrom1To64 > 64) {
            throw Assert$.MODULE$.abort("Usage error: bitLengthFrom1To64.<=(64)");
        }
        long res = this.getUnsignedLong(bitLengthFrom1To64, finfo);
        return Bits$.MODULE$.signExtend(res, bitLengthFrom1To64);
    }

    private byte[] longArray() {
        return this.longArray;
    }

    @Override
    public long getUnsignedLong(int bitLengthFrom1To64, FormatInfo finfo) {
        long l;
        if (bitLengthFrom1To64 < 1) {
            throw Assert$.MODULE$.abort("Usage error: bitLengthFrom1To64.>=(1)");
        }
        if (bitLengthFrom1To64 > 64) {
            throw Assert$.MODULE$.abort("Usage error: bitLengthFrom1To64.<=(64)");
        }
        if (!this.isDefinedForLength(bitLengthFrom1To64)) {
            throw new DataInputStream.NotEnoughDataException(bitLengthFrom1To64);
        }
        int numBytes = (bitLengthFrom1To64 + 7) / 8;
        this.fillByteArray(this.longArray(), bitLengthFrom1To64, finfo);
        int fragmentLength = bitLengthFrom1To64 % 8;
        if (fragmentLength == 0) {
            long l2;
            l = l2 = this.buildLongFromArray$1(numBytes);
        } else {
            ByteOrder byteOrder = finfo.byteOrder();
            ByteOrder.LittleEndian$ littleEndian$ = ByteOrder.LittleEndian$.MODULE$;
            if (!(byteOrder != null ? !byteOrder.equals(littleEndian$) : littleEndian$ != null)) {
                long l3;
                BitOrder bitOrder = finfo.bitOrder();
                BitOrder.MostSignificantBitFirst$ mostSignificantBitFirst$ = BitOrder.MostSignificantBitFirst$.MODULE$;
                if (!(bitOrder != null ? !bitOrder.equals(mostSignificantBitFirst$) : mostSignificantBitFirst$ != null)) {
                    int firstByte = Bits$.MODULE$.asUnsignedByte(this.longArray()[0]);
                    int shifted = firstByte >>> 8 - fragmentLength;
                    this.longArray()[0] = Bits$.MODULE$.asSignedByte((long)shifted);
                }
                l = l3 = this.buildLongFromArray$1(numBytes);
            } else {
                long l4;
                BitOrder bitOrder = finfo.bitOrder();
                BitOrder.LeastSignificantBitFirst$ leastSignificantBitFirst$ = BitOrder.LeastSignificantBitFirst$.MODULE$;
                if (!(bitOrder != null ? !bitOrder.equals(leastSignificantBitFirst$) : leastSignificantBitFirst$ != null)) {
                    int lastIndex = numBytes - 1;
                    byte lastByte = this.longArray()[lastIndex];
                    int shifted = lastByte << 8 - fragmentLength;
                    this.longArray()[lastIndex] = Bits$.MODULE$.asSignedByte((long)shifted);
                }
                long unShiftedLong = this.buildLongFromArray$1(numBytes);
                l = l4 = unShiftedLong >>> 8 - fragmentLength;
            }
        }
        long res = l;
        this.setBitPos0b(this.bitPos0b() + (long)bitLengthFrom1To64);
        return res;
    }

    private void adjustBigIntArrayWithFragmentByte(byte[] array, int fragmentLength, FormatInfo finfo) {
        ByteOrder byteOrder = finfo.byteOrder();
        ByteOrder.LittleEndian$ littleEndian$ = ByteOrder.LittleEndian$.MODULE$;
        if (!(byteOrder != null ? !byteOrder.equals(littleEndian$) : littleEndian$ != null)) {
            BitOrder bitOrder = finfo.bitOrder();
            BitOrder.MostSignificantBitFirst$ mostSignificantBitFirst$ = BitOrder.MostSignificantBitFirst$.MODULE$;
            if (!(bitOrder != null ? !bitOrder.equals(mostSignificantBitFirst$) : mostSignificantBitFirst$ != null)) {
                int firstByte = Bits$.MODULE$.asUnsignedByte(array[0]);
                int shifted = firstByte >>> 8 - fragmentLength;
                array[0] = Bits$.MODULE$.asSignedByte((long)shifted);
            }
        } else {
            BitOrder bitOrder = finfo.bitOrder();
            BitOrder.LeastSignificantBitFirst$ leastSignificantBitFirst$ = BitOrder.LeastSignificantBitFirst$.MODULE$;
            if (!(bitOrder != null ? !bitOrder.equals(leastSignificantBitFirst$) : leastSignificantBitFirst$ != null)) {
                int lastIndex = array.length - 1;
                byte lastByte = array[lastIndex];
                int shifted = lastByte << 8 - fragmentLength;
                array[lastIndex] = Bits$.MODULE$.asSignedByte((long)shifted);
            }
            ByteBuffer bb = ByteBuffer.wrap(array);
            Bits$.MODULE$.shiftRight(bb, 8 - fragmentLength);
        }
    }

    @Override
    public BigInteger getSignedBigInt(int bitLengthFrom1, FormatInfo finfo) {
        BigInteger bigInteger;
        if (bitLengthFrom1 < 1) {
            throw Assert$.MODULE$.abort("Usage error: bitLengthFrom1.>=(1)");
        }
        if (bitLengthFrom1 <= 64) {
            bigInteger = BigInteger.valueOf(this.getSignedLong(bitLengthFrom1, finfo));
        } else {
            byte[] bytes = this.getByteArray(bitLengthFrom1, finfo);
            int fragmentLength = bitLengthFrom1 % 8;
            if (fragmentLength > 0) {
                this.adjustBigIntArrayWithFragmentByte(bytes, fragmentLength, finfo);
                int shift = 8 - fragmentLength;
                bytes[0] = (byte)((byte)(bytes[0] << shift) >> shift);
            }
            bigInteger = new BigInteger(bytes);
        }
        return bigInteger;
    }

    @Override
    public BigInteger getUnsignedBigInt(int bitLengthFrom1, FormatInfo finfo) {
        if (bitLengthFrom1 < 1) {
            throw Assert$.MODULE$.abort("Usage error: bitLengthFrom1.>=(1)");
        }
        byte[] bytes = this.getByteArray(bitLengthFrom1, finfo);
        int fragmentLength = bitLengthFrom1 % 8;
        if (fragmentLength > 0) {
            this.adjustBigIntArrayWithFragmentByte(bytes, fragmentLength, finfo);
        }
        return new BigInteger(1, bytes);
    }

    @Override
    public final boolean isDefinedForLength(long nBits) {
        boolean bl;
        long newBitPos0b = this.bitPos0b() + nBits;
        if (MaybeULong$.MODULE$.isDefined$extension(this.bitLimit0b()) && newBitPos0b > MaybeULong$.MODULE$.get$extension(this.bitLimit0b())) {
            bl = false;
        } else {
            long newEndingBytePos0b = Bits$.MODULE$.roundUpBitToBytePosition(newBitPos0b);
            long moreBytesNeeded = newEndingBytePos0b - this.inputSource().position();
            bl = this.inputSource().areBytesAvailable(moreBytesNeeded);
        }
        return bl;
    }

    @Override
    public final boolean hasData() {
        return this.isDefinedForLength(1L);
    }

    @Override
    public boolean skip(long nBits, FormatInfo finfo) {
        if (!this.isDefinedForLength(nBits)) {
            return false;
        }
        this.setBitPos0b(this.bitPos0b() + nBits);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DataInputStream.Mark mark(String requestorID) {
        void var2_2;
        MarkState m = (MarkState)this.markPool().getFromPool(requestorID);
        m.assignFrom(this.cst());
        this.markStack().push((Object)m);
        this.inputSource().lockPosition(m.bytePos0b());
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private MarkState releaseUntilMark(DataInputStream.Mark mark) {
        void var2_2;
        if (this.markStack().isEmpty()) {
            throw Assert$.MODULE$.abort("Usage error: InputSourceDataInputStream.this.markStack.isEmpty.unary_!");
        }
        if (mark == null) {
            throw Assert$.MODULE$.abort("Usage error: mark.!=(null)");
        }
        MarkState current = (MarkState)this.markStack().pop();
        while (!this.markStack().isEmpty() && current != mark) {
            this.inputSource().releasePosition(current.bytePos0b());
            this.markPool().returnToPool(current);
            current = (MarkState)this.markStack().pop();
        }
        if (current != mark) {
            throw Assert$.MODULE$.abort("Invariant broken: current.eq(mark)");
        }
        return var2_2;
    }

    @Override
    public void reset(DataInputStream.Mark mark) {
        MarkState current = this.releaseUntilMark(mark);
        if (current != mark) {
            throw Assert$.MODULE$.abort("Invariant broken: current.eq(mark)");
        }
        this.cst().assignFrom(current);
        this.setBitPos0b(this.cst().bitPos0b());
        this.inputSource().releasePosition(current.bytePos0b());
        this.markPool().returnToPool(current);
    }

    @Override
    public void discard(DataInputStream.Mark mark) {
        MarkState current = this.releaseUntilMark(mark);
        if (current != mark) {
            throw Assert$.MODULE$.abort("Invariant broken: current.eq(mark)");
        }
        this.inputSource().releasePosition(current.bytePos0b());
        this.markPool().returnToPool(current);
    }

    @Override
    public long markPos() {
        return this.bitPos0b();
    }

    @Override
    public void resetPos(long m) {
        this.setBitPos0b(m);
    }

    public void validateFinalStreamState() {
        this.markPool().finalCheck();
    }

    @Override
    public final Object getSomeString(long nChars, FormatInfo finfo) {
        long startingBitPos = this.bitPos0b();
        return ((Maybe)this.withLocalCharBuffer().apply((Function1 & Serializable & scala.Serializable)lcb -> new Maybe(InputSourceDataInputStream.$anonfun$getSomeString$1(this, nChars, finfo, startingBitPos, lcb)))).v();
    }

    private CharBuffer skipCharBuffer$lzycompute() {
        InputSourceDataInputStream inputSourceDataInputStream = this;
        synchronized (inputSourceDataInputStream) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.skipCharBuffer = CharBuffer.allocate(32);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.skipCharBuffer;
    }

    public CharBuffer skipCharBuffer() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.skipCharBuffer$lzycompute() : this.skipCharBuffer;
    }

    @Override
    public boolean skipChars(long nChars, FormatInfo finfo) {
        boolean bl;
        long startingBitPos = this.bitPos0b();
        boolean aligned = this.align(finfo.encodingMandatoryAlignmentInBits(), finfo);
        if (!aligned) {
            bl = false;
        } else {
            boolean skippedAllNChars;
            long remainingCharsToSkip;
            int numDecoded;
            boolean keepGoing = true;
            for (remainingCharsToSkip = nChars; keepGoing && remainingCharsToSkip > 0L; remainingCharsToSkip -= (long)numDecoded) {
                long charsToSkip = Math.min(remainingCharsToSkip, (long)this.skipCharBuffer().capacity());
                this.skipCharBuffer().position(0);
                this.skipCharBuffer().limit((int)charsToSkip);
                BitsCharsetDecoder qual$1 = finfo.decoder();
                InputSourceDataInputStream x$1 = this;
                FormatInfo x$2 = finfo;
                CharBuffer x$3 = this.skipCharBuffer();
                LongBuffer x$4 = qual$1.decode$default$4();
                numDecoded = qual$1.decode(x$1, x$2, x$3, x$4);
                if (numDecoded != 0) continue;
                keepGoing = false;
            }
            boolean bl2 = skippedAllNChars = remainingCharsToSkip == 0L;
            if (!skippedAllNChars) {
                this.setBitPos0b(startingBitPos);
            }
            bl = skippedAllNChars;
        }
        return bl;
    }

    @Override
    public boolean lookingAt(Matcher matcher, FormatInfo finfo) {
        boolean bl;
        boolean aligned = this.align(finfo.encodingMandatoryAlignmentInBits(), finfo);
        if (!aligned) {
            bl = false;
        } else {
            int regexMatchBufferLimit = finfo.tunable().initialRegexMatchLimitInCharacters();
            CharBuffer regexMatchBuffer = finfo.regexMatchBuffer();
            LongBuffer regexMatchBitPositionBuffer = finfo.regexMatchBitPositionBuffer();
            regexMatchBuffer.position(0);
            regexMatchBuffer.limit(0);
            regexMatchBitPositionBuffer.position(0);
            regexMatchBitPositionBuffer.limit(0);
            long startingBitPos = this.bitPos0b();
            boolean keepMatching = true;
            boolean isMatch = false;
            while (keepMatching) {
                regexMatchBuffer.position(regexMatchBuffer.limit());
                regexMatchBuffer.limit(regexMatchBufferLimit);
                regexMatchBitPositionBuffer.position(regexMatchBitPositionBuffer.limit());
                regexMatchBitPositionBuffer.limit(regexMatchBufferLimit);
                int numDecoded = finfo.decoder().decode(this, finfo, regexMatchBuffer, regexMatchBitPositionBuffer);
                boolean potentiallyMoreData = regexMatchBuffer.position() == regexMatchBuffer.limit();
                regexMatchBuffer.flip();
                regexMatchBitPositionBuffer.flip();
                if (numDecoded > 0) {
                    matcher.reset(regexMatchBuffer);
                    isMatch = matcher.lookingAt();
                    boolean hitEnd = matcher.hitEnd();
                    boolean requireEnd = matcher.requireEnd();
                    if (potentiallyMoreData && (hitEnd || isMatch && requireEnd)) {
                        if (regexMatchBufferLimit == regexMatchBuffer.capacity()) {
                            keepMatching = false;
                            continue;
                        }
                        regexMatchBufferLimit = Math.min(regexMatchBufferLimit * 2, regexMatchBuffer.capacity());
                        continue;
                    }
                    keepMatching = false;
                    continue;
                }
                keepMatching = false;
            }
            if (isMatch && matcher.end() != 0) {
                long endingBitPos = regexMatchBitPositionBuffer.get(matcher.end() - 1);
                this.setBitPos0b(endingBitPos);
            } else {
                this.setBitPos0b(startingBitPos);
            }
            bl = isMatch;
        }
        return bl;
    }

    private InputSourceDataInputStreamCharIterator charIterator() {
        return this.charIterator;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DataInputStream.CharIterator asIteratorChar() {
        void var1_1;
        InputSourceDataInputStreamCharIterator ci = this.charIterator();
        ci.reset();
        return var1_1;
    }

    @Override
    public void setDebugging(boolean setting) {
        DataInputStreamImplMixin.setDebugging$(this, setting);
        this.inputSource().setDebugging(setting);
    }

    @Override
    public ByteBuffer pastData(int nBytesRequested) {
        if (!this.areDebugging()) {
            throw new IllegalStateException("Must be debugging.");
        }
        if (nBytesRequested < 0) {
            throw Assert$.MODULE$.abort("Usage error: nBytesRequested.>=(0)");
        }
        if (nBytesRequested == 0) {
            return ByteBuffer.allocate(0).asReadOnlyBuffer();
        }
        long savedBytePosition = this.inputSource().position();
        int bytesToRead = (int)Math.min(savedBytePosition, (long)nBytesRequested);
        long newBytePosition = savedBytePosition - (long)bytesToRead;
        this.inputSource().position(newBytePosition);
        byte[] array = new byte[bytesToRead];
        this.inputSource().get(array, 0, bytesToRead);
        this.inputSource().position(savedBytePosition);
        return ByteBuffer.wrap(array).asReadOnlyBuffer();
    }

    @Override
    public ByteBuffer futureData(int nBytesRequested) {
        if (!this.areDebugging()) {
            throw new IllegalStateException("Must be debugging.");
        }
        if (nBytesRequested < 0) {
            throw Assert$.MODULE$.abort("Usage error: nBytesRequested.>=(0)");
        }
        if (nBytesRequested == 0) {
            return ByteBuffer.allocate(0).asReadOnlyBuffer();
        }
        long savedBytePosition = this.inputSource().position();
        boolean available = this.inputSource().areBytesAvailable(nBytesRequested);
        int bytesToRead = available ? nBytesRequested : (int)this.inputSource().bytesAvailable();
        byte[] array = new byte[bytesToRead];
        this.inputSource().get(array, 0, bytesToRead);
        this.inputSource().position(savedBytePosition);
        return ByteBuffer.wrap(array).asReadOnlyBuffer();
    }

    private static final byte calcNewByte$1(long curByte, long nxtByte, int curBitMask$1, int nxtBitMask$1, boolean isMSBF$1, int curShift$1, int nxtShift$1) {
        long curBits = curByte & (long)curBitMask$1;
        long nxtBits = nxtByte & (long)nxtBitMask$1;
        long newByte = isMSBF$1 ? curBits << curShift$1 | nxtBits >> nxtShift$1 : curBits >> curShift$1 | nxtBits << nxtShift$1;
        return Bits$.MODULE$.asSignedByte(newByte);
    }

    /*
     * WARNING - void declaration
     */
    private final long buildLongFromArray$1(int numBytes$1) {
        void var2_2;
        long l = Bits$.MODULE$.asUnsignedByte(this.longArray()[0]);
        for (int i = 1; i < numBytes$1; ++i) {
            l = l << 8 | (long)Bits$.MODULE$.asUnsignedByte(this.longArray()[i]);
        }
        return (long)var2_2;
    }

    public static final /* synthetic */ Object $anonfun$getSomeString$1(InputSourceDataInputStream $this, long nChars$1, FormatInfo finfo$1, long startingBitPos$1, LocalBufferMixin.LocalCharBuffer lcb) {
        Object object;
        LongBuffer x$4;
        CharBuffer x$3;
        FormatInfo x$2;
        InputSourceDataInputStream x$1;
        CharBuffer cb = (CharBuffer)lcb.getBuf(nChars$1);
        BitsCharsetDecoder qual$1 = finfo$1.decoder();
        int numDecoded = qual$1.decode(x$1 = $this, x$2 = finfo$1, x$3 = cb, x$4 = qual$1.decode$default$4());
        if (numDecoded > 0) {
            object = Maybe$.MODULE$.apply((Object)cb.flip().toString());
        } else {
            $this.setBitPos0b(startingBitPos$1);
            object = Maybe$.MODULE$.Nope();
        }
        return object;
    }

    public InputSourceDataInputStream(InputSource inputSource) {
        this.inputSource = inputSource;
        DataInputStream.$init$(this);
        DataStreamCommonImplMixin.$init$(this);
        LocalBufferMixin.$init$(this);
        DataInputStreamImplMixin.$init$(this);
        this.cst = new MarkState();
        this.markStack = new MStackOf();
        this.markPool = new MarkPool();
        this.longArray = new byte[8];
        this.charIterator = new InputSourceDataInputStreamCharIterator(this);
    }
}

