/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.test;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.curator-test.shaded.com.google.common.base.Throwables;
import org.apache.curator-test.shaded.com.google.common.collect.ImmutableList;
import org.apache.curator-test.shaded.com.google.common.io.Files;
import org.apache.curator.test.InstanceSpec;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;

public class QuorumConfigBuilder
implements Closeable {
    private final ImmutableList<InstanceSpec> instanceSpecs;
    private final boolean fromRandom;
    private final File fakeConfigFile;

    public QuorumConfigBuilder(Collection<InstanceSpec> specs) {
        this(specs.toArray(new InstanceSpec[specs.size()]));
    }

    public QuorumConfigBuilder(InstanceSpec ... specs) {
        this.fromRandom = specs == null || specs.length == 0;
        this.instanceSpecs = this.fromRandom ? ImmutableList.of(InstanceSpec.newInstanceSpec()) : ImmutableList.copyOf(specs);
        File fakeConfigFile = null;
        try {
            fakeConfigFile = File.createTempFile("temp", "temp");
        }
        catch (IOException e) {
            Throwables.propagate(e);
        }
        this.fakeConfigFile = fakeConfigFile;
    }

    public boolean isFromRandom() {
        return this.fromRandom;
    }

    public QuorumPeerConfig buildConfig() throws Exception {
        return this.buildConfig(0);
    }

    public InstanceSpec getInstanceSpec(int index) {
        return (InstanceSpec)this.instanceSpecs.get(index);
    }

    public List<InstanceSpec> getInstanceSpecs() {
        return this.instanceSpecs;
    }

    public int size() {
        return this.instanceSpecs.size();
    }

    @Override
    public void close() {
        if (this.fakeConfigFile != null) {
            this.fakeConfigFile.delete();
        }
    }

    public QuorumPeerConfig buildConfig(int instanceIndex) throws Exception {
        Map<String, Object> customProperties;
        int maxClientCnxns;
        boolean isCluster = this.instanceSpecs.size() > 1;
        InstanceSpec spec = (InstanceSpec)this.instanceSpecs.get(instanceIndex);
        if (isCluster) {
            Files.write(Integer.toString(spec.getServerId()).getBytes(), new File(spec.getDataDirectory(), "myid"));
        }
        Properties properties = new Properties();
        properties.setProperty("initLimit", "10");
        properties.setProperty("syncLimit", "5");
        properties.setProperty("dataDir", spec.getDataDirectory().getCanonicalPath());
        properties.setProperty("clientPort", Integer.toString(spec.getPort()));
        int tickTime = spec.getTickTime();
        if (tickTime >= 0) {
            properties.setProperty("tickTime", Integer.toString(tickTime));
        }
        if ((maxClientCnxns = spec.getMaxClientCnxns()) >= 0) {
            properties.setProperty("maxClientCnxns", Integer.toString(maxClientCnxns));
        }
        if (isCluster) {
            for (InstanceSpec instanceSpec : this.instanceSpecs) {
                properties.setProperty("server." + instanceSpec.getServerId(), String.format("%s:%d:%d;%s:%d", instanceSpec.getHostname(), instanceSpec.getQuorumPort(), instanceSpec.getElectionPort(), instanceSpec.getHostname(), instanceSpec.getPort()));
            }
        }
        if ((customProperties = spec.getCustomProperties()) != null) {
            for (Map.Entry<String, Object> entry : customProperties.entrySet()) {
                properties.put(entry.getKey(), entry.getValue());
            }
        }
        QuorumPeerConfig quorumPeerConfig = new QuorumPeerConfig(){
            {
                if (QuorumConfigBuilder.this.fakeConfigFile != null) {
                    this.configFileStr = QuorumConfigBuilder.this.fakeConfigFile.getPath();
                }
            }
        };
        quorumPeerConfig.parseProperties(properties);
        return quorumPeerConfig;
    }
}

