/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.test;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicInteger;

public class InstanceSpec {
    private static final AtomicInteger nextServerId = new AtomicInteger(1);
    private static final String localhost;
    private final File dataDirectory;
    private final int port;
    private final int electionPort;
    private final int quorumPort;
    private final boolean deleteDataDirectoryOnClose;
    private final int serverId;
    private final int tickTime;
    private final int maxClientCnxns;

    public static InstanceSpec newInstanceSpec() {
        return new InstanceSpec(null, -1, -1, -1, true, -1, -1, -1);
    }

    public static int getRandomPort() {
        ServerSocket server = null;
        try {
            server = new ServerSocket(0);
            int n = server.getLocalPort();
            return n;
        }
        catch (IOException e) {
            throw new Error(e);
        }
        finally {
            if (server != null) {
                try {
                    server.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    public InstanceSpec(File dataDirectory, int port, int electionPort, int quorumPort, boolean deleteDataDirectoryOnClose, int serverId) {
        this(dataDirectory, port, electionPort, quorumPort, deleteDataDirectoryOnClose, serverId, -1, -1);
    }

    public InstanceSpec(File dataDirectory, int port, int electionPort, int quorumPort, boolean deleteDataDirectoryOnClose, int serverId, int tickTime, int maxClientCnxns) {
        this.dataDirectory = dataDirectory != null ? dataDirectory : Files.createTempDir();
        this.port = port >= 0 ? port : InstanceSpec.getRandomPort();
        this.electionPort = electionPort >= 0 ? electionPort : InstanceSpec.getRandomPort();
        this.quorumPort = quorumPort >= 0 ? quorumPort : InstanceSpec.getRandomPort();
        this.deleteDataDirectoryOnClose = deleteDataDirectoryOnClose;
        this.serverId = serverId >= 0 ? serverId : nextServerId.getAndIncrement();
        this.tickTime = tickTime > 0 ? tickTime : -1;
        this.maxClientCnxns = maxClientCnxns >= 0 ? maxClientCnxns : -1;
    }

    public int getServerId() {
        return this.serverId;
    }

    public File getDataDirectory() {
        return this.dataDirectory;
    }

    public int getPort() {
        return this.port;
    }

    public int getElectionPort() {
        return this.electionPort;
    }

    public int getQuorumPort() {
        return this.quorumPort;
    }

    public String getConnectString() {
        return localhost + ":" + this.port;
    }

    public int getTickTime() {
        return this.tickTime;
    }

    public int getMaxClientCnxns() {
        return this.maxClientCnxns;
    }

    public boolean deleteDataDirectoryOnClose() {
        return this.deleteDataDirectoryOnClose;
    }

    public String toString() {
        return "InstanceSpec{dataDirectory=" + this.dataDirectory + ", port=" + this.port + ", electionPort=" + this.electionPort + ", quorumPort=" + this.quorumPort + ", deleteDataDirectoryOnClose=" + this.deleteDataDirectoryOnClose + ", serverId=" + this.serverId + ", tickTime=" + this.tickTime + ", maxClientCnxns=" + this.maxClientCnxns + "} " + super.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstanceSpec that = (InstanceSpec)o;
        return this.port == that.port;
    }

    public int hashCode() {
        return this.port;
    }

    static {
        String address = "localhost";
        try {
            for (InetAddress a : InetAddress.getAllByName("localhost")) {
                if (a.isLinkLocalAddress()) continue;
                address = a.getHostAddress();
                break;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        localhost = address;
    }
}

