/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rdf.rdf4j.impl;

import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.api.Triple;
import org.apache.commons.rdf.api.TripleLike;
import org.apache.commons.rdf.rdf4j.ClosableIterable;
import org.apache.commons.rdf.rdf4j.RDF4J;
import org.apache.commons.rdf.rdf4j.RDF4JBlankNodeOrIRI;
import org.apache.commons.rdf.rdf4j.RDF4JGraph;
import org.apache.commons.rdf.rdf4j.RDF4JTriple;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.Repository;

final class ModelGraphImpl
implements RDF4JGraph {
    private final Model model;
    private final RDF4J rdf4jTermFactory;

    ModelGraphImpl(Model model, RDF4J rdf4jTermFactory) {
        this.model = model;
        this.rdf4jTermFactory = rdf4jTermFactory;
    }

    public void add(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        this.model.add((Resource)this.rdf4jTermFactory.asValue((RDFTerm)subject), (org.eclipse.rdf4j.model.IRI)this.rdf4jTermFactory.asValue((RDFTerm)predicate), this.rdf4jTermFactory.asValue(object), new Resource[0]);
    }

    public void add(Triple triple) {
        this.model.add((Object)this.rdf4jTermFactory.asStatement((TripleLike)triple));
    }

    @Override
    public Optional<Model> asModel() {
        return Optional.of(this.model);
    }

    @Override
    public Optional<Repository> asRepository() {
        return Optional.empty();
    }

    public void clear() {
        this.model.clear();
    }

    public boolean contains(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        return this.model.contains((Resource)this.rdf4jTermFactory.asValue((RDFTerm)subject), (org.eclipse.rdf4j.model.IRI)this.rdf4jTermFactory.asValue((RDFTerm)predicate), this.rdf4jTermFactory.asValue(object), new Resource[0]);
    }

    public boolean contains(Triple triple) {
        return this.model.contains((Object)this.rdf4jTermFactory.asStatement((TripleLike)triple));
    }

    public void remove(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        this.model.remove((Resource)this.rdf4jTermFactory.asValue((RDFTerm)subject), (org.eclipse.rdf4j.model.IRI)this.rdf4jTermFactory.asValue((RDFTerm)predicate), this.rdf4jTermFactory.asValue(object), new Resource[0]);
    }

    public void remove(Triple triple) {
        this.model.remove((Object)this.rdf4jTermFactory.asStatement((TripleLike)triple));
    }

    public long size() {
        int size = this.model.size();
        if (size < Integer.MAX_VALUE) {
            return size;
        }
        return this.model.parallelStream().count();
    }

    @Override
    public Stream<RDF4JTriple> stream() {
        return this.model.parallelStream().map(this.rdf4jTermFactory::asTriple);
    }

    @Override
    public Stream<RDF4JTriple> stream(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        return this.model.filter((Resource)this.rdf4jTermFactory.asValue((RDFTerm)subject), (org.eclipse.rdf4j.model.IRI)this.rdf4jTermFactory.asValue((RDFTerm)predicate), this.rdf4jTermFactory.asValue(object), new Resource[0]).parallelStream().map(this.rdf4jTermFactory::asTriple);
    }

    @Override
    public Set<RDF4JBlankNodeOrIRI> getContextMask() {
        return Collections.emptySet();
    }

    @Override
    public ClosableIterable<Triple> iterate(final BlankNodeOrIRI subject, final IRI predicate, final RDFTerm object) {
        return new ClosableIterable<Triple>(){

            @Override
            public Iterator<Triple> iterator() {
                Stream<RDF4JTriple> s = ModelGraphImpl.this.stream(subject, predicate, object);
                return s.iterator();
            }

            @Override
            public void close() throws Exception {
            }
        };
    }

    @Override
    public ClosableIterable<Triple> iterate() throws ConcurrentModificationException, IllegalStateException {
        return this.iterate(null, null, null);
    }
}

