/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.concurrent.InfiniteLoopExecutor;

public class ExecutorUtils {
    public static Runnable runWithThreadName(Runnable runnable, String threadName) {
        return () -> {
            String oldThreadName = Thread.currentThread().getName();
            try {
                Thread.currentThread().setName(threadName);
                runnable.run();
            }
            finally {
                Thread.currentThread().setName(oldThreadName);
            }
        };
    }

    public static void shutdownNow(Iterable<?> executors) {
        ExecutorUtils.shutdown(true, executors);
    }

    public static void shutdown(Iterable<?> executors) {
        ExecutorUtils.shutdown(false, executors);
    }

    public static void shutdown(boolean interrupt, Iterable<?> executors) {
        for (Object executor : executors) {
            if (executor instanceof ExecutorService) {
                if (interrupt) {
                    ((ExecutorService)executor).shutdownNow();
                    continue;
                }
                ((ExecutorService)executor).shutdown();
                continue;
            }
            if (executor instanceof InfiniteLoopExecutor) {
                ((InfiniteLoopExecutor)executor).shutdownNow();
                continue;
            }
            if (executor instanceof Thread) {
                ((Thread)executor).interrupt();
                continue;
            }
            if (executor == null) continue;
            throw new IllegalArgumentException(executor.toString());
        }
    }

    public static void shutdown(ExecutorService ... executors) {
        ExecutorUtils.shutdown(Arrays.asList(executors));
    }

    public static void shutdownNow(ExecutorService ... executors) {
        ExecutorUtils.shutdownNow(Arrays.asList(executors));
    }

    public static void awaitTermination(long timeout, TimeUnit unit, ExecutorService ... executors) throws InterruptedException, TimeoutException {
        ExecutorUtils.awaitTermination(timeout, unit, Arrays.asList(executors));
    }

    public static void awaitTermination(long timeout, TimeUnit unit, Collection<?> executors) throws InterruptedException, TimeoutException {
        long deadline = System.nanoTime() + unit.toNanos(timeout);
        ExecutorUtils.awaitTerminationUntil(deadline, executors);
    }

    public static void awaitTerminationUntil(long deadline, Collection<?> executors) throws InterruptedException, TimeoutException {
        for (Object executor : executors) {
            long wait = deadline - System.nanoTime();
            if (executor instanceof ExecutorService) {
                if (wait > 0L && ((ExecutorService)executor).awaitTermination(wait, TimeUnit.NANOSECONDS)) continue;
                throw new TimeoutException(executor + " did not terminate on time");
            }
            if (executor instanceof InfiniteLoopExecutor) {
                if (wait > 0L && ((InfiniteLoopExecutor)executor).awaitTermination(wait, TimeUnit.NANOSECONDS)) continue;
                throw new TimeoutException(executor + " did not terminate on time");
            }
            if (executor instanceof Thread) {
                Thread t = (Thread)executor;
                if (wait <= 0L) {
                    throw new TimeoutException(executor + " did not terminate on time");
                }
                t.join((wait + 999999L) / 1000000L, (int)(wait % 1000000L));
                if (!t.isAlive()) continue;
                throw new TimeoutException(executor + " did not terminate on time");
            }
            if (executor == null) continue;
            throw new IllegalArgumentException(executor.toString());
        }
    }

    public static void shutdownAndWait(long timeout, TimeUnit unit, Collection<?> executors) throws TimeoutException, InterruptedException {
        ExecutorUtils.shutdown(executors);
        ExecutorUtils.awaitTermination(timeout, unit, executors);
    }

    public static void shutdownNowAndWait(long timeout, TimeUnit unit, Collection<?> executors) throws TimeoutException, InterruptedException {
        ExecutorUtils.shutdownNow(executors);
        ExecutorUtils.awaitTermination(timeout, unit, executors);
    }

    public static void shutdownAndWait(long timeout, TimeUnit unit, Object ... executors) throws TimeoutException, InterruptedException {
        ExecutorUtils.shutdownAndWait(timeout, unit, Arrays.asList(executors));
    }

    public static void shutdownNowAndWait(long timeout, TimeUnit unit, Object ... executors) throws TimeoutException, InterruptedException {
        ExecutorUtils.shutdownNowAndWait(timeout, unit, Arrays.asList(executors));
    }
}

