/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.cassandra.utils.FastByteOperations;

public final class InetAddressAndPort
implements Comparable<InetAddressAndPort>,
Serializable {
    private static final long serialVersionUID = 0L;
    static volatile int defaultPort = 7000;
    public final InetAddress address;
    public final byte[] addressBytes;
    public final int port;

    private InetAddressAndPort(InetAddress address, byte[] addressBytes, int port) {
        Preconditions.checkNotNull((Object)address);
        Preconditions.checkNotNull((Object)addressBytes);
        InetAddressAndPort.validatePortRange(port);
        this.address = address;
        this.port = port;
        this.addressBytes = addressBytes;
    }

    private static void validatePortRange(int port) {
        if (port < 0 | port > 65535) {
            throw new IllegalArgumentException("Port " + port + " is not a valid port number in the range 0-65535");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InetAddressAndPort that = (InetAddressAndPort)o;
        if (this.port != that.port) {
            return false;
        }
        return this.address.equals(that.address);
    }

    public int hashCode() {
        int result = this.address.hashCode();
        result = 31 * result + this.port;
        return result;
    }

    @Override
    public int compareTo(InetAddressAndPort o) {
        int retval = FastByteOperations.compareUnsigned(this.addressBytes, 0, this.addressBytes.length, o.addressBytes, 0, o.addressBytes.length);
        if (retval != 0) {
            return retval;
        }
        return Integer.compare(this.port, o.port);
    }

    public String getHostAddress(boolean withPort) {
        if (withPort) {
            return this.toString();
        }
        return this.address.getHostAddress();
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean withPort) {
        if (withPort) {
            return HostAndPort.fromParts((String)this.address.getHostAddress(), (int)this.port).toString();
        }
        return this.address.toString();
    }

    public static InetAddressAndPort getByName(String name) throws UnknownHostException {
        return InetAddressAndPort.getByNameOverrideDefaults(name, null);
    }

    public static InetAddressAndPort getByNameOverrideDefaults(String name, Integer port) throws UnknownHostException {
        HostAndPort hap = HostAndPort.fromString((String)name);
        if (hap.hasPort()) {
            port = hap.getPort();
        }
        return InetAddressAndPort.getByAddressOverrideDefaults(InetAddress.getByName(hap.getHostText()), port);
    }

    public static InetAddressAndPort getByAddress(byte[] address) throws UnknownHostException {
        return InetAddressAndPort.getByAddressOverrideDefaults(InetAddress.getByAddress(address), address, null);
    }

    public static InetAddressAndPort getByAddress(InetAddress address) {
        return InetAddressAndPort.getByAddressOverrideDefaults(address, null);
    }

    public static InetAddressAndPort getByAddressOverrideDefaults(InetAddress address, Integer port) {
        if (port == null) {
            port = defaultPort;
        }
        return new InetAddressAndPort(address, address.getAddress(), port);
    }

    public static InetAddressAndPort getByAddressOverrideDefaults(InetAddress address, byte[] addressBytes, Integer port) {
        if (port == null) {
            port = defaultPort;
        }
        return new InetAddressAndPort(address, addressBytes, port);
    }

    public static void initializeDefaultPort(int port) {
        defaultPort = port;
    }
}

