/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;

public class VariableSpecifications {
    private final List<ColumnIdentifier> variableNames;
    private final ColumnSpecification[] specs;
    private final ColumnDefinition[] targetColumns;

    public VariableSpecifications(List<ColumnIdentifier> variableNames) {
        this.variableNames = variableNames;
        this.specs = new ColumnSpecification[variableNames.size()];
        this.targetColumns = new ColumnDefinition[variableNames.size()];
    }

    public static VariableSpecifications empty() {
        return new VariableSpecifications(Collections.emptyList());
    }

    public int size() {
        return this.variableNames.size();
    }

    public List<ColumnSpecification> getSpecifications() {
        return Arrays.asList(this.specs);
    }

    public short[] getPartitionKeyBindIndexes(CFMetaData cfm) {
        short[] partitionKeyPositions = new short[cfm.partitionKeyColumns().size()];
        boolean[] set = new boolean[partitionKeyPositions.length];
        for (int i = 0; i < this.targetColumns.length; ++i) {
            ColumnDefinition targetColumn = this.targetColumns[i];
            if (targetColumn == null || !targetColumn.isPartitionKey()) continue;
            assert (targetColumn.ksName.equals(cfm.ksName) && targetColumn.cfName.equals(cfm.cfName));
            partitionKeyPositions[targetColumn.position()] = (short)i;
            set[targetColumn.position()] = true;
        }
        for (boolean b : set) {
            if (b) continue;
            return null;
        }
        return partitionKeyPositions;
    }

    public void add(int bindIndex, ColumnSpecification spec) {
        ColumnIdentifier bindMarkerName;
        if (spec instanceof ColumnDefinition) {
            this.targetColumns[bindIndex] = (ColumnDefinition)spec;
        }
        if ((bindMarkerName = this.variableNames.get(bindIndex)) != null) {
            spec = new ColumnSpecification(spec.ksName, spec.cfName, bindMarkerName, spec.type);
        }
        this.specs[bindIndex] = spec;
    }

    public String toString() {
        return Arrays.toString(this.specs);
    }
}

