/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.StreamingRepairTask;
import org.apache.cassandra.repair.Validator;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.repair.messages.SyncRequest;
import org.apache.cassandra.repair.messages.ValidationRequest;
import org.apache.cassandra.service.ActiveRepairService;

public class RepairMessageVerbHandler
implements IVerbHandler<RepairMessage> {
    @Override
    public void doVerb(MessageIn<RepairMessage> message, int id) {
        RepairJobDesc desc = ((RepairMessage)message.payload).desc;
        switch (((RepairMessage)message.payload).messageType) {
            case VALIDATION_REQUEST: {
                ValidationRequest validationRequest = (ValidationRequest)message.payload;
                ColumnFamilyStore store = Keyspace.open(desc.keyspace).getColumnFamilyStore(desc.columnFamily);
                Validator validator = new Validator(desc, message.from, validationRequest.gcBefore);
                CompactionManager.instance.submitValidation(store, validator);
                break;
            }
            case SYNC_REQUEST: {
                SyncRequest request = (SyncRequest)message.payload;
                StreamingRepairTask task = new StreamingRepairTask(desc, request);
                task.run();
                break;
            }
            default: {
                ActiveRepairService.instance.handleMessage(message.from, (RepairMessage)message.payload);
            }
        }
    }
}

