/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.MetricName;
import java.net.InetAddress;
import java.util.Map;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.metrics.MetricNameFactory;
import org.apache.cassandra.utils.UUIDGen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HintedHandoffMetrics {
    private static final Logger logger = LoggerFactory.getLogger(HintedHandoffMetrics.class);
    private final MetricNameFactory factory = new DefaultNameFactory("HintedHandOffManager");
    private final LoadingCache<InetAddress, DifferencingCounter> notStored = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<InetAddress, DifferencingCounter>(){

        public DifferencingCounter load(InetAddress address) {
            return new DifferencingCounter(address);
        }
    });
    private final LoadingCache<InetAddress, Counter> createdHintCounts = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<InetAddress, Counter>(){

        public Counter load(InetAddress address) {
            return Metrics.newCounter((MetricName)HintedHandoffMetrics.this.factory.createMetricName("Hints_created-" + address.getHostAddress()));
        }
    });

    public void incrCreatedHints(InetAddress address) {
        ((Counter)this.createdHintCounts.getUnchecked((Object)address)).inc();
    }

    public void incrPastWindow(InetAddress address) {
        ((DifferencingCounter)this.notStored.getUnchecked((Object)address)).mark();
    }

    public void log() {
        for (Map.Entry entry : this.notStored.asMap().entrySet()) {
            long difference = ((DifferencingCounter)entry.getValue()).difference();
            if (difference == 0L) continue;
            logger.warn("{} has {} dropped hints, because node is down past configured hint window.", entry.getKey(), (Object)difference);
            SystemKeyspace.updateHintsDropped((InetAddress)entry.getKey(), UUIDGen.getTimeUUID(), (int)difference);
        }
    }

    public class DifferencingCounter {
        private final Counter meter;
        private long reported = 0L;

        public DifferencingCounter(InetAddress address) {
            this.meter = Metrics.newCounter((MetricName)HintedHandoffMetrics.this.factory.createMetricName("Hints_not_stored-" + address.getHostAddress()));
        }

        public long difference() {
            long current = this.meter.count();
            long difference = current - this.reported;
            this.reported = current;
            return difference;
        }

        public long count() {
            return this.meter.count();
        }

        public void mark() {
            this.meter.inc();
        }
    }
}

