/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.db.DataTracker;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSTableDeletingTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(SSTableDeletingTask.class);
    private static final Set<SSTableDeletingTask> failedTasks = new CopyOnWriteArraySet<SSTableDeletingTask>();
    private final SSTableReader referent;
    private final Descriptor desc;
    private final Set<Component> components;
    private DataTracker tracker;
    private final long size;

    public SSTableDeletingTask(SSTableReader referent) {
        this.referent = referent;
        this.desc = referent.descriptor;
        this.components = referent.components;
        this.size = referent.bytesOnDisk();
    }

    public void setTracker(DataTracker tracker) {
        this.tracker = tracker;
    }

    public void schedule() {
        StorageService.tasks.submit(this);
    }

    @Override
    public void run() {
        File datafile;
        if (this.tracker != null) {
            this.tracker.notifyDeleting(this.referent);
        }
        if (this.referent.readMeter != null) {
            SystemKeyspace.clearSSTableReadMeter(this.referent.getKeyspaceName(), this.referent.getColumnFamilyName(), this.referent.descriptor.generation);
        }
        if (!(datafile = new File(this.desc.filenameFor(Component.DATA))).delete()) {
            logger.error("Unable to delete " + datafile + " (it will be removed on server restart; we'll also retry after GC)");
            failedTasks.add(this);
            return;
        }
        SSTable.delete(this.desc, (Set<Component>)Sets.difference(this.components, Collections.singleton(Component.DATA)));
        if (this.tracker != null) {
            this.tracker.spaceReclaimed(this.size);
        }
    }

    public static void rescheduleFailedTasks() {
        for (SSTableDeletingTask task : failedTasks) {
            failedTasks.remove(task);
            task.schedule();
        }
    }

    public static void waitForDeletions() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
            }
        };
        FBUtilities.waitOnFuture(StorageService.tasks.schedule(runnable, 0L, TimeUnit.MILLISECONDS));
    }
}

