/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.columniterator;

import com.google.common.collect.AbstractIterator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.EmptyColumns;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.IndexHelper;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileMark;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.ByteBufferUtil;

class IndexedSliceReader
extends AbstractIterator<OnDiskAtom>
implements OnDiskAtomIterator {
    private final ColumnFamily emptyColumnFamily;
    private final SSTableReader sstable;
    private final List<IndexHelper.IndexInfo> indexes;
    private final FileDataInput originalInput;
    private FileDataInput file;
    private final boolean reversed;
    private final ColumnSlice[] slices;
    private final BlockFetcher fetcher;
    private final Deque<OnDiskAtom> blockColumns = new ArrayDeque<OnDiskAtom>();
    private final AbstractType<?> comparator;
    private final Deque<OnDiskAtom> rangeTombstonesReversed;

    public IndexedSliceReader(SSTableReader sstable, RowIndexEntry indexEntry, FileDataInput input, ColumnSlice[] slices, boolean reversed) {
        Tracing.trace("Seeking to partition indexed section in data file");
        this.sstable = sstable;
        this.originalInput = input;
        this.reversed = reversed;
        this.slices = slices;
        this.comparator = sstable.metadata.comparator;
        this.rangeTombstonesReversed = reversed ? new ArrayDeque() : null;
        try {
            this.indexes = indexEntry.columnsIndex();
            this.emptyColumnFamily = EmptyColumns.factory.create(sstable.metadata);
            if (this.indexes.isEmpty()) {
                this.setToRowStart(indexEntry, input);
                this.emptyColumnFamily.delete(DeletionTime.serializer.deserialize(this.file));
                this.fetcher = new SimpleBlockFetcher();
            } else {
                this.emptyColumnFamily.delete(indexEntry.deletionTime());
                this.fetcher = new IndexedBlockFetcher(indexEntry.position);
            }
        }
        catch (IOException e) {
            sstable.markSuspect();
            throw new CorruptSSTableException((Exception)e, this.file.getPath());
        }
    }

    private void setToRowStart(RowIndexEntry rowEntry, FileDataInput in) throws IOException {
        if (in == null) {
            this.file = this.sstable.getFileDataInput(rowEntry.position);
        } else {
            this.file = in;
            in.seek(rowEntry.position);
        }
        this.sstable.partitioner.decorateKey(ByteBufferUtil.readWithShortLength(this.file));
        if (this.sstable.descriptor.version.hasRowSizeAndColumnCount) {
            this.file.readLong();
        }
    }

    @Override
    public ColumnFamily getColumnFamily() {
        return this.emptyColumnFamily;
    }

    @Override
    public DecoratedKey getKey() {
        throw new UnsupportedOperationException();
    }

    protected OnDiskAtom computeNext() {
        OnDiskAtom column;
        block2: {
            do {
                if (this.reversed && (column = this.rangeTombstonesReversed.poll()) != null) {
                    return column;
                }
                column = this.blockColumns.poll();
                if (column != null) break block2;
            } while (this.fetcher.fetchMoreData());
            return (OnDiskAtom)this.endOfData();
        }
        return column;
    }

    @Override
    public void close() throws IOException {
        if (this.originalInput == null && this.file != null) {
            this.file.close();
        }
    }

    protected void addColumn(OnDiskAtom col) {
        if (this.reversed) {
            if (col instanceof RangeTombstone) {
                this.rangeTombstonesReversed.addFirst(col);
            } else {
                this.blockColumns.addFirst(col);
            }
        } else {
            this.blockColumns.addLast(col);
        }
    }

    private class SimpleBlockFetcher
    extends BlockFetcher {
        public SimpleBlockFetcher() throws IOException {
            super(IndexedSliceReader.this.reversed ? IndexedSliceReader.this.slices.length - 1 : 0);
            boolean inSlice = false;
            int columnCount = ((IndexedSliceReader)IndexedSliceReader.this).sstable.descriptor.version.hasRowSizeAndColumnCount ? IndexedSliceReader.this.file.readInt() : Integer.MAX_VALUE;
            Iterator<OnDiskAtom> atomIterator = IndexedSliceReader.this.emptyColumnFamily.metadata().getOnDiskIterator(IndexedSliceReader.this.file, columnCount, ((IndexedSliceReader)IndexedSliceReader.this).sstable.descriptor.version);
            OnDiskAtom column = null;
            while (atomIterator.hasNext() || column != null) {
                if (column == null) {
                    column = atomIterator.next();
                }
                if (!inSlice && this.isColumnBeforeSliceStart(column)) {
                    column = null;
                    continue;
                }
                if (this.isColumnBeforeSliceFinish(column)) {
                    inSlice = true;
                    IndexedSliceReader.this.addColumn(column);
                    column = null;
                    continue;
                }
                inSlice = false;
                if (this.setNextSlice()) continue;
                break;
            }
        }

        @Override
        protected boolean setNextSlice() {
            if (IndexedSliceReader.this.reversed) {
                if (this.currentSliceIdx <= 0) {
                    return false;
                }
                --this.currentSliceIdx;
            } else {
                if (this.currentSliceIdx >= IndexedSliceReader.this.slices.length - 1) {
                    return false;
                }
                ++this.currentSliceIdx;
            }
            return true;
        }

        @Override
        protected boolean fetchMoreData() {
            return false;
        }
    }

    private class IndexedBlockFetcher
    extends BlockFetcher {
        private final long columnsStart;
        private int nextIndexIdx;
        private int lastDeserializedBlock;
        private final Deque<OnDiskAtom> prefetched;

        public IndexedBlockFetcher(long columnsStart) {
            super(-1);
            this.nextIndexIdx = -1;
            this.lastDeserializedBlock = -1;
            this.columnsStart = columnsStart;
            this.prefetched = IndexedSliceReader.this.reversed ? new ArrayDeque() : null;
            this.setNextSlice();
        }

        @Override
        protected boolean setNextSlice() {
            while (++this.currentSliceIdx < IndexedSliceReader.this.slices.length) {
                this.nextIndexIdx = IndexHelper.indexFor(((IndexedSliceReader)IndexedSliceReader.this).slices[this.currentSliceIdx].start, IndexedSliceReader.this.indexes, IndexedSliceReader.this.comparator, IndexedSliceReader.this.reversed, this.nextIndexIdx);
                if (this.nextIndexIdx < 0 || this.nextIndexIdx >= IndexedSliceReader.this.indexes.size()) continue;
                IndexHelper.IndexInfo info = (IndexHelper.IndexInfo)IndexedSliceReader.this.indexes.get(this.nextIndexIdx);
                if (!(IndexedSliceReader.this.reversed ? !this.isBeforeSliceStart(info.lastName) : !this.isAfterSliceFinish(info.firstName))) continue;
                return true;
            }
            this.nextIndexIdx = -1;
            return false;
        }

        protected boolean hasMoreSlice() {
            return this.currentSliceIdx < IndexedSliceReader.this.slices.length;
        }

        @Override
        protected boolean fetchMoreData() {
            if (!this.hasMoreSlice()) {
                return false;
            }
            if (IndexedSliceReader.this.reversed && !this.prefetched.isEmpty()) {
                OnDiskAtom prefetchedCol;
                boolean gotSome = false;
                boolean inSlice = false;
                while ((prefetchedCol = this.prefetched.peek()) != null) {
                    if (this.isColumnBeforeSliceStart(prefetchedCol)) {
                        inSlice = false;
                        if (this.setNextSlice()) continue;
                        return false;
                    }
                    if (inSlice || this.isColumnBeforeSliceFinish(prefetchedCol)) {
                        IndexedSliceReader.this.blockColumns.addLast(this.prefetched.poll());
                        gotSome = true;
                        inSlice = true;
                        continue;
                    }
                    this.prefetched.poll();
                }
                if (gotSome) {
                    return true;
                }
            }
            try {
                return this.getNextBlock();
            }
            catch (IOException e) {
                throw new CorruptSSTableException((Exception)e, IndexedSliceReader.this.file.getPath());
            }
        }

        private boolean getNextBlock() throws IOException {
            if (this.lastDeserializedBlock == this.nextIndexIdx) {
                this.nextIndexIdx = IndexedSliceReader.this.reversed ? --this.nextIndexIdx : ++this.nextIndexIdx;
            }
            this.lastDeserializedBlock = this.nextIndexIdx;
            if (this.lastDeserializedBlock < 0 || this.lastDeserializedBlock >= IndexedSliceReader.this.indexes.size()) {
                return false;
            }
            IndexHelper.IndexInfo currentIndex = (IndexHelper.IndexInfo)IndexedSliceReader.this.indexes.get(this.lastDeserializedBlock);
            long positionToSeek = this.columnsStart + currentIndex.offset;
            if (IndexedSliceReader.this.file == null) {
                IndexedSliceReader.this.file = IndexedSliceReader.this.originalInput == null ? IndexedSliceReader.this.sstable.getFileDataInput(positionToSeek) : IndexedSliceReader.this.originalInput;
            }
            Iterator<OnDiskAtom> atomIterator = IndexedSliceReader.this.emptyColumnFamily.metadata().getOnDiskIterator(IndexedSliceReader.this.file, Integer.MAX_VALUE, ((IndexedSliceReader)IndexedSliceReader.this).sstable.descriptor.version);
            IndexedSliceReader.this.file.seek(positionToSeek);
            FileMark mark = IndexedSliceReader.this.file.mark();
            boolean inSlice = false;
            OnDiskAtom column = null;
            while (IndexedSliceReader.this.file.bytesPastMark(mark) < currentIndex.width || column != null) {
                if (column == null) {
                    column = atomIterator.next();
                }
                if (!inSlice && this.isColumnBeforeSliceStart(column)) {
                    if (IndexedSliceReader.this.reversed) {
                        this.prefetched.addFirst(column);
                    }
                    column = null;
                    continue;
                }
                if (this.isColumnBeforeSliceFinish(column)) {
                    inSlice = true;
                    IndexedSliceReader.this.addColumn(column);
                    column = null;
                    continue;
                }
                if (IndexedSliceReader.this.reversed && this.prefetched.isEmpty() || !this.setNextSlice()) break;
                inSlice = false;
                if (this.nextIndexIdx != this.lastDeserializedBlock) {
                    if (!IndexedSliceReader.this.reversed) break;
                    this.prefetched.clear();
                    break;
                }
                if (!IndexedSliceReader.this.reversed) continue;
                break;
            }
            return true;
        }
    }

    private abstract class BlockFetcher {
        protected int currentSliceIdx;

        protected BlockFetcher(int sliceIdx) {
            this.currentSliceIdx = sliceIdx;
        }

        protected ByteBuffer currentStart() {
            return IndexedSliceReader.this.reversed ? ((IndexedSliceReader)IndexedSliceReader.this).slices[this.currentSliceIdx].finish : ((IndexedSliceReader)IndexedSliceReader.this).slices[this.currentSliceIdx].start;
        }

        protected ByteBuffer currentFinish() {
            return IndexedSliceReader.this.reversed ? ((IndexedSliceReader)IndexedSliceReader.this).slices[this.currentSliceIdx].start : ((IndexedSliceReader)IndexedSliceReader.this).slices[this.currentSliceIdx].finish;
        }

        protected abstract boolean setNextSlice();

        protected abstract boolean fetchMoreData();

        protected boolean isColumnBeforeSliceStart(OnDiskAtom column) {
            return this.isBeforeSliceStart(column.name());
        }

        protected boolean isBeforeSliceStart(ByteBuffer name) {
            ByteBuffer start = this.currentStart();
            return start.remaining() != 0 && IndexedSliceReader.this.comparator.compare(name, start) < 0;
        }

        protected boolean isColumnBeforeSliceFinish(OnDiskAtom column) {
            ByteBuffer finish = this.currentFinish();
            return finish.remaining() == 0 || IndexedSliceReader.this.comparator.compare(column.name(), finish) <= 0;
        }

        protected boolean isAfterSliceFinish(ByteBuffer name) {
            ByteBuffer finish = this.currentFinish();
            return finish.remaining() != 0 && IndexedSliceReader.this.comparator.compare(name, finish) > 0;
        }
    }
}

