/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.util.Arrays;
import java.util.List;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;

public class VariableSpecifications {
    private final List<ColumnIdentifier> variableNames;
    private final ColumnSpecification[] specs;

    public VariableSpecifications(List<ColumnIdentifier> variableNames) {
        this.variableNames = variableNames;
        this.specs = new ColumnSpecification[variableNames.size()];
    }

    public int size() {
        return this.variableNames.size();
    }

    public List<ColumnSpecification> getSpecifications() {
        return Arrays.asList(this.specs);
    }

    public void add(int bindIndex, ColumnSpecification spec) {
        ColumnIdentifier name = this.variableNames.get(bindIndex);
        if (name != null) {
            spec = new ColumnSpecification(spec.ksName, spec.cfName, name, spec.type);
        }
        this.specs[bindIndex] = spec;
    }
}

