/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop.cql3;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.hadoop.AbstractBulkRecordWriter;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.hadoop.HadoopCompat;
import org.apache.cassandra.hadoop.cql3.CqlBulkOutputFormat;
import org.apache.cassandra.io.sstable.CQLSSTableWriter;
import org.apache.cassandra.io.sstable.SSTableLoader;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.streaming.StreamState;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Progressable;

public class CqlBulkRecordWriter
extends AbstractBulkRecordWriter<Object, List<ByteBuffer>> {
    private String keyspace;
    private String columnFamily;
    private String schema;
    private String insertStatement;
    private File outputDir;
    private boolean deleteSrc;

    CqlBulkRecordWriter(TaskAttemptContext context) throws IOException {
        super(context);
        this.setConfigs();
    }

    CqlBulkRecordWriter(Configuration conf, Progressable progress) throws IOException {
        super(conf, progress);
        this.setConfigs();
    }

    CqlBulkRecordWriter(Configuration conf) throws IOException {
        super(conf);
        this.setConfigs();
    }

    private void setConfigs() throws IOException {
        this.keyspace = ConfigHelper.getOutputKeyspace(this.conf);
        this.columnFamily = ConfigHelper.getOutputColumnFamily(this.conf);
        this.schema = CqlBulkOutputFormat.getColumnFamilySchema(this.conf, this.columnFamily);
        this.insertStatement = CqlBulkOutputFormat.getColumnFamilyInsertStatement(this.conf, this.columnFamily);
        this.outputDir = this.getColumnFamilyDirectory();
        this.deleteSrc = CqlBulkOutputFormat.getDeleteSourceOnSuccess(this.conf);
    }

    private void prepareWriter() throws IOException {
        try {
            if (this.writer == null) {
                this.writer = CQLSSTableWriter.builder().forTable(this.schema).using(this.insertStatement).withPartitioner(ConfigHelper.getOutputPartitioner(this.conf)).inDirectory(this.outputDir).withBufferSizeInMB(Integer.parseInt(this.conf.get("mapreduce.output.bulkoutputformat.buffersize", "64"))).build();
            }
            if (this.loader == null) {
                ExternalClient externalClient = new ExternalClient(this.conf);
                externalClient.addKnownCfs(this.keyspace, this.schema);
                this.loader = new SSTableLoader(this.outputDir, externalClient, new AbstractBulkRecordWriter.NullOutputHandler()){

                    @Override
                    public void onSuccess(StreamState finalState) {
                        if (CqlBulkRecordWriter.this.deleteSrc) {
                            FileUtils.deleteRecursive(CqlBulkRecordWriter.this.outputDir);
                        }
                    }
                };
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void write(Object key, List<ByteBuffer> values) throws IOException {
        this.prepareWriter();
        try {
            ((CQLSSTableWriter)this.writer).rawAddRow(values);
            if (null != this.progress) {
                this.progress.progress();
            }
            if (null != this.context) {
                HadoopCompat.progress(this.context);
            }
        }
        catch (InvalidRequestException e) {
            throw new IOException("Error adding row with key: " + key, e);
        }
    }

    private File getColumnFamilyDirectory() throws IOException {
        File dir = new File(String.format("%s%s%s%s%s", this.getOutputLocation(), File.separator, this.keyspace, File.separator, this.columnFamily));
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Failed to created output directory: " + dir);
        }
        return dir;
    }

    public static class ExternalClient
    extends AbstractBulkRecordWriter.ExternalClient {
        private Map<String, Map<String, CFMetaData>> knownCqlCfs = new HashMap<String, Map<String, CFMetaData>>();

        public ExternalClient(Configuration conf) {
            super(conf);
        }

        public void addKnownCfs(String keyspace, String cql) {
            Map<String, CFMetaData> cfs = this.knownCqlCfs.get(keyspace);
            if (cfs == null) {
                cfs = new HashMap<String, CFMetaData>();
                this.knownCqlCfs.put(keyspace, cfs);
            }
            CFMetaData metadata = CFMetaData.compile(cql, keyspace);
            cfs.put(metadata.cfName, metadata);
        }

        @Override
        public CFMetaData getCFMetaData(String keyspace, String cfName) {
            CFMetaData metadata = super.getCFMetaData(keyspace, cfName);
            if (metadata != null) {
                return metadata;
            }
            Map<String, CFMetaData> cfs = this.knownCqlCfs.get(keyspace);
            return cfs != null ? cfs.get(cfName) : null;
        }
    }
}

