/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.serializers.Int32Serializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class Int32Type
extends AbstractType<Integer> {
    public static final Int32Type instance = new Int32Type();

    Int32Type() {
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        if (o1.remaining() == 0) {
            return o2.remaining() == 0 ? 0 : -1;
        }
        if (o2.remaining() == 0) {
            return 1;
        }
        int diff = o1.get(o1.position()) - o2.get(o2.position());
        if (diff != 0) {
            return diff;
        }
        return ByteBufferUtil.compareUnsigned(o1, o2);
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        int int32Type;
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        try {
            int32Type = Integer.parseInt(source);
        }
        catch (Exception e) {
            throw new MarshalException(String.format("unable to make int from '%s'", source), e);
        }
        return this.decompose(int32Type);
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.INT;
    }

    @Override
    public TypeSerializer<Integer> getSerializer() {
        return Int32Serializer.instance;
    }
}

