/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.net.InetAddress;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.OutboundTcpConnection;

class OutboundTcpConnectionPool {
    public final OutboundTcpConnection cmdCon;
    public final OutboundTcpConnection ackCon;

    OutboundTcpConnectionPool(InetAddress remoteEp) {
        this.cmdCon = new OutboundTcpConnection(remoteEp);
        this.cmdCon.start();
        this.ackCon = new OutboundTcpConnection(remoteEp);
        this.ackCon.start();
    }

    OutboundTcpConnection getConnection(Message msg) {
        Stage stage = msg.getMessageType();
        return stage == Stage.REQUEST_RESPONSE || stage == Stage.INTERNAL_RESPONSE || stage == Stage.GOSSIP ? this.ackCon : this.cmdCon;
    }

    synchronized void reset() {
        for (OutboundTcpConnection con : new OutboundTcpConnection[]{this.cmdCon, this.ackCon}) {
            con.closeSocket();
        }
    }
}

