/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.context;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.db.context.IContext;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.NodeId;
import org.apache.log4j.Logger;

public class CounterContext
implements IContext {
    private static final int HEADER_SIZE_LENGTH = 2;
    private static final int HEADER_ELT_LENGTH = 2;
    private static final int CLOCK_LENGTH = 8;
    private static final int COUNT_LENGTH = 8;
    private static final int STEP_LENGTH = 32;
    private static final Logger logger = Logger.getLogger(CounterContext.class);
    private static final long MIN_MERGE_DELAY = 300000L;

    public static CounterContext instance() {
        return LazyHolder.counterContext;
    }

    public ByteBuffer create(long value) {
        ByteBuffer context = ByteBuffer.allocate(36);
        context.putShort(0, (short)1);
        context.putShort(2, (short)0);
        CounterContext.writeElementAtOffset(context, 4, NodeId.getLocalId(), 1L, value);
        return context;
    }

    public ByteBuffer create(NodeId id, long clock, long value, boolean isDelta) {
        ByteBuffer context = ByteBuffer.allocate(2 + (isDelta ? 2 : 0) + 32);
        context.putShort(0, (short)(isDelta ? 1 : 0));
        if (isDelta) {
            context.putShort(2, (short)0);
        }
        CounterContext.writeElementAtOffset(context, 2 + (isDelta ? 2 : 0), id, clock, value);
        return context;
    }

    private static void writeElementAtOffset(ByteBuffer context, int offset, NodeId id, long clock, long count) {
        ByteBufferUtil.arrayCopy(id.bytes(), id.bytes().position(), context, offset, 16);
        context.putLong(offset + 16, clock);
        context.putLong(offset + 16 + 8, count);
    }

    private static int headerLength(ByteBuffer context) {
        return 2 + context.getShort(context.position()) * 2;
    }

    private static int compareId(ByteBuffer bb1, int pos1, ByteBuffer bb2, int pos2) {
        return ByteBufferUtil.compareSubArrays(bb1, pos1, bb2, pos2, 16);
    }

    @Override
    public IContext.ContextRelationship diff(ByteBuffer left, ByteBuffer right) {
        IContext.ContextRelationship relationship = IContext.ContextRelationship.EQUAL;
        ContextState leftState = new ContextState(left, CounterContext.headerLength(left));
        ContextState rightState = new ContextState(right, CounterContext.headerLength(right));
        while (leftState.hasRemaining() && rightState.hasRemaining()) {
            int compareId = leftState.compareIdTo(rightState);
            if (compareId == 0) {
                long leftClock = leftState.getClock();
                long rightClock = rightState.getClock();
                leftState.moveToNext();
                rightState.moveToNext();
                if (leftClock == rightClock) continue;
                if (leftClock >= 0L && rightClock > 0L && leftClock > rightClock || leftClock < 0L && (rightClock > 0L || leftClock < rightClock)) {
                    if (relationship == IContext.ContextRelationship.EQUAL) {
                        relationship = IContext.ContextRelationship.GREATER_THAN;
                        continue;
                    }
                    if (relationship == IContext.ContextRelationship.GREATER_THAN) continue;
                    return IContext.ContextRelationship.DISJOINT;
                }
                if (relationship == IContext.ContextRelationship.EQUAL) {
                    relationship = IContext.ContextRelationship.LESS_THAN;
                    continue;
                }
                if (relationship != IContext.ContextRelationship.GREATER_THAN) continue;
                return IContext.ContextRelationship.DISJOINT;
            }
            if (compareId > 0) {
                rightState.moveToNext();
                if (relationship == IContext.ContextRelationship.EQUAL) {
                    relationship = IContext.ContextRelationship.LESS_THAN;
                    continue;
                }
                if (relationship != IContext.ContextRelationship.GREATER_THAN) continue;
                return IContext.ContextRelationship.DISJOINT;
            }
            leftState.moveToNext();
            if (relationship == IContext.ContextRelationship.EQUAL) {
                relationship = IContext.ContextRelationship.GREATER_THAN;
                continue;
            }
            if (relationship == IContext.ContextRelationship.GREATER_THAN) continue;
            return IContext.ContextRelationship.DISJOINT;
        }
        if (leftState.hasRemaining()) {
            if (relationship == IContext.ContextRelationship.EQUAL) {
                return IContext.ContextRelationship.GREATER_THAN;
            }
            if (relationship == IContext.ContextRelationship.LESS_THAN) {
                return IContext.ContextRelationship.DISJOINT;
            }
        } else if (rightState.hasRemaining()) {
            if (relationship == IContext.ContextRelationship.EQUAL) {
                return IContext.ContextRelationship.LESS_THAN;
            }
            if (relationship == IContext.ContextRelationship.GREATER_THAN) {
                return IContext.ContextRelationship.DISJOINT;
            }
        }
        return relationship;
    }

    @Override
    public ByteBuffer merge(ByteBuffer left, ByteBuffer right) {
        ContextState leftState = new ContextState(left, CounterContext.headerLength(left));
        ContextState rightState = new ContextState(right, CounterContext.headerLength(right));
        int mergedHeaderLength = 2;
        int mergedBodyLength = 0;
        while (leftState.hasRemaining() && rightState.hasRemaining()) {
            int cmp = leftState.compareIdTo(rightState);
            if (cmp == 0) {
                mergedBodyLength += 32;
                if (leftState.isDelta() || rightState.isDelta()) {
                    mergedHeaderLength += 2;
                }
                leftState.moveToNext();
                rightState.moveToNext();
                continue;
            }
            if (cmp > 0) {
                mergedBodyLength += 32;
                if (rightState.isDelta()) {
                    mergedHeaderLength += 2;
                }
                rightState.moveToNext();
                continue;
            }
            mergedBodyLength += 32;
            if (leftState.isDelta()) {
                mergedHeaderLength += 2;
            }
            leftState.moveToNext();
        }
        ByteBuffer merged = ByteBuffer.allocate((mergedHeaderLength += leftState.remainingHeaderLength() + rightState.remainingHeaderLength()) + (mergedBodyLength += leftState.remainingBodyLength() + rightState.remainingBodyLength()));
        merged.putShort(merged.position(), (short)((mergedHeaderLength - 2) / 2));
        ContextState mergedState = new ContextState(merged, mergedHeaderLength);
        leftState.reset();
        rightState.reset();
        while (leftState.hasRemaining() && rightState.hasRemaining()) {
            int cmp = leftState.compareIdTo(rightState);
            if (cmp == 0) {
                if (leftState.isDelta() || rightState.isDelta()) {
                    if (leftState.isDelta() && rightState.isDelta()) {
                        long clock = leftState.getClock() + rightState.getClock();
                        long count = leftState.getCount() + rightState.getCount();
                        mergedState.writeElement(leftState.getNodeId(), clock, count, true);
                    } else {
                        (leftState.isDelta() ? leftState : rightState).copyTo(mergedState);
                    }
                } else {
                    long leftClock = leftState.getClock();
                    long rightClock = rightState.getClock();
                    if (leftClock >= 0L && rightClock > 0L && leftClock >= rightClock || leftClock < 0L && (rightClock > 0L || leftClock < rightClock)) {
                        leftState.copyTo(mergedState);
                    } else {
                        rightState.copyTo(mergedState);
                    }
                }
                rightState.moveToNext();
                leftState.moveToNext();
                continue;
            }
            if (cmp > 0) {
                rightState.copyTo(mergedState);
                rightState.moveToNext();
                continue;
            }
            leftState.copyTo(mergedState);
            leftState.moveToNext();
        }
        while (leftState.hasRemaining()) {
            leftState.copyTo(mergedState);
            leftState.moveToNext();
        }
        while (rightState.hasRemaining()) {
            rightState.copyTo(mergedState);
            rightState.moveToNext();
        }
        return merged;
    }

    @Override
    public String toString(ByteBuffer context) {
        ContextState state = new ContextState(context, CounterContext.headerLength(context));
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        while (state.hasRemaining()) {
            if (state.elementIdx() > 0) {
                sb.append(",");
            }
            sb.append("{");
            sb.append(state.getNodeId().toString()).append(", ");
            sb.append(state.getClock()).append(", ");
            sb.append(state.getCount());
            sb.append("}");
            if (state.isDelta()) {
                sb.append("*");
            }
            state.moveToNext();
        }
        sb.append("]");
        return sb.toString();
    }

    public long total(ByteBuffer context) {
        long total = 0L;
        for (int offset = context.position() + CounterContext.headerLength(context); offset < context.limit(); offset += 32) {
            long count = context.getLong(offset + 16 + 8);
            total += count;
        }
        return total;
    }

    public ByteBuffer clearAllDelta(ByteBuffer context) {
        int headerLength = CounterContext.headerLength(context);
        if (headerLength == 0) {
            return context;
        }
        ByteBuffer cleaned = ByteBuffer.allocate(context.remaining() - headerLength + 2);
        cleaned.putShort(cleaned.position(), (short)0);
        ByteBufferUtil.arrayCopy(context, context.position() + headerLength, cleaned, cleaned.position() + 2, context.remaining() - headerLength);
        return cleaned;
    }

    public void validateContext(ByteBuffer context) throws MarshalException {
        int headerLength = CounterContext.headerLength(context);
        if (headerLength < 0 || (context.remaining() - headerLength) % 32 != 0) {
            throw new MarshalException("Invalid size for a counter context");
        }
    }

    public void updateDigest(MessageDigest message, ByteBuffer context) {
        int hlength = CounterContext.headerLength(context);
        ByteBuffer dup = context.duplicate();
        dup.position(context.position() + hlength);
        message.update(dup);
    }

    public boolean hasNodeId(ByteBuffer context, NodeId id) {
        for (int offset = context.position() + CounterContext.headerLength(context); offset < context.limit(); offset += 32) {
            if (!id.equals(NodeId.wrap(context, offset))) continue;
            return true;
        }
        return false;
    }

    public ByteBuffer computeOldShardMerger(ByteBuffer context, List<NodeId.NodeIdRecord> oldIds) {
        long now = System.currentTimeMillis();
        int hlength = CounterContext.headerLength(context);
        if (oldIds.size() < 2 || now - oldIds.get((int)0).timestamp < 300000L || now - oldIds.get((int)1).timestamp < 300000L || context.remaining() - hlength < 64) {
            return null;
        }
        Iterator<NodeId.NodeIdRecord> recordIterator = oldIds.iterator();
        NodeId.NodeIdRecord currRecord = recordIterator.next();
        ContextState state = new ContextState(context, hlength);
        ContextState foundState = null;
        while (state.hasRemaining() && currRecord != null) {
            if (now - currRecord.timestamp < 300000L) {
                return context;
            }
            assert (!currRecord.id.equals(NodeId.getLocalId()));
            int c = state.getNodeId().compareTo(currRecord.id);
            if (c == 0) {
                if (foundState == null) {
                    if (state.getClock() < 0L) {
                        return null;
                    }
                    foundState = state.duplicate();
                    currRecord = recordIterator.hasNext() ? recordIterator.next() : null;
                    state.moveToNext();
                    continue;
                }
                assert (!foundState.getNodeId().equals(state.getNodeId()));
                int nbDelta = foundState.isDelta() ? 1 : 0;
                ContextState merger = ContextState.allocate(2, nbDelta += state.isDelta() ? 1 : 0);
                long fclock = foundState.getClock();
                long fcount = foundState.getCount();
                long clock = state.getClock();
                long count = state.getCount();
                if (foundState.isDelta()) {
                    merger.writeElement(foundState.getNodeId(), -now - fclock, -fcount, true);
                } else {
                    merger.writeElement(foundState.getNodeId(), -now, 0L);
                }
                if (state.isDelta()) {
                    merger.writeElement(state.getNodeId(), fclock + clock, fcount, true);
                } else {
                    merger.writeElement(state.getNodeId(), fclock + clock, fcount + count);
                }
                return merger.context;
            }
            if (c < 0) {
                state.moveToNext();
                continue;
            }
            currRecord = recordIterator.hasNext() ? recordIterator.next() : null;
        }
        return null;
    }

    public ByteBuffer removeOldShards(ByteBuffer context, int gcBefore) {
        int hlength = CounterContext.headerLength(context);
        ContextState state = new ContextState(context, hlength);
        int removedBodySize = 0;
        int removedHeaderSize = 0;
        boolean forceFixing = false;
        while (state.hasRemaining()) {
            long clock = state.getClock();
            if (!(clock >= 0L || -((int)(clock / 1000L)) >= gcBefore || state.getCount() != 0L && state.isDelta())) {
                removedBodySize += 32;
                if (state.isDelta()) {
                    removedHeaderSize += 2;
                }
            } else if (clock < 0L && state.getCount() != 0L && state.isDelta()) {
                forceFixing = true;
            }
            state.moveToNext();
        }
        if (removedBodySize == 0 && !forceFixing) {
            return context;
        }
        int newSize = context.remaining() - removedHeaderSize - removedBodySize;
        int newHlength = hlength - removedHeaderSize;
        ByteBuffer cleanedContext = ByteBuffer.allocate(newSize);
        cleanedContext.putShort(cleanedContext.position(), (short)((newHlength - 2) / 2));
        ContextState cleaned = new ContextState(cleanedContext, newHlength);
        state.reset();
        long toAddBack = 0L;
        while (state.hasRemaining()) {
            long clock = state.getClock();
            if (clock >= 0L || -((int)(clock / 1000L)) >= gcBefore || state.getCount() != 0L && state.isDelta()) {
                if (clock < 0L && state.getCount() != 0L && state.isDelta()) {
                    if (state.getNodeId().equals(NodeId.getLocalId())) {
                        throw new RuntimeException("Merged counter shard with a count != 0 (likely due to #2968). You need to restart this node with -Dcassandra.renew_counter_id=true to fix.");
                    }
                    logger.info((Object)"Collectable old shard with a count != 0. Will fix.");
                    cleaned.writeElement(state.getNodeId(), clock - 1L, 0L, true);
                    toAddBack += state.getCount();
                } else {
                    state.copyTo(cleaned);
                }
            }
            state.moveToNext();
        }
        return toAddBack == 0L ? cleanedContext : this.merge(cleanedContext, this.create(toAddBack));
    }

    public static class ContextState {
        public final ByteBuffer context;
        public final int headerLength;
        private int headerOffset;
        private int bodyOffset;
        private boolean currentIsDelta;

        public ContextState(ByteBuffer context, int headerLength) {
            this(context, headerLength, 2, headerLength, false);
            this.updateIsDelta();
        }

        public ContextState(ByteBuffer context) {
            this(context, CounterContext.headerLength(context));
        }

        private ContextState(ByteBuffer context, int headerLength, int headerOffset, int bodyOffset, boolean currentIsDelta) {
            this.context = context;
            this.headerLength = headerLength;
            this.headerOffset = headerOffset;
            this.bodyOffset = bodyOffset;
            this.currentIsDelta = currentIsDelta;
        }

        public boolean isDelta() {
            return this.currentIsDelta;
        }

        private void updateIsDelta() {
            this.currentIsDelta = this.headerOffset < this.headerLength && this.context.getShort(this.context.position() + this.headerOffset) == (short)this.elementIdx();
        }

        public boolean hasRemaining() {
            return this.bodyOffset < this.context.remaining();
        }

        public int remainingHeaderLength() {
            return this.headerLength - this.headerOffset;
        }

        public int remainingBodyLength() {
            return this.context.remaining() - this.bodyOffset;
        }

        public void moveToNext() {
            this.bodyOffset += 32;
            if (this.currentIsDelta) {
                this.headerOffset += 2;
            }
            this.updateIsDelta();
        }

        public void copyTo(ContextState other) {
            ByteBufferUtil.arrayCopy(this.context, this.context.position() + this.bodyOffset, other.context, other.context.position() + other.bodyOffset, 32);
            if (this.currentIsDelta) {
                other.context.putShort(other.context.position() + other.headerOffset, (short)other.elementIdx());
            }
            other.currentIsDelta = this.currentIsDelta;
            other.moveToNext();
        }

        public int compareIdTo(ContextState other) {
            return CounterContext.compareId(this.context, this.context.position() + this.bodyOffset, other.context, other.context.position() + other.bodyOffset);
        }

        public void reset() {
            this.headerOffset = 2;
            this.bodyOffset = this.headerLength;
            this.updateIsDelta();
        }

        public NodeId getNodeId() {
            return NodeId.wrap(this.context, this.context.position() + this.bodyOffset);
        }

        public long getClock() {
            return this.context.getLong(this.context.position() + this.bodyOffset + 16);
        }

        public long getCount() {
            return this.context.getLong(this.context.position() + this.bodyOffset + 16 + 8);
        }

        public void writeElement(NodeId id, long clock, long count, boolean isDelta) {
            CounterContext.writeElementAtOffset(this.context, this.context.position() + this.bodyOffset, id, clock, count);
            if (isDelta) {
                this.context.putShort(this.context.position() + this.headerOffset, (short)this.elementIdx());
            }
            this.currentIsDelta = isDelta;
            this.moveToNext();
        }

        public void writeElement(NodeId id, long clock, long count) {
            this.writeElement(id, clock, count, false);
        }

        public int elementIdx() {
            return (this.bodyOffset - this.headerLength) / 32;
        }

        public ContextState duplicate() {
            return new ContextState(this.context, this.headerLength, this.headerOffset, this.bodyOffset, this.currentIsDelta);
        }

        public static ContextState allocate(int elementCount, int deltaCount) {
            assert (deltaCount <= elementCount);
            int hlength = 2 + deltaCount * 2;
            ByteBuffer context = ByteBuffer.allocate(hlength + elementCount * 32);
            context.putShort(0, (short)deltaCount);
            return new ContextState(context, hlength);
        }
    }

    private static class LazyHolder {
        private static final CounterContext counterContext = new CounterContext();

        private LazyHolder() {
        }
    }
}

