/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.support.common.runtime.graal;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;

@TargetClass(className="com.sun.beans.WeakCache")
@Substitute
final class SubstituteBeansWeakCache<K, V> {
    @Substitute
    private Map<K, Reference<V>> map = new WeakHashMap<K, Reference<V>>();

    @Substitute
    public SubstituteBeansWeakCache() {
    }

    @Substitute
    public V get(K key) {
        Reference<V> reference = this.map.get(key);
        if (reference == null) {
            return null;
        }
        V value = reference.get();
        if (value == null) {
            this.map.remove(key);
        }
        return value;
    }

    @Substitute
    public void put(K key, V value) {
        if (value != null) {
            this.map.put(key, new WeakReference<V>(value));
        } else {
            this.map.remove(key);
        }
    }

    @Substitute
    public void clear() {
        this.map.clear();
    }
}

