/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.concurrent;

import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.apache.camel.util.StringHelper;

public final class ThreadHelper {
    public static final String DEFAULT_PATTERN = "Camel Thread ##counter# - #name#";
    private static final Pattern INVALID_PATTERN = Pattern.compile(".*#\\w+#.*");
    private static AtomicLong threadCounter = new AtomicLong();

    private ThreadHelper() {
    }

    private static long nextThreadCounter() {
        return threadCounter.incrementAndGet();
    }

    public static String resolveThreadName(String pattern, String name) {
        String next;
        if (pattern == null) {
            pattern = DEFAULT_PATTERN;
        }
        String shortName = name.contains("?") ? StringHelper.before(name, "?") : name;
        String answer = StringHelper.replaceFirst(pattern, "#longName#", name);
        if (shortName != null) {
            answer = StringHelper.replaceFirst(answer, "#name#", shortName);
        }
        if (INVALID_PATTERN.matcher(answer = StringHelper.replaceFirst(answer, "#counter#", next = Long.toString(ThreadHelper.nextThreadCounter()))).matches()) {
            throw new IllegalArgumentException("Pattern is invalid: [" + pattern + "] in resolved thread name: [" + answer + "]");
        }
        return answer;
    }
}

