/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow;

import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.client.UndertowClient;
import io.undertow.connector.ByteBufferPool;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.DefaultComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.ResultBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorBuilder;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.xnio.AbstractIoFuture;
import org.xnio.IoFuture;
import org.xnio.OptionMap;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

public final class UndertowComponentVerifierExtension
extends DefaultComponentVerifierExtension {
    private ThreadLocal<WeakReference<UndertowClientWrapper>> clientCache = new ThreadLocal();

    UndertowComponentVerifierExtension() {
        super("undertow");
    }

    protected ComponentVerifierExtension.Result verifyParameters(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope((ComponentVerifierExtension.Result.Status)ComponentVerifierExtension.Result.Status.OK, (ComponentVerifierExtension.Scope)ComponentVerifierExtension.Scope.PARAMETERS);
        HashMap<String, Object> verifyParams = new HashMap<String, Object>(parameters);
        boolean isRest = verifyParams.entrySet().stream().anyMatch(e -> ((String)e.getKey()).startsWith("rest."));
        if (isRest) {
            String httpUri = this.getOption(verifyParams, "rest.host", String.class).orElse(null);
            String path = this.getOption(verifyParams, "rest.path", String.class).map(FileUtil::stripLeadingSeparator).orElse(null);
            if (ObjectHelper.isNotEmpty((Object)httpUri) && ObjectHelper.isNotEmpty((Object)path)) {
                httpUri = httpUri + "/" + path;
            }
            verifyParams.put("httpURI", httpUri);
            verifyParams.entrySet().removeIf(e -> ((String)e.getKey()).startsWith("rest."));
        }
        super.verifyParametersAgainstCatalog(builder, verifyParams);
        return builder.build();
    }

    protected ComponentVerifierExtension.Result verifyConnectivity(Map<String, Object> parameters) {
        URI uri;
        ResultBuilder builder = ResultBuilder.withStatusAndScope((ComponentVerifierExtension.Result.Status)ComponentVerifierExtension.Result.Status.OK, (ComponentVerifierExtension.Scope)ComponentVerifierExtension.Scope.CONNECTIVITY);
        HashMap<String, Object> verifyParams = new HashMap<String, Object>(parameters);
        boolean isRest = verifyParams.entrySet().stream().anyMatch(e -> ((String)e.getKey()).startsWith("rest."));
        String httpUri = null;
        String httpMethod = null;
        if (isRest) {
            httpUri = this.getOption(verifyParams, "rest.host", String.class).orElse(null);
            httpMethod = this.getOption(verifyParams, "rest.method", String.class).orElse(null);
            String path = this.getOption(verifyParams, "rest.path", String.class).map(FileUtil::stripLeadingSeparator).orElse(null);
            if (ObjectHelper.isNotEmpty((Object)httpUri) && ObjectHelper.isNotEmpty((Object)path)) {
                httpUri = httpUri + "/" + path;
            }
            verifyParams.put("httpURI", httpUri);
            verifyParams.entrySet().removeIf(e -> ((String)e.getKey()).startsWith("rest."));
        }
        if (ObjectHelper.isEmpty((Object)(uri = this.getHttpUri(verifyParams)))) {
            builder.error(ResultErrorBuilder.withMissingOption((String)"httpURI").detail("rest", (Object)isRest).build());
            return builder.build();
        }
        try {
            UndertowClientWrapper wrapper = this.getUndertowClientWrapper();
            ClientResponse response = wrapper.send(uri, Optional.ofNullable(httpMethod));
            if (response != null) {
                int code = response.getResponseCode();
                if (code == 401) {
                    builder.error(ResultErrorBuilder.withHttpCode((int)code).description(response.getStatus()).build());
                } else if (code >= 300 && code < 400) {
                    builder.error(ResultErrorBuilder.withHttpCode((int)code).description(response.getStatus()).parameterKey("httpURI").detail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.HttpAttribute.HTTP_REDIRECT, () -> Optional.ofNullable(response.getResponseHeaders().get(Headers.LOCATION).getFirst())).build());
                } else if (code >= 400) {
                    builder.error(ResultErrorBuilder.withHttpCode((int)code).description(response.getStatus()).build());
                }
            }
        }
        catch (Exception e2) {
            builder.error(ResultErrorBuilder.withException((Exception)e2).build());
        }
        return builder.build();
    }

    private URI getHttpUri(Map<String, Object> parameters) {
        String httpUri;
        URI uri = null;
        for (Object value : parameters.values()) {
            if (!(value instanceof URI)) continue;
            uri = (URI)URI.class.cast(value);
            break;
        }
        if (ObjectHelper.isEmpty(uri) && !ObjectHelper.isEmpty((Object)(httpUri = (String)parameters.get("httpURI")))) {
            uri = URI.create(UnsafeUriCharactersEncoder.encodeHttpURI((String)httpUri));
        }
        return uri;
    }

    private UndertowClientWrapper getUndertowClientWrapper() throws Exception {
        WeakReference<UndertowClientWrapper> ref = this.clientCache.get();
        UndertowClientWrapper wrapper = null;
        if (ref != null) {
            wrapper = (UndertowClientWrapper)ref.get();
        }
        if (wrapper == null) {
            wrapper = new UndertowClientWrapper();
            this.clientCache.set(new WeakReference<UndertowClientWrapper>(wrapper));
        }
        return wrapper;
    }

    private static final class UndertowClientResponseFuture
    extends AbstractIoFuture<ClientExchange>
    implements ClientCallback<ClientExchange> {
        private UndertowClientResponseFuture() {
        }

        public void completed(ClientExchange result) {
            result.setResponseListener((ClientCallback)new ClientCallback<ClientExchange>(){

                public void completed(ClientExchange result) {
                    this.setResult(result);
                }

                public void failed(IOException e) {
                    this.setException(e);
                }
            });
        }

        public void failed(IOException e) {
            this.setException(e);
        }
    }

    private final class UndertowClientWrapper {
        private final XnioWorker worker = Xnio.getInstance().createWorker(OptionMap.EMPTY);
        private final ByteBufferPool pool = new DefaultByteBufferPool(true, 17408);
        private UndertowClient client = UndertowClient.getInstance();

        private UndertowClientWrapper() throws IOException {
        }

        public ClientResponse send(URI uri, Optional<String> httpMethod) throws Exception {
            HttpString method = httpMethod.map(String::toUpperCase).map(Methods::fromString).orElse(Methods.GET);
            ClientRequest request = new ClientRequest();
            request.setMethod(method);
            request.setPath(URISupport.pathAndQueryOf((URI)uri));
            request.getRequestHeaders().put(Headers.HOST, String.format("%s:%s", uri.getHost(), uri.getPort()));
            IoFuture connectFuture = this.client.connect(uri, this.worker, this.pool, OptionMap.EMPTY);
            UndertowClientResponseFuture responseFuture = new UndertowClientResponseFuture();
            ((ClientConnection)connectFuture.get()).sendRequest(request, (ClientCallback)responseFuture);
            return ((ClientExchange)responseFuture.get()).getResponse();
        }
    }
}

