/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow;

import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import io.undertow.util.MimeMappings;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.undertow.ExchangeHeaders;
import org.apache.camel.component.undertow.UndertowHeaderFilterStrategy;
import org.apache.camel.component.undertow.UndertowHelper;
import org.apache.camel.component.undertow.UndertowHttpBinding;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.Pooled;

public class DefaultUndertowHttpBinding
implements UndertowHttpBinding {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultUndertowHttpBinding.class);
    private HeaderFilterStrategy headerFilterStrategy;

    public DefaultUndertowHttpBinding() {
        this.headerFilterStrategy = new UndertowHeaderFilterStrategy();
    }

    public DefaultUndertowHttpBinding(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    @Override
    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    @Override
    public Message toCamelMessage(HttpServerExchange httpExchange, Exchange exchange) throws Exception {
        DefaultMessage result = new DefaultMessage();
        this.populateCamelHeaders(httpExchange, (Map<String, Object>)result.getHeaders(), exchange);
        if (Methods.POST.equals(httpExchange.getRequestMethod()) || Methods.PUT.equals(httpExchange.getRequestMethod())) {
            byte[] bytes = this.readRequestBody(httpExchange);
            result.setBody((Object)bytes);
        } else {
            result.setBody(null);
        }
        return result;
    }

    @Override
    public Message toCamelMessage(ClientExchange clientExchange, Exchange exchange) throws Exception {
        DefaultMessage result = new DefaultMessage();
        this.populateCamelHeaders(clientExchange.getResponse(), (Map<String, Object>)result.getHeaders(), exchange);
        result.setBody((Object)this.readResponseBody(clientExchange));
        return result;
    }

    @Override
    public void populateCamelHeaders(HttpServerExchange httpExchange, Map<String, Object> headersMap, Exchange exchange) throws Exception {
        LOG.trace("populateCamelHeaders: {}");
        headersMap.put("CamelHttpMethod", httpExchange.getRequestMethod().toString());
        headersMap.put("CamelHttpUrl", httpExchange.getRequestURL());
        headersMap.put("CamelHttpUri", httpExchange.getRequestURI());
        headersMap.put("CamelHttpQuery", httpExchange.getQueryString());
        headersMap.put("CamelHttpRawQuery", httpExchange.getQueryString());
        String path = httpExchange.getRequestPath();
        headersMap.put("CamelHttpPath", path);
        if (LOG.isTraceEnabled()) {
            LOG.trace("HTTP-Method {}", (Object)httpExchange.getRequestMethod());
            LOG.trace("HTTP-Uri {}", (Object)httpExchange.getRequestURI());
        }
        for (HttpString name : httpExchange.getRequestHeaders().getHeaderNames()) {
            String value;
            if (name.toString().toLowerCase(Locale.US).equals("content-type")) {
                name = ExchangeHeaders.CONTENT_TYPE;
            }
            if (name.toString().toLowerCase(Locale.US).equals("authorization") && (value = httpExchange.getRequestHeaders().get(name).toString()) != null && value.trim().startsWith("Basic") && this.headerFilterStrategy != null && !this.headerFilterStrategy.applyFilterToExternalHeaders("CamelAuthentication", (Object)"Basic", exchange)) {
                UndertowHelper.appendHeader(headersMap, "CamelAuthentication", "Basic");
            }
            for (Object value2 : httpExchange.getRequestHeaders().get(name)) {
                LOG.trace("HTTP-header: {}", value2);
                if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(name.toString(), value2, exchange)) continue;
                UndertowHelper.appendHeader(headersMap, name.toString(), value2);
            }
        }
        Map pathParameters = httpExchange.getQueryParameters();
        if (!pathParameters.isEmpty()) {
            for (Map.Entry entry : pathParameters.entrySet()) {
                String name = (String)entry.getKey();
                Object values = entry.getValue();
                Iterator it = ObjectHelper.createIterator(values);
                while (it.hasNext()) {
                    Object value = it.next();
                    LOG.trace("URI-Parameter: {}", value);
                    if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(name, value, exchange)) continue;
                    UndertowHelper.appendHeader(headersMap, name, value);
                }
            }
        }
    }

    @Override
    public void populateCamelHeaders(ClientResponse response, Map<String, Object> headersMap, Exchange exchange) throws Exception {
        LOG.trace("populateCamelHeaders: {}");
        headersMap.put("CamelHttpResponseCode", response.getResponseCode());
        for (HttpString name : response.getResponseHeaders().getHeaderNames()) {
            String value;
            if (name.toString().toLowerCase(Locale.US).equals("content-type")) {
                name = ExchangeHeaders.CONTENT_TYPE;
            }
            if (name.toString().toLowerCase(Locale.US).equals("authorization") && (value = response.getResponseHeaders().get(name).toString()) != null && value.trim().startsWith("Basic") && this.headerFilterStrategy != null && !this.headerFilterStrategy.applyFilterToExternalHeaders("CamelAuthentication", (Object)"Basic", exchange)) {
                UndertowHelper.appendHeader(headersMap, "CamelAuthentication", "Basic");
            }
            for (Object value2 : response.getResponseHeaders().get(name)) {
                LOG.trace("HTTP-header: {}", value2);
                if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(name.toString(), value2, exchange)) continue;
                UndertowHelper.appendHeader(headersMap, name.toString(), value2);
            }
        }
    }

    @Override
    public Object toHttpResponse(HttpServerExchange httpExchange, Message message) {
        boolean failed = message.getExchange().isFailed();
        int defaultCode = failed ? 500 : 200;
        int code = (Integer)message.getHeader("CamelHttpResponseCode", (Object)defaultCode, Integer.TYPE);
        httpExchange.setResponseCode(code);
        TypeConverter tc = message.getExchange().getContext().getTypeConverter();
        for (Map.Entry entry : message.getHeaders().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            Iterator it = ObjectHelper.createIterator(value, null);
            while (it.hasNext()) {
                String headerValue = (String)tc.convertTo(String.class, it.next());
                if (headerValue == null || this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToCamelHeaders(key, (Object)headerValue, message.getExchange())) continue;
                LOG.trace("HTTP-Header: {}={}", (Object)key, (Object)headerValue);
                httpExchange.getResponseHeaders().add(new HttpString(key), headerValue);
            }
        }
        Exception exception = message.getExchange().getException();
        if (exception != null) {
            httpExchange.getResponseHeaders().put(Headers.CONTENT_TYPE, (String)MimeMappings.DEFAULT_MIME_MAPPINGS.get("txt"));
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            exception.printStackTrace(pw);
            String exceptionMessage = sw.toString();
            ExchangeHelper.setFailureHandled((Exchange)message.getExchange());
            return exceptionMessage;
        }
        String contentType = MessageHelper.getContentType((Message)message);
        if (contentType != null) {
            httpExchange.getResponseHeaders().put(Headers.CONTENT_TYPE, contentType);
            LOG.trace("Content-Type: {}", (Object)contentType);
        }
        return message.getBody();
    }

    @Override
    public Object toHttpRequest(ClientRequest clientRequest, Message message) {
        Object body = message.getBody();
        String contentType = MessageHelper.getContentType((Message)message);
        if (contentType != null) {
            clientRequest.getRequestHeaders().put(Headers.CONTENT_TYPE, contentType);
            LOG.trace("Content-Type: {}", (Object)contentType);
        }
        TypeConverter tc = message.getExchange().getContext().getTypeConverter();
        for (Map.Entry entry : message.getHeaders().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            Iterator it = ObjectHelper.createIterator(value, null);
            while (it.hasNext()) {
                String headerValue = (String)tc.convertTo(String.class, it.next());
                if (headerValue == null || this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToCamelHeaders(key, (Object)headerValue, message.getExchange())) continue;
                LOG.trace("HTTP-Header: {}={}", (Object)key, (Object)headerValue);
                clientRequest.getRequestHeaders().add(new HttpString(key), headerValue);
            }
        }
        return body;
    }

    private byte[] readRequestBody(HttpServerExchange httpExchange) throws IOException {
        Pooled pooledByteBuffer = httpExchange.getConnection().getBufferPool().allocate();
        ByteBuffer byteBuffer = (ByteBuffer)pooledByteBuffer.getResource();
        byteBuffer.clear();
        httpExchange.getRequestChannel().read(byteBuffer);
        int pos = byteBuffer.position();
        byteBuffer.rewind();
        byte[] bytes = new byte[pos];
        byteBuffer.get(bytes);
        byteBuffer.clear();
        pooledByteBuffer.free();
        return bytes;
    }

    private byte[] readResponseBody(ClientExchange httpExchange) throws IOException {
        Pooled pooledByteBuffer = httpExchange.getConnection().getBufferPool().allocate();
        ByteBuffer byteBuffer = (ByteBuffer)pooledByteBuffer.getResource();
        byteBuffer.clear();
        httpExchange.getResponseChannel().read(byteBuffer);
        int pos = byteBuffer.position();
        byteBuffer.rewind();
        byte[] bytes = new byte[pos];
        byteBuffer.get(bytes);
        byteBuffer.clear();
        pooledByteBuffer.free();
        return bytes;
    }
}

