/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tracing;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StaticService;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.LogListener;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.EventNotifierSupport;
import org.apache.camel.support.RoutePolicySupport;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.tracing.ActiveSpanManager;
import org.apache.camel.tracing.InjectAdapter;
import org.apache.camel.tracing.SpanAdapter;
import org.apache.camel.tracing.SpanDecorator;
import org.apache.camel.tracing.SpanKind;
import org.apache.camel.tracing.decorators.AbstractInternalSpanDecorator;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Tracer
extends ServiceSupport
implements RoutePolicyFactory,
StaticService,
CamelContextAware {
    protected static final Map<String, SpanDecorator> DECORATORS = new HashMap<String, SpanDecorator>();
    static final AutoCloseable NOOP_CLOSEABLE = () -> {};
    private static final Logger LOG = LoggerFactory.getLogger(Tracer.class);
    protected boolean encoding;
    private final TracingLogListener logListener = new TracingLogListener();
    private final TracingEventNotifier eventNotifier = new TracingEventNotifier();
    private Set<String> excludePatterns = new HashSet<String>(0);
    private InterceptStrategy tracingStrategy;
    private CamelContext camelContext;

    protected abstract void initTracer();

    protected abstract SpanAdapter startSendingEventSpan(String var1, SpanKind var2, SpanAdapter var3);

    protected abstract SpanAdapter startExchangeBeginSpan(Exchange var1, SpanDecorator var2, String var3, SpanKind var4, SpanAdapter var5);

    protected abstract void finishSpan(SpanAdapter var1);

    protected abstract void inject(SpanAdapter var1, InjectAdapter var2);

    public InterceptStrategy getTracingStrategy() {
        return this.tracingStrategy;
    }

    public void setTracingStrategy(InterceptStrategy tracingStrategy) {
        this.tracingStrategy = tracingStrategy;
    }

    public void addDecorator(SpanDecorator decorator) {
        DECORATORS.put(decorator.getComponent(), decorator);
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public Set<String> getExcludePatterns() {
        return this.excludePatterns;
    }

    public void setExcludePatterns(Set<String> excludePatterns) {
        this.excludePatterns = excludePatterns;
    }

    public boolean isEncoding() {
        return this.encoding;
    }

    public void setEncoding(boolean encoding) {
        this.encoding = encoding;
    }

    public void addExcludePattern(String pattern) {
        this.excludePatterns.add(pattern);
    }

    public RoutePolicy createRoutePolicy(CamelContext camelContext, String routeId, NamedNode route) {
        this.init(camelContext);
        return new TracingRoutePolicy();
    }

    public void init(CamelContext camelContext) {
        if (!camelContext.hasService((Object)this)) {
            try {
                camelContext.addService((Object)this, true, true);
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }
    }

    protected void doInit() throws Exception {
        ObjectHelper.notNull((Object)this.camelContext, (String)"CamelContext", (Object)((Object)this));
        this.camelContext.getManagementStrategy().addEventNotifier((EventNotifier)this.eventNotifier);
        if (!this.camelContext.getRoutePolicyFactories().contains((Object)this)) {
            this.camelContext.addRoutePolicyFactory((RoutePolicyFactory)this);
        }
        ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).addLogListener((LogListener)this.logListener);
        if (this.tracingStrategy != null) {
            ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).addInterceptStrategy(this.tracingStrategy);
        }
        this.initTracer();
        ServiceHelper.startService((Object)((Object)this.eventNotifier));
    }

    protected void doShutdown() throws Exception {
        this.camelContext.getManagementStrategy().removeEventNotifier((EventNotifier)this.eventNotifier);
        ServiceHelper.stopService((Object)((Object)this.eventNotifier));
        this.camelContext.getRoutePolicyFactories().remove((Object)this);
    }

    protected SpanDecorator getSpanDecorator(Endpoint endpoint) {
        SpanDecorator sd = null;
        String uri = endpoint.getEndpointUri();
        String[] splitURI = StringHelper.splitOnCharacter((String)uri, (String)":", (int)2);
        if (splitURI[1] != null) {
            String scheme = splitURI[0];
            sd = DECORATORS.get(scheme);
        }
        if (sd == null && endpoint instanceof DefaultEndpoint) {
            Component comp = ((DefaultEndpoint)endpoint).getComponent();
            String fqn = comp.getClass().getName();
            sd = DECORATORS.values().stream().filter(d -> fqn.equals(d.getComponentClassName())).findFirst().orElse(null);
        }
        if (sd == null) {
            sd = SpanDecorator.DEFAULT;
        }
        return sd;
    }

    private boolean isExcluded(Exchange exchange, Endpoint endpoint) {
        String url = endpoint.getEndpointUri();
        if (url != null && !this.excludePatterns.isEmpty()) {
            for (String pattern : this.excludePatterns) {
                if (!EndpointHelper.matchEndpoint((CamelContext)exchange.getContext(), (String)url, (String)pattern)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        ServiceLoader.load(SpanDecorator.class).forEach(d -> {
            SpanDecorator existing = DECORATORS.get(d.getComponent());
            if (existing == null || existing.getClass().isInstance(d)) {
                DECORATORS.put(d.getComponent(), (SpanDecorator)d);
            }
        });
    }

    private static final class TracingLogListener
    implements LogListener {
        private TracingLogListener() {
        }

        public String onLog(Exchange exchange, CamelLogger camelLogger, String message) {
            try {
                SpanAdapter span = ActiveSpanManager.getSpan(exchange);
                if (span != null) {
                    HashMap<String, String> fields = new HashMap<String, String>();
                    fields.put("message", message);
                    span.log(fields);
                }
            }
            catch (Exception t) {
                LOG.warn("Tracing: Failed to capture tracing data", (Throwable)t);
            }
            return message;
        }
    }

    private final class TracingRoutePolicy
    extends RoutePolicySupport {
        private TracingRoutePolicy() {
        }

        public void onExchangeBegin(Route route, Exchange exchange) {
            try {
                if (Tracer.this.isExcluded(exchange, route.getEndpoint())) {
                    return;
                }
                SpanDecorator sd = Tracer.this.getSpanDecorator(route.getEndpoint());
                SpanAdapter parent = ActiveSpanManager.getSpan(exchange);
                SpanAdapter span = Tracer.this.startExchangeBeginSpan(exchange, sd, sd.getOperationName(exchange, route.getEndpoint()), sd.getReceiverSpanKind(), parent);
                sd.pre(span, exchange, route.getEndpoint());
                ActiveSpanManager.activate(exchange, span);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Tracing: start server span={}", (Object)span);
                }
            }
            catch (Exception t) {
                LOG.warn("Tracing: Failed to capture tracing data", (Throwable)t);
            }
        }

        public void onExchangeDone(Route route, Exchange exchange) {
            try {
                if (Tracer.this.isExcluded(exchange, route.getEndpoint())) {
                    return;
                }
                SpanAdapter span = ActiveSpanManager.getSpan(exchange);
                if (span != null) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Tracing: finish server span={}", (Object)span);
                    }
                    SpanDecorator sd = Tracer.this.getSpanDecorator(route.getEndpoint());
                    sd.post(span, exchange, route.getEndpoint());
                    Tracer.this.finishSpan(span);
                    ActiveSpanManager.deactivate(exchange);
                } else {
                    LOG.warn("Tracing: could not find managed span for exchange={}", (Object)exchange);
                }
            }
            catch (Exception t) {
                LOG.warn("Tracing: Failed to capture tracing data", (Throwable)t);
            }
        }
    }

    private final class TracingEventNotifier
    extends EventNotifierSupport {
        private TracingEventNotifier() {
        }

        public void notify(CamelEvent event) throws Exception {
            try {
                if (event instanceof CamelEvent.ExchangeSendingEvent) {
                    CamelEvent.ExchangeSendingEvent ese = (CamelEvent.ExchangeSendingEvent)event;
                    SpanDecorator sd = Tracer.this.getSpanDecorator(ese.getEndpoint());
                    if (this.exclude(sd, ese.getExchange(), ese.getEndpoint())) {
                        return;
                    }
                    SpanAdapter parent = ActiveSpanManager.getSpan(ese.getExchange());
                    SpanAdapter span = Tracer.this.startSendingEventSpan(sd.getOperationName(ese.getExchange(), ese.getEndpoint()), sd.getInitiatorSpanKind(), parent);
                    sd.pre(span, ese.getExchange(), ese.getEndpoint());
                    Tracer.this.inject(span, sd.getInjectAdapter(ese.getExchange().getIn().getHeaders(), Tracer.this.encoding));
                    ActiveSpanManager.activate(ese.getExchange(), span);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Tracing: start client span={}", (Object)span);
                    }
                } else if (event instanceof CamelEvent.ExchangeSentEvent) {
                    CamelEvent.ExchangeSentEvent ese = (CamelEvent.ExchangeSentEvent)event;
                    SpanDecorator sd = Tracer.this.getSpanDecorator(ese.getEndpoint());
                    if (this.exclude(sd, ese.getExchange(), ese.getEndpoint())) {
                        return;
                    }
                    SpanAdapter span = ActiveSpanManager.getSpan(ese.getExchange());
                    if (span != null) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Tracing: start client span={}", (Object)span);
                        }
                        sd.post(span, ese.getExchange(), ese.getEndpoint());
                        Tracer.this.finishSpan(span);
                        ActiveSpanManager.deactivate(ese.getExchange());
                    } else {
                        LOG.warn("Tracing: could not find managed span for exchange={}", (Object)ese.getExchange());
                    }
                } else if (event instanceof CamelEvent.ExchangeAsyncProcessingStartedEvent) {
                    CamelEvent.ExchangeAsyncProcessingStartedEvent eap = (CamelEvent.ExchangeAsyncProcessingStartedEvent)event;
                    ActiveSpanManager.endScope(eap.getExchange());
                }
            }
            catch (Exception t) {
                LOG.warn("Tracing: Failed to capture tracing data", (Throwable)t);
            }
        }

        private boolean exclude(SpanDecorator sd, Exchange exchange, Endpoint endpoint) {
            return sd instanceof AbstractInternalSpanDecorator || !sd.newSpan() || Tracer.this.isExcluded(exchange, endpoint);
        }
    }
}

