/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tracing.propagation;

import java.util.Map;
import org.apache.camel.tracing.InjectAdapter;

public final class CamelMessagingHeadersInjectAdapter
implements InjectAdapter {
    static final String JMS_DASH = "_$dash$_";
    private final Map<String, Object> map;
    private final boolean jmsEncoding;

    public CamelMessagingHeadersInjectAdapter(Map<String, Object> map, boolean jmsEncoding) {
        this.map = map;
        this.jmsEncoding = jmsEncoding;
    }

    @Override
    public void put(String key, String value) {
        if (!key.startsWith("Camel")) {
            this.map.put(this.encodeDash(key), value);
        }
    }

    private String encodeDash(String key) {
        if (key == null || key.isEmpty() || !this.jmsEncoding) {
            return key;
        }
        return key.replace("-", JMS_DASH);
    }
}

