/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.DefaultPackageScanClassResolver;
import org.apache.camel.impl.scan.AssignableToPackageScanFilter;
import org.apache.camel.impl.scan.InvertingPackageScanFilter;
import org.apache.camel.spi.PackageScanFilter;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.test.CamelTestSupport;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CamelSpringTestSupport
extends CamelTestSupport {
    protected AbstractXmlApplicationContext applicationContext;

    protected abstract AbstractXmlApplicationContext createApplicationContext();

    @Override
    protected void setUp() throws Exception {
        this.applicationContext = this.createApplicationContext();
        CamelSpringTestSupport.assertNotNull((String)"Should have created a valid spring context", (Object)this.applicationContext);
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.applicationContext != null) {
            this.applicationContext.destroy();
        }
    }

    protected ApplicationContext getRouteExcludingApplicationContext() {
        GenericApplicationContext routeExcludingContext = new GenericApplicationContext();
        routeExcludingContext.registerBeanDefinition("excludingResolver", (BeanDefinition)new RootBeanDefinition(ExcludingPackageScanClassResolver.class));
        routeExcludingContext.refresh();
        ExcludingPackageScanClassResolver excludingResolver = (ExcludingPackageScanClassResolver)((Object)routeExcludingContext.getBean("excludingResolver"));
        List excluded = CastUtils.cast(Arrays.asList(this.excludeRoutes()));
        excludingResolver.setExcludedClasses(new HashSet(excluded));
        return routeExcludingContext;
    }

    protected Class<?>[] excludeRoutes() {
        Class[] classArray;
        Class<?> excludedRoute = this.excludeRoute();
        if (excludedRoute != null) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = excludedRoute;
        } else {
            classArray = new Class[]{};
        }
        return classArray;
    }

    protected Class<?> excludeRoute() {
        return null;
    }

    public <T> T getMandatoryBean(Class<T> type, String name) {
        Object value = this.applicationContext.getBean(name);
        CamelSpringTestSupport.assertNotNull((String)("No spring bean found for name <" + name + ">"), (Object)value);
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        CamelSpringTestSupport.fail((String)("Spring bean <" + name + "> is not an instanceof " + type.getName() + " but is of type " + ObjectHelper.className((Object)value)));
        return null;
    }

    @Override
    protected void assertValidContext(CamelContext context) {
        super.assertValidContext(context);
        List routes = context.getRoutes();
        int routeCount = this.getExpectedRouteCount();
        if (routeCount > 0) {
            CamelSpringTestSupport.assertNotNull((String)"Should have some routes defined", (Object)routes);
            CamelSpringTestSupport.assertTrue((String)"Should have at least one route", (routes.size() >= routeCount ? 1 : 0) != 0);
        }
        this.log.debug((Object)("Camel Routes: " + routes));
    }

    protected int getExpectedRouteCount() {
        return 1;
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        return SpringCamelContext.springCamelContext((ApplicationContext)this.applicationContext);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExcludingPackageScanClassResolver
    extends DefaultPackageScanClassResolver {
        private ExcludingPackageScanClassResolver() {
        }

        public void setExcludedClasses(Set<Class<?>> excludedClasses) {
            excludedClasses = excludedClasses == null ? Collections.EMPTY_SET : excludedClasses;
            this.addFilter((PackageScanFilter)new InvertingPackageScanFilter((PackageScanFilter)new AssignableToPackageScanFilter(excludedClasses)));
        }
    }
}

