/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test;

import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.camel.test.AvailablePort;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AvailablePortFinder {
    private static final Logger LOG = LoggerFactory.getLogger(AvailablePortFinder.class);
    private static final AvailablePortFinder INSTANCE = new AvailablePortFinder();
    private final Map<Integer, Port> portMapping = new ConcurrentHashMap<Integer, Port>();

    private AvailablePortFinder() {
    }

    public static Port find() {
        return INSTANCE.findPort();
    }

    synchronized Port findPort() {
        Port p;
        int port;
        Port prv;
        do {
            port = AvailablePortFinder.probePort(0);
            p = new Port(port);
        } while ((prv = AvailablePortFinder.INSTANCE.portMapping.putIfAbsent(port, p)) != null);
        return p;
    }

    synchronized Port findPort(int fromPort, int toPort) {
        for (int i = fromPort; i <= toPort; ++i) {
            try {
                int port = AvailablePortFinder.probePort(i);
                Port p = new Port(port);
                Port prv = AvailablePortFinder.INSTANCE.portMapping.putIfAbsent(port, p);
                if (prv != null) continue;
                return p;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        throw new IllegalStateException("Cannot find free port");
    }

    synchronized void release(Port port) {
        AvailablePortFinder.INSTANCE.portMapping.remove(port.getPort(), port);
    }

    public static int getNextAvailable() {
        try (Port port = INSTANCE.findPort();){
            int n = port.getPort();
            return n;
        }
    }

    public static int getNextRandomAvailable() {
        Random random = new Random();
        int fromPort = random.nextInt(10000, 65500);
        int toPort = random.nextInt(fromPort, 65500);
        try (Port port = INSTANCE.findPort(fromPort, toPort);){
            int n = port.getPort();
            return n;
        }
    }

    public static int getNextAvailable(int fromPort, int toPort) {
        try (Port port = INSTANCE.findPort(fromPort, toPort);){
            int n = port.getPort();
            return n;
        }
    }

    public static <T> int getSpecificPort(int portNumber, T failurePayload, Function<T, Integer> failureHandler) {
        Port port = INSTANCE.findPort(portNumber, portNumber);
        try {
            int n = port.getPort();
            if (port != null) {
                port.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (port != null) {
                    try {
                        port.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IllegalStateException e) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Unable to obtain the requested TCP port {}: {}", new Object[]{portNumber, e.getMessage(), e});
                } else {
                    LOG.warn("Unable to obtain the requested TCP port {}: {}", (Object)portNumber, (Object)e.getMessage());
                }
                return failureHandler.apply(failurePayload);
            }
        }
    }

    public static int probePort(int port) {
        return AvailablePort.probePort(null, port);
    }

    public class Port
    implements BeforeEachCallback,
    AfterAllCallback,
    AutoCloseable {
        final int port;
        String testClass;
        final Throwable creation;

        public Port(int port) {
            this.port = port;
            this.creation = new Throwable();
        }

        public int getPort() {
            return this.port;
        }

        public void release() {
            AvailablePortFinder.this.release(this);
        }

        public String toString() {
            return Integer.toString(this.port);
        }

        public void beforeEach(ExtensionContext context) throws Exception {
            this.testClass = context.getTestClass().map(Class::getName).orElse(null);
            LOG.info("Registering port {} for test {}", (Object)this.port, (Object)this.testClass);
        }

        public void afterAll(ExtensionContext context) throws Exception {
            this.release();
        }

        @Override
        public void close() {
            this.release();
        }
    }
}

